/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.dao;

import at.itsv.dvs.common.dao.BaseDao;
import at.itsv.dvs.common.dao.IFileDao;
import at.itsv.dvs.common.entity.File;
import at.itsv.dvs.common.entity.FileBestand;
import java.util.HashSet;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@Qualifier(value="fileDao")
public class FileDao
extends BaseDao<File>
implements IFileDao {
    @Override
    public String getPrimaryKey() {
        return "FileId";
    }

    @Override
    public void loadFileBestands(File entity) {
        Query query = this.getEntityManager().createNamedQuery("FileBestand.selectByFileId").setParameter("fileId", (Object)entity.getFileId());
        List fileBestandList = query.getResultList();
        entity.setFileBestands(new HashSet<FileBestand>(fileBestandList));
    }

    @Override
    public void saveFileBestands(File entity) {
        Query query = this.getEntityManager().createNamedQuery("FileBestand.selectByFileId").setParameter("fileId", (Object)entity.getFileId());
        List fileBestandList = query.getResultList();
        for (FileBestand fileBestand : fileBestandList) {
            boolean found = false;
            for (FileBestand fileBestand1 : entity.getFileBestands()) {
                if (fileBestand.getFileBestandId() != fileBestand1.getFileBestandId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getEntityManager().remove(fileBestand);
        }
        for (FileBestand fileBestand : entity.getFileBestands()) {
            if (fileBestand.getFileBestandId() != 0L) {
                this.getEntityManager().merge(fileBestand);
                continue;
            }
            this.getEntityManager().persist(fileBestand);
        }
    }

    @Override
    public File findByBestandAndType(long bestandId, String fileType) {
        Query query = this.getEntityManager().createNamedQuery("File.findByBestandAndType").setParameter("bestandId", (Object)bestandId).setParameter("fileType", (Object)fileType);
        try {
            return (File)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public File findByPathAndType(String path, String fileType) {
        Query query = this.getEntityManager().createNamedQuery("File.findByPathAndType").setParameter("path", (Object)path).setParameter("fileType", (Object)fileType);
        try {
            return (File)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

