/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.dao;

import at.itsv.dvs.common.dao.BaseDao;
import at.itsv.dvs.common.dao.IMandantDao;
import at.itsv.dvs.common.entity.Benutzer;
import at.itsv.dvs.common.entity.Mandant;
import at.itsv.dvs.common.entity.Prozess;
import at.itsv.dvs.common.entity.RegelMandant;
import at.itsv.dvs.common.exception.NonexistentEntityException;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@Qualifier(value="mandantDao")
public class MandantDao
extends BaseDao<Mandant>
implements IMandantDao {
    @Override
    public String getPrimaryKey() {
        return "MandantId";
    }

    @Override
    public Mandant select(String id) {
        return this.getEntityManager().find(Mandant.class, id);
    }

    @Override
    public void delete(String id) throws NonexistentEntityException {
        Mandant entity;
        try {
            entity = this.getEntityManager().getReference(Mandant.class, id);
        }
        catch (EntityNotFoundException enfe) {
            throw new NonexistentEntityException("The instance with id " + id + " no longer exists.", enfe);
        }
        this.getEntityManager().remove(entity);
    }

    @Override
    public void loadBenutzers(Mandant entity) {
        Query query = this.getEntityManager().createNamedQuery("Benutzer.selectByMandantId").setParameter("mandantId", (Object)entity.getMandantId());
        List benutzerList = query.getResultList();
        entity.setBenutzers(new HashSet<Benutzer>(benutzerList));
    }

    @Override
    public void loadRegelMandants(Mandant entity) {
        Query query = this.getEntityManager().createNamedQuery("RegelMandant.selectByMandantId").setParameter("mandantId", (Object)entity.getMandantId());
        List regelMandantList = query.getResultList();
        entity.setRegelMandants(new HashSet<RegelMandant>(regelMandantList));
    }

    @Override
    public void loadProzesses(Mandant entity) {
        Query query = this.getEntityManager().createNamedQuery("Prozess.selectByMandantId").setParameter("mandantId", (Object)entity.getMandantId());
        List prozessList = query.getResultList();
        entity.setProzesses(new HashSet<Prozess>(prozessList));
    }

    @Override
    public void saveBenutzers(Mandant entity) {
        Query query = this.getEntityManager().createNamedQuery("Benutzer.selectByMandantId").setParameter("mandantId", (Object)entity.getMandantId());
        List benutzerList = query.getResultList();
        for (Benutzer benutzer : benutzerList) {
            boolean found = false;
            for (Benutzer benutzer1 : entity.getBenutzers()) {
                if (benutzer.getBenutzerId() != benutzer1.getBenutzerId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getEntityManager().remove(benutzer);
        }
        for (Benutzer benutzer : entity.getBenutzers()) {
            if (benutzer.getBenutzerId() != 0L) {
                this.getEntityManager().merge(benutzer);
                continue;
            }
            this.getEntityManager().persist(benutzer);
        }
    }

    @Override
    public void saveRegelMandants(Mandant entity) {
        Query query = this.getEntityManager().createNamedQuery("RegelMandant.selectByMandantId").setParameter("mandantId", (Object)entity.getMandantId());
        List regelMandantList = query.getResultList();
        for (RegelMandant regelMandant : regelMandantList) {
            boolean found = false;
            for (RegelMandant regelMandant1 : entity.getRegelMandants()) {
                if (regelMandant.getRegelMandantId() != regelMandant1.getRegelMandantId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getEntityManager().remove(regelMandant);
        }
        for (RegelMandant regelMandant : entity.getRegelMandants()) {
            if (regelMandant.getRegelMandantId() != 0L) {
                this.getEntityManager().merge(regelMandant);
                continue;
            }
            this.getEntityManager().persist(regelMandant);
        }
    }

    @Override
    public void saveProzesses(Mandant entity) {
        Query query = this.getEntityManager().createNamedQuery("Prozess.selectByMandantId").setParameter("mandantId", (Object)entity.getMandantId());
        List prozessList = query.getResultList();
        for (Prozess prozess : prozessList) {
            boolean found = false;
            for (Prozess prozess1 : entity.getProzesses()) {
                if (prozess.getProzessId() != prozess1.getProzessId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getEntityManager().remove(prozess);
        }
        for (Prozess prozess : entity.getProzesses()) {
            if (prozess.getProzessId() != 0L) {
                this.getEntityManager().merge(prozess);
                continue;
            }
            this.getEntityManager().persist(prozess);
        }
    }
}

