/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.dao;

import at.itsv.dvs.common.dao.BaseDao;
import at.itsv.dvs.common.dao.IRegelDao;
import at.itsv.dvs.common.entity.Regel;
import at.itsv.dvs.common.entity.RegelMandant;
import java.util.HashSet;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
@Qualifier(value="regelDao")
public class RegelDao
extends BaseDao<Regel>
implements IRegelDao {
    @Override
    public Regel selectByKey(String key) {
        Query query = this.getEntityManager().createNamedQuery("Regel.selectByKey").setParameter("key", (Object)key);
        try {
            return (Regel)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public String getPrimaryKey() {
        return "RegelId";
    }

    @Override
    public void loadRegelMandants(Regel entity) {
        Query query = this.getEntityManager().createNamedQuery("RegelMandant.selectByRegelId").setParameter("regelId", (Object)entity.getRegelId());
        List regelMandantList = query.getResultList();
        entity.setRegelMandants(new HashSet<RegelMandant>(regelMandantList));
    }

    @Override
    public void saveRegelMandants(Regel entity) {
        Query query = this.getEntityManager().createNamedQuery("RegelMandant.selectByRegelId").setParameter("regelId", (Object)entity.getRegelId());
        List regelMandantList = query.getResultList();
        for (RegelMandant regelMandant : regelMandantList) {
            boolean found = false;
            for (RegelMandant regelMandant1 : entity.getRegelMandants()) {
                if (regelMandant.getRegelMandantId() != regelMandant1.getRegelMandantId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getEntityManager().remove(regelMandant);
        }
        for (RegelMandant regelMandant : entity.getRegelMandants()) {
            if (regelMandant.getRegelMandantId() != 0L) {
                this.getEntityManager().merge(regelMandant);
                continue;
            }
            this.getEntityManager().persist(regelMandant);
        }
    }
}

