/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.entity;

import at.itsv.dvs.common.entity.Mandant;
import at.itsv.dvs.common.entity.Rolle;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@Entity
@Table(name="benutzer", uniqueConstraints={@UniqueConstraint(columnNames={"login"})})
@NamedQueries(value={@NamedQuery(name="Benutzer.selectAll", query="SELECT b FROM Benutzer b"), @NamedQuery(name="Benutzer.selectByLoginAndMandantId", query="SELECT b FROM Benutzer b WHERE b.login = :login AND b.mandant.mandantId = :mandantId"), @NamedQuery(name="Benutzer.selectByMandantId", query="SELECT b FROM Benutzer b WHERE b.mandant.mandantId = :mandantId")})
public class Benutzer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long benutzerId;
    private String login;
    private String password;
    private String email;
    private boolean active;
    private String firstName;
    private String lastName;
    private Date lastChange;
    private Mandant mandant;
    private Set<Rolle> rolles = new HashSet<Rolle>(0);

    public Benutzer() {
    }

    public Benutzer(long benutzerId, String login, String password, boolean active, Date lastChange) {
        this.benutzerId = benutzerId;
        this.login = login;
        this.password = password;
        this.active = active;
        this.lastChange = lastChange;
    }

    public Benutzer(long benutzerId, String login, String password, String email, boolean active, String firstName, String lastName, Date lastChange, Mandant mandant, Set<Rolle> rolles) {
        this.benutzerId = benutzerId;
        this.login = login;
        this.password = password;
        this.email = email;
        this.active = active;
        this.firstName = firstName;
        this.lastName = lastName;
        this.lastChange = lastChange;
        this.mandant = mandant;
        this.rolles = rolles;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SeqBenutzer")
    @SequenceGenerator(name="SeqBenutzer", sequenceName="benutzer_benutzer_id_seq", allocationSize=1)
    @Column(name="benutzer_id", unique=true, nullable=false)
    public long getBenutzerId() {
        return this.benutzerId;
    }

    public void setBenutzerId(long benutzerId) {
        this.benutzerId = benutzerId;
    }

    @Column(name="login", unique=true, nullable=false, length=50)
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Column(name="password", nullable=false, length=50)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="email", length=50)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="active", nullable=false)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="first_name", length=50)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="last_name", length=50)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_change", nullable=false, length=29)
    public Date getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Date lastChange) {
        this.lastChange = lastChange;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="mandant_id", nullable=false)
    public Mandant getMandant() {
        return this.mandant;
    }

    public void setMandant(Mandant mandant) {
        this.mandant = mandant;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="login")
    public Set<Rolle> getRolles() {
        return this.rolles;
    }

    public void setRolles(Set<Rolle> rolles) {
        this.rolles = rolles;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.benutzerId).append(this.mandant == null ? null : this.mandant.getMandantId()).append(this.login).toString();
    }
}

