/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.entity;

import at.itsv.dvs.common.entity.File;
import at.itsv.dvs.common.entity.FileBestand;
import at.itsv.dvs.common.entity.XmlInfo;
import at.itsv.dvs.common.utils.DateTimeUtil;
import at.itsv.dvs.common.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@Entity
@Table(name="bestand")
@NamedQueries(value={@NamedQuery(name="Bestand.findByStatusAndMandant", query="select b, d from Bestand b left join fetch b.xmlInfo, FileBestand fb, File f, Data d where fb.bestand.bestandId=b.bestandId AND fb.file.fileId=f.fileId AND b.status= :status AND f.mandantId = :mandantId AND b.dataId = d.dataId order by b.proj, b.list"), @NamedQuery(name="Bestand.findToArchiv", query="select b from Bestand b where b.dataId IS NOT NULL AND b.status= :status AND b.lastChange < :lastchange"), @NamedQuery(name="Bestand.findByReferenznummer", query="select b from Bestand b where b.xmlInfo IS NOT NULL AND b.xmlInfo.referenzNummer= :referenzNummer")})
public class Bestand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long bestandId;
    private XmlInfo xmlInfo;
    private Long dataId;
    private String status;
    private String statusDds;
    private String zvstr;
    private String uvstr;
    private String erdt;
    private String proj;
    private String aenr;
    private String ebnr;
    private String eart;
    private String list;
    private Character test;
    private String zvob;
    private Integer satzAnzahl;
    private boolean vorlauf;
    private Long size;
    private Date lastChange;
    private String archiveFile;
    private Date archiveTimestamp;
    private Set<FileBestand> fileBestands = new HashSet<FileBestand>(0);
    private List<File> files = new ArrayList<File>();

    public Bestand() {
    }

    public Bestand(long bestandId, Long dataId, String status, boolean vorlauf, Date lastChange) {
        this.bestandId = bestandId;
        this.dataId = dataId;
        this.status = status;
        this.vorlauf = vorlauf;
        this.lastChange = lastChange;
    }

    public Bestand(long bestandId, XmlInfo xmlInfo, Long dataId, String status, String statusDds, String zvstr, String uvstr, String erdt, String proj, String aenr, String ebnr, String eart, String list, Character test, String zvob, Integer satzAnzahl, boolean vorlauf, Long size, Date lastChange, String archiveFile, Date archiveTimestamp, Set<FileBestand> fileBestands) {
        this.bestandId = bestandId;
        this.xmlInfo = xmlInfo;
        this.dataId = dataId;
        this.status = status;
        this.statusDds = statusDds;
        this.zvstr = zvstr;
        this.uvstr = uvstr;
        this.erdt = erdt;
        this.proj = proj;
        this.aenr = aenr;
        this.ebnr = ebnr;
        this.eart = eart;
        this.list = list;
        this.test = test;
        this.zvob = zvob;
        this.satzAnzahl = satzAnzahl;
        this.vorlauf = vorlauf;
        this.size = size;
        this.lastChange = lastChange;
        this.archiveFile = archiveFile;
        this.archiveTimestamp = archiveTimestamp;
        this.fileBestands = fileBestands;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SeqBestand")
    @SequenceGenerator(name="SeqBestand", sequenceName="bestand_bestand_id_seq", allocationSize=1)
    @Column(name="bestand_id", unique=true, nullable=false)
    public long getBestandId() {
        return this.bestandId;
    }

    public void setBestandId(long bestandId) {
        this.bestandId = bestandId;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="xml_info_id")
    public XmlInfo getXmlInfo() {
        return this.xmlInfo;
    }

    public void setXmlInfo(XmlInfo xmlInfo) {
        this.xmlInfo = xmlInfo;
    }

    @Column(name="data_id")
    public Long getDataId() {
        return this.dataId;
    }

    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    @Column(name="status", nullable=false, length=2)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name="status_dds", length=3)
    public String getStatusDds() {
        return this.statusDds;
    }

    public void setStatusDds(String statusDds) {
        this.statusDds = statusDds;
    }

    @Column(name="zvstr", length=2)
    public String getZvstr() {
        return this.zvstr;
    }

    public void setZvstr(String zvstr) {
        this.zvstr = zvstr;
    }

    @Column(name="uvstr", length=2)
    public String getUvstr() {
        return this.uvstr;
    }

    public void setUvstr(String uvstr) {
        this.uvstr = uvstr;
    }

    @Column(name="erdt", length=10)
    public String getErdt() {
        return this.erdt;
    }

    public void setErdt(String erdt) {
        this.erdt = erdt;
    }

    @Column(name="proj", length=2)
    public String getProj() {
        return this.proj;
    }

    public void setProj(String proj) {
        this.proj = proj;
    }

    @Column(name="aenr", length=4)
    public String getAenr() {
        return this.aenr;
    }

    public void setAenr(String aenr) {
        this.aenr = aenr;
    }

    @Column(name="ebnr", length=2)
    public String getEbnr() {
        return this.ebnr;
    }

    public void setEbnr(String ebnr) {
        this.ebnr = ebnr;
    }

    @Column(name="eart", length=2)
    public String getEart() {
        return this.eart;
    }

    public void setEart(String eart) {
        this.eart = eart;
    }

    @Column(name="list", length=2)
    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    @Column(name="test", length=1)
    public Character getTest() {
        return this.test;
    }

    public void setTest(Character test) {
        this.test = test;
    }

    @Column(name="zvob", length=20)
    public String getZvob() {
        return this.zvob;
    }

    public void setZvob(String zvob) {
        this.zvob = zvob;
    }

    @Column(name="satz_anzahl")
    public Integer getSatzAnzahl() {
        return this.satzAnzahl;
    }

    public void setSatzAnzahl(Integer satzAnzahl) {
        this.satzAnzahl = satzAnzahl;
    }

    @Column(name="vorlauf", nullable=false)
    public boolean isVorlauf() {
        return this.vorlauf;
    }

    public void setVorlauf(boolean vorlauf) {
        this.vorlauf = vorlauf;
    }

    @Column(name="size")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_change", nullable=false, length=29)
    public Date getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Date lastChange) {
        this.lastChange = lastChange;
    }

    @Transient
    public String getLastChangeFormated() {
        return DateTimeUtil.formatDate(this.lastChange, DateTimeUtil.SDF_DATE_DOT);
    }

    @Column(name="archive_file", length=500)
    public String getArchiveFile() {
        return this.archiveFile;
    }

    public void setArchiveFile(String archiveFile) {
        this.archiveFile = archiveFile;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="archive_timestamp", length=29)
    public Date getArchiveTimestamp() {
        return this.archiveTimestamp;
    }

    public void setArchiveTimestamp(Date archiveTimestamp) {
        this.archiveTimestamp = archiveTimestamp;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="bestand")
    public Set<FileBestand> getFileBestands() {
        return this.fileBestands;
    }

    public void setFileBestands(Set<FileBestand> fileBestands) {
        this.fileBestands = fileBestands;
    }

    @Transient
    public List<File> getFiles() {
        return this.files;
    }

    @Transient
    public void setFiles(List<File> files) {
        this.files = files;
    }

    @Transient
    public String getFilesAsHtmlString() {
        StringBuffer result = new StringBuffer(100);
        for (File file : this.files) {
            if (result.length() > 0) {
                result.append("<br/>");
            }
            result.append(file.getPath());
        }
        return result.toString();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.bestandId).append(this.dataId).append(this.status).append(this.zvstr).append(this.uvstr).append(this.proj).append(this.list).append(this.erdt).append(this.zvob).toString();
    }

    public static enum Status {
        IM("IM", "importiert mandant"),
        ED("ED", "exportiert dds"),
        ID("ID", "importiert dds"),
        EM("EM", "exportiert mandant"),
        EB("EB", "Empfangsbestaetigung");

        private String value;
        private String description;

        private Status(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public static Status parse(String valueStr) {
            String value = StringUtil.getSafeString(valueStr);
            for (Status status : Status.values()) {
                if (!status.value.equals(value)) continue;
                return status;
            }
            return null;
        }

        public String toString() {
            return this.name() + " : " + this.value + " - " + this.description;
        }
    }
}

