/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.entity;

import at.itsv.dvs.common.entity.FileBestand;
import at.itsv.dvs.common.entity.Paket;
import at.itsv.dvs.common.utils.StringUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="file")
@NamedQueries(value={@NamedQuery(name="File.selectAll", query="SELECT f FROM File f"), @NamedQuery(name="File.findByBestandAndType", query="SELECT f FROM File f, FileBestand fb WHERE fb.file.fileId=f.fileId AND fb.bestand.bestandId = :bestandId AND f.type = :fileType"), @NamedQuery(name="File.findByPathAndType", query="SELECT f FROM File f WHERE f.path = :path AND f.type = :fileType")})
public class File
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long fileId;
    private Paket paket;
    private String mandantId;
    private String path;
    private String type;
    private String format;
    private Date lastChange;
    private Set<FileBestand> fileBestands = new HashSet<FileBestand>(0);

    public File() {
    }

    public File(long fileId, String mandantId, String type, String format, Date lastChange) {
        this.fileId = fileId;
        this.mandantId = mandantId;
        this.type = type;
        this.format = format;
        this.lastChange = lastChange;
    }

    public File(long fileId, Paket paket, String mandantId, String path, String type, String format, Date lastChange, Set<FileBestand> fileBestands) {
        this.fileId = fileId;
        this.paket = paket;
        this.mandantId = mandantId;
        this.path = path;
        this.type = type;
        this.format = format;
        this.lastChange = lastChange;
        this.fileBestands = fileBestands;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SeqFile")
    @SequenceGenerator(name="SeqFile", sequenceName="file_file_id_seq", allocationSize=1)
    @Column(name="file_id", unique=true, nullable=false)
    public long getFileId() {
        return this.fileId;
    }

    public void setFileId(long fileId) {
        this.fileId = fileId;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="paket_id")
    public Paket getPaket() {
        return this.paket;
    }

    public void setPaket(Paket paket) {
        this.paket = paket;
    }

    @Column(name="mandant_id", nullable=false, length=2)
    public String getMandantId() {
        return this.mandantId;
    }

    public void setMandantId(String mandantId) {
        this.mandantId = mandantId;
    }

    @Column(name="path", length=500)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Column(name="type", nullable=false, length=2)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="format", nullable=false, length=2)
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_change", nullable=false, length=29)
    public Date getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Date lastChange) {
        this.lastChange = lastChange;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="file")
    public Set<FileBestand> getFileBestands() {
        return this.fileBestands;
    }

    public void setFileBestands(Set<FileBestand> fileBestands) {
        this.fileBestands = fileBestands;
    }

    public static enum Format {
        SP("SP", "SART-Paket", false),
        SS("SS", "SART-Sammelbestand", false),
        SE("SE", "SART-Einzelbestand", false),
        XA("XA", "XML-Archiv", true),
        XE("XE", "XML-Einzelbestand", true);

        private String value;
        private String description;
        private boolean xml;

        private Format(String value, String description, boolean xml) {
            this.value = value;
            this.description = description;
            this.xml = xml;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isXml() {
            return this.xml;
        }

        public static Format parse(String valueStr) {
            String value = StringUtil.getSafeString(valueStr);
            for (Format format : Format.values()) {
                if (!format.value.equals(value)) continue;
                return format;
            }
            return null;
        }

        public String toString() {
            return this.name() + " : " + this.value + " - " + this.description;
        }
    }

    public static enum Type {
        T1("IM", "importiert mandant"),
        T2("ED", "exportiert dds"),
        T3("ID", "importiert dds"),
        T4("EM", "exportiert mandant"),
        T5("IG", "intern generiert");

        private String value;
        private String description;

        private Type(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public static Type parse(String valueStr) {
            String value = StringUtil.getSafeString(valueStr);
            for (Type type : Type.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name() + " : " + this.value + " - " + this.description;
        }
    }
}

