/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.entity;

import at.itsv.dvs.common.utils.DateTimeUtil;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="protokoll")
public class Protokoll
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long protokollId;
    private String benutzer;
    private String message;
    private String level;
    private String jobGroup;
    private String jobName;
    private String code;
    private Date lastChange;

    public Protokoll() {
    }

    public Protokoll(long protokollId, String benutzer, String message, String level, String jobGroup, String jobName, String code, Date lastChange) {
        this.protokollId = protokollId;
        this.benutzer = benutzer;
        this.message = message;
        this.level = level;
        this.jobGroup = jobGroup;
        this.jobName = jobName;
        this.code = code;
        this.lastChange = lastChange;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SeqProtokoll")
    @SequenceGenerator(name="SeqProtokoll", sequenceName="protokoll_protokoll_id_seq", allocationSize=1)
    @Column(name="protokoll_id", unique=true, nullable=false)
    public long getProtokollId() {
        return this.protokollId;
    }

    public void setProtokollId(long protokollId) {
        this.protokollId = protokollId;
    }

    @Column(name="benutzer", nullable=true, length=50)
    public String getBenutzer() {
        return this.benutzer;
    }

    public void setBenutzer(String benutzer) {
        this.benutzer = benutzer;
    }

    @Column(name="message", nullable=false, length=1000)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Column(name="level", nullable=false, length=10)
    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    @Column(name="job_group", length=50)
    public String getJobGroup() {
        return this.jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    @Column(name="job_name", length=50)
    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Column(name="code", nullable=false, length=10)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_change", nullable=false, length=29)
    public Date getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Date lastChange) {
        this.lastChange = lastChange;
    }

    @Transient
    public String getLastChangeFormated() {
        return DateTimeUtil.formatDate(this.lastChange, DateTimeUtil.SDF_DATE_DOT);
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

