/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.entity;

import at.itsv.dvs.common.entity.Mandant;
import at.itsv.dvs.common.utils.StringUtil;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="prozess")
@NamedQueries(value={@NamedQuery(name="Prozess.selectAll", query="SELECT p FROM Prozess p"), @NamedQuery(name="Prozess.selectByMandantId", query="SELECT p FROM Prozess p WHERE p.mandant.mandantId = :mandantId"), @NamedQuery(name="Prozess.deleteAll", query="DELETE Prozess")})
public class Prozess
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long prozessId;
    private Mandant mandant;
    private String startZeitpunkt;
    private String type;
    private Date lastChange;

    public Prozess() {
    }

    public Prozess(long prozessId, Mandant mandant, String startZeitpunkt, String type, Date lastChange) {
        this.prozessId = prozessId;
        this.mandant = mandant;
        this.startZeitpunkt = startZeitpunkt;
        this.type = type;
        this.lastChange = lastChange;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SeqProzess")
    @SequenceGenerator(name="SeqProzess", sequenceName="prozess_prozess_id_seq", allocationSize=1)
    @Column(name="prozess_id", unique=true, nullable=false)
    public long getProzessId() {
        return this.prozessId;
    }

    public void setProzessId(long prozessId) {
        this.prozessId = prozessId;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="mandant_id", nullable=false)
    public Mandant getMandant() {
        return this.mandant;
    }

    public void setMandant(Mandant mandant) {
        this.mandant = mandant;
    }

    @Column(name="start_zeitpunkt", nullable=false, length=100)
    public String getStartZeitpunkt() {
        return this.startZeitpunkt;
    }

    public void setStartZeitpunkt(String startZeitpunkt) {
        this.startZeitpunkt = startZeitpunkt;
    }

    @Column(name="type", nullable=false, length=2)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_change", nullable=false, length=29)
    public Date getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Date lastChange) {
        this.lastChange = lastChange;
    }

    public static enum Type {
        P1("IM", "Import von Mandant", "processImportFromMandant"),
        P2("ED", "Export nach DDS", "processExportToDDS"),
        P3("ID", "Import von DDS", "processImportFromDDS"),
        P4("EM", "Export nach Mandant", "processExportToMandant"),
        P5("AR", "Archivierung", "processArchiveBestaende");

        private String value;
        private String description;
        private String beanName;

        private Type(String value, String description, String beanName) {
            this.value = value;
            this.description = description;
            this.beanName = beanName;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public static Type parse(String valueStr) {
            String value = StringUtil.getSafeString(valueStr);
            for (Type type : Type.values()) {
                if (!type.value.equals(value)) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name() + " : " + this.value + " - " + this.description;
        }
    }
}

