/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.entity;

import at.itsv.dvs.common.utils.StringUtil;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@Entity
@Table(name="rolle", uniqueConstraints={@UniqueConstraint(columnNames={"rolle_name", "login"})})
@NamedQueries(value={@NamedQuery(name="Rolle.selectAll", query="SELECT r FROM Rolle r"), @NamedQuery(name="Rolle.selectByLogin", query="SELECT r FROM Rolle r WHERE r.login = :login"), @NamedQuery(name="Rolle.selectByLoginAndName", query="SELECT r FROM Rolle r WHERE r.login = :login AND r.rolleName = :name")})
public class Rolle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long rolleId;
    private String login;
    private String rolleName;

    public Rolle() {
    }

    public Rolle(long rolleId, String login, String rolleName) {
        this.rolleId = rolleId;
        this.login = login;
        this.rolleName = rolleName;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SeqRolle")
    @SequenceGenerator(name="SeqRolle", sequenceName="rolle_rolle_id_seq", allocationSize=1)
    @Column(name="rolle_id", unique=true, nullable=false)
    public long getRolleId() {
        return this.rolleId;
    }

    public void setRolleId(long rolleId) {
        this.rolleId = rolleId;
    }

    @Column(name="login", nullable=false, length=50)
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Column(name="rolle_name", nullable=false, length=50)
    public String getRolleName() {
        return this.rolleName;
    }

    public void setRolleName(String rolleName) {
        this.rolleName = rolleName;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append(this.rolleId).append(this.rolleName).append(this.login).toString();
    }

    public static enum Name {
        Admin("adminrole", "Administrator role", "role.admin"),
        User("userrole", "User role", "role.user");

        private String value;
        private String description;
        private String resourceKey;

        private Name(String value, String description, String resourceKey) {
            this.value = value;
            this.description = description;
            this.resourceKey = resourceKey;
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        public static Name parse(String valueStr) {
            String value = StringUtil.getSafeString(valueStr);
            for (Name name : Name.values()) {
                if (!name.value.equals(value)) continue;
                return name;
            }
            return null;
        }

        public String toString() {
            return this.name() + " : " + this.value + " - " + this.description;
        }
    }
}

