/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.entity.datatype;

import java.security.KeyStore;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.hibernate.HibernateException;
import org.hibernate.type.StringClobType;
import org.postgresql.util.Base64;

public class PasswordStringType
extends StringClobType {
    private static final String DEEFAULT_ENCODING = "UTF-8";
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final SecretKey KEY = PasswordStringType.loadKey();
    private static final String KEY_ALIAS = "dvs-key";
    private static final String KEYSTORE_FILENAME = "/keystore.dvs";
    private static final String KEYSTORE_PASSWORD = "dvs_keystore";
    private static final String KEYSTORE_TYPE = "JCEKS";

    private static SecretKey loadKey() {
        try {
            KeyStore ks = KeyStore.getInstance(KEYSTORE_TYPE);
            ks.load(PasswordStringType.class.getResourceAsStream(KEYSTORE_FILENAME), KEYSTORE_PASSWORD.toCharArray());
            return ((KeyStore.SecretKeyEntry)ks.getEntry(KEY_ALIAS, new KeyStore.PasswordProtection(KEYSTORE_PASSWORD.toCharArray()))).getSecretKey();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (value != null) {
            try {
                Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
                cipher.init(2, new SecretKeySpec(KEY.getEncoded(), ENCRYPTION_ALGORITHM));
                value = new String(cipher.doFinal(Base64.decode(value)), DEEFAULT_ENCODING);
            }
            catch (Exception e) {
                if (e instanceof HibernateException) {
                    throw (HibernateException)e;
                }
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new HibernateException("Exception during decode", e);
            }
        }
        return value;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes()[0]);
        } else {
            try {
                Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
                cipher.init(1, new SecretKeySpec(KEY.getEncoded(), ENCRYPTION_ALGORITHM));
                st.setString(index, Base64.encodeBytes(cipher.doFinal(((String)value).getBytes(DEEFAULT_ENCODING))));
            }
            catch (Exception e) {
                if (e instanceof HibernateException) {
                    throw (HibernateException)e;
                }
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new HibernateException("Exception during encode", e);
            }
        }
    }

    @Override
    public int[] sqlTypes() {
        return new int[]{12};
    }
}

