/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.events;

import at.itsv.dvs.common.dao.IProtokollDao;
import at.itsv.dvs.common.entity.Protokoll;
import at.itsv.dvs.common.events.EventCodeEnum;
import at.itsv.dvs.common.events.EventLogLevel;
import at.itsv.dvs.common.spring.SpringAdapter;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class Event {
    private static final Logger ELOG = Logger.getLogger(Event.class);
    private IProtokollDao _protDao = (IProtokollDao)SpringAdapter.getContext().getBean("protokollDao");
    private String _code;
    private String _message;
    private EventLogLevel _logLevel;

    public Event() {
    }

    public Event(EventCodeEnum code) {
        this(code, null, true);
    }

    public Event(EventCodeEnum code, String ... properties) {
        this(code, properties, true);
    }

    public Event(EventCodeEnum code, String[] properties, boolean log) {
        this._code = code.name();
        this._message = this.embedProperties(code.getMessage(), properties);
        this._logLevel = code.getLogLevel();
        if (log) {
            ELOG.info(this._message);
        }
    }

    public Event(EventCodeEnum code, String codeNumber, String[] properties) {
        this._code = code.name().substring(0, 2) + codeNumber;
        this._message = this.embedProperties(code.getMessage(), properties);
        this._logLevel = code.getLogLevel();
        ELOG.info(this._message);
    }

    private String embedProperties(String rawMessage, String[] properties) {
        if (properties == null) {
            return rawMessage;
        }
        MessageFormat messageFormat = new MessageFormat(rawMessage);
        return messageFormat.format(properties);
    }

    public String getMessageWithCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCode());
        sb.append(" - ");
        sb.append(this.getMessageText());
        return sb.toString();
    }

    public String getMessageText() {
        return this._message;
    }

    public String getCode() {
        return this._code;
    }

    public EventLogLevel getLevel() {
        return this._logLevel;
    }

    public void setCode(String code) {
        this._code = code;
    }

    public void setMessageText(String message) {
        this._message = message;
    }

    public void writeProtokoll(String mandantId, String prozessType) {
        Protokoll protEntry = new Protokoll();
        protEntry.setJobGroup(mandantId);
        protEntry.setJobName(prozessType);
        protEntry.setLevel(this.getLevel().name());
        protEntry.setMessage(this.getMessageText());
        protEntry.setLastChange(new Date());
        protEntry.setCode(this.getCode());
        this._protDao.insert(protEntry);
    }
}

