/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.service;

import at.itsv.dvs.common.entity.Prozess;
import at.itsv.dvs.common.service.IProcess;
import at.itsv.dvs.common.spring.SpringAdapter;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzExecutor
implements Job {
    private static Logger _log = Logger.getLogger(QuartzExecutor.class);
    public static final String KEY_PROZZES_TYPE = "ProzessType";
    public static final String KEY_MANDANT_ID = "MandantId";

    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        String jobName = context.getJobDetail().getKey().getName();
        String groupName = context.getJobDetail().getKey().getGroup();
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String prozessType = (String)dataMap.get(KEY_PROZZES_TYPE);
        String mandantId = (String)dataMap.get(KEY_MANDANT_ID);
        _log.info("execute[" + jobName + ", " + groupName + "]: prozessType=" + prozessType + ", mandantId=" + mandantId);
        Prozess.Type type = Prozess.Type.parse(prozessType);
        IProcess process = (IProcess)SpringAdapter.getContext().getBean(type.getBeanName());
        if (process != null) {
            long startTime = System.currentTimeMillis();
            process.doProcess(mandantId);
            _log.info("Duration of Process " + prozessType + '/' + mandantId + " was " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }
}

