/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CsvUtils {
    private static final Logger LOGGER = Logger.getLogger(CsvUtils.class);

    public static void writeLine(BufferedWriter writer, String[] entry) throws IOException {
        boolean first = true;
        for (String param : entry) {
            if (!first) {
                writer.append(";");
            }
            first = false;
            if (param == null) continue;
            writer.append("\"");
            writer.append(param);
            writer.append("\"");
        }
        writer.newLine();
        writer.flush();
    }

    public static String[] readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            return new String[0];
        }
        String[] entry = line.split(";", -1);
        ArrayList<String> entryList = new ArrayList<String>();
        for (int i = 0; i < entry.length; ++i) {
            String param = entry[i];
            if (param.isEmpty()) {
                entryList.add(null);
                continue;
            }
            if (!param.startsWith("\"")) {
                entryList.add(param);
                continue;
            }
            while (!param.endsWith("\"")) {
                if (++i >= entry.length) {
                    throw new RuntimeException("illegal format ending'\"' expected");
                }
                param = param + ";" + entry[i];
            }
            entryList.add(param.substring(1, param.length() - 1));
        }
        return entryList.toArray(new String[0]);
    }

    public static void closeWriter(BufferedWriter writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug("ignore exception", e);
        }
    }

    public static void closeReader(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            LOGGER.debug("ignore exception", e);
        }
    }
}

