/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.utils;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;

public class DateHelper {
    public static final String FORMAT_YYYYMMDD_HHMM = "dd.MM.yyyy HH:mm";
    public static final String FORMAT_DDMMYYYY_HHMMSS = "dd.MM.yyyy HH:mm:ss";
    public static final String FORMAT_DDMMYYYY_HHMMSSMMM_2 = "dd.MM.yyyy HH:mm:ss.SSS";
    public static final String FORMAT_YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String FORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String FORMAT_DDMMYYYYHHMMSS = "ddMMyyyyHHmmss";
    public static final String FORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String FORMAT_YYYYMMDDHHMMSSMMM = "yyyyMMddHHmmssSSS";
    public static final String FORMAT_DDMMYYYY = "ddMMyyyy";
    public static final String FORMAT_DDMMYYYY_2 = "dd.MM.yyyy";
    private long _timeInMillis;
    private TimeZone _timeZone = null;
    private int _dateFormat = 0;
    private int _timeFormat = 2;
    private Locale _locale = Locale.GERMAN;
    private static final String DEFAULT_TIME_ZONE = "Europe/Vienna";
    public static final long ONE_MINUTE_IN_MILLISECONDS = 60000L;
    public static final long ONE_HOUR_IN_MILLISECONDS = 3600000L;
    public static final long ONE_DAY_IN_MILLISECONDS = 86400000L;

    public DateHelper() {
        this(System.currentTimeMillis(), TimeZone.getTimeZone(DEFAULT_TIME_ZONE));
    }

    public DateHelper(long timeInMillis) {
        this(timeInMillis, TimeZone.getTimeZone(DEFAULT_TIME_ZONE));
    }

    public DateHelper(TimeZone timezone) {
        this(System.currentTimeMillis(), timezone);
    }

    public DateHelper(long timeInMillis, TimeZone timezone) {
        this._timeInMillis = timeInMillis;
        this._timeZone = timezone;
    }

    public String toString() {
        DateFormat formater = DateFormat.getDateTimeInstance(this._dateFormat, this._timeFormat, this._locale);
        formater.setTimeZone(this._timeZone);
        return formater.format(new Date(this._timeInMillis));
    }

    public String getDate() {
        DateFormat formater = DateFormat.getDateInstance(this._dateFormat, this._locale);
        formater.setTimeZone(this._timeZone);
        return formater.format(new Date(this._timeInMillis));
    }

    public String getTime() {
        DateFormat formater = DateFormat.getTimeInstance(this._timeFormat, this._locale);
        formater.setTimeZone(this._timeZone);
        return formater.format(new Date(this._timeInMillis));
    }

    public void setDateFormat(int dateFormat) {
        this._dateFormat = dateFormat;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public void setTimeFormat(int timeFormat) {
        this._timeFormat = timeFormat;
    }

    public long getTimeInMillis() {
        return this._timeInMillis;
    }

    public static String getCurrentDateTimeAsString() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_HHMMSS, Locale.GERMAN);
        Date today = new Date();
        return dateFormatter.format(today);
    }

    public static String getCurrentDateAsString() {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_2, Locale.GERMAN);
        Date today = new Date();
        return dateFormatter.format(today);
    }

    public static String getCurrentDateAsString(String format) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(format, Locale.GERMAN);
        Date today = new Date();
        return dateFormatter.format(today);
    }

    public static Date getDateTimeAsDate(String strDate) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_HHMMSS, Locale.GERMAN);
        return dateFormatter.parse(strDate, new ParsePosition(0));
    }

    public static Date getDateFromString(String dateFormat, String date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat, Locale.GERMAN);
        return dateFormatter.parse(date, new ParsePosition(0));
    }

    public static Date getDateFromStringStrict(String dateFormat, String date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat, Locale.GERMAN);
        dateFormatter.setLenient(false);
        return dateFormatter.parse(date, new ParsePosition(0));
    }

    public static Date getDateFromString(String strDate) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_2, Locale.GERMAN);
        return dateFormatter.parse(strDate, new ParsePosition(0));
    }

    public static Date getDateFromStringWOSeparator(String strDate) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY, Locale.GERMAN);
        return dateFormatter.parse(strDate, new ParsePosition(0));
    }

    public static Date getDateFromStringWOSeparatorReversed(String strDate) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_YYYYMMDD, Locale.GERMAN);
        return dateFormatter.parse(strDate, new ParsePosition(0));
    }

    public static Date getNextDay(Date aDate) {
        Date nextDay = new Date(DateHelper.getNormalizedDate(aDate).getTime() + 86400000L);
        return nextDay;
    }

    public static String getStringFromDate(String format, Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(format, Locale.GERMAN);
        return dateFormatter.format(date);
    }

    public static String getStringFromDate(String format, Date date, TimeZone timeZone) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(format, Locale.GERMAN);
        dateFormatter.setTimeZone(timeZone);
        return dateFormatter.format(date);
    }

    public static String getStringWOSeparatorFromDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY, Locale.GERMAN);
        return dateFormatter.format(date);
    }

    public static String getCalendarAsShortString(Calendar cal) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_2, Locale.GERMAN);
        return dateFormatter.format(cal.getTime());
    }

    public static String getCalendarAsLongString(Calendar cal) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_HHMMSS, Locale.GERMAN);
        return dateFormatter.format(cal.getTime());
    }

    public static String getDateAsShortString(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_2, Locale.GERMAN);
        return dateFormatter.format(date);
    }

    public static String getDateAsLongString(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(FORMAT_DDMMYYYY_HHMMSS, Locale.GERMAN);
        return dateFormatter.format(date);
    }

    public static Date getNormalizedDate(Date aDate) {
        return new Date(DateUtils.truncate(aDate, 5).getTime());
    }

    public static Date getNoonDate(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getNullSafeClone(Date date) {
        return date == null ? null : (Date)date.clone();
    }

    public static Timestamp getTimestamp(Date date) {
        return date == null ? null : new Timestamp(date.getTime());
    }

    public static Date truncate(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        return cal.getTime();
    }

    public static Date extend(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        return cal.getTime();
    }

    public static boolean dateEqualsToday(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            int day = calendar.get(6);
            calendar.setTime(new Date());
            int todayYear = calendar.get(1);
            int todayDay = calendar.get(6);
            return year == todayYear && day == todayDay;
        }
        return false;
    }

    public static void extendDate(Date date) {
        if (date == null) {
            return;
        }
        Date newDate = DateHelper.extend(date);
        date.setTime(newDate.getTime());
    }

    public static String replaceDateInString(String placeHolder, String stringToReplace, Date date) {
        int endIndex;
        int startIndex;
        while ((startIndex = stringToReplace.indexOf(placeHolder)) != -1 && (endIndex = stringToReplace.indexOf("%", startIndex + placeHolder.length())) != -1) {
            String format = stringToReplace.substring(startIndex + placeHolder.length(), endIndex);
            String dateString = DateHelper.getStringFromDate(format, date);
            stringToReplace = stringToReplace.replaceAll(stringToReplace.substring(startIndex, endIndex + 1), dateString);
        }
        return stringToReplace;
    }
}

