/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeUtil {
    public static final SimpleDateFormat SDF_DATE = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat SDF_DATE_DASH = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat SDF_DATE_DOT = new SimpleDateFormat("dd.MM.yyyy");
    public static final SimpleDateFormat SDF_DATE_TIME = new SimpleDateFormat("yyyyMMddhhmmss");
    public static final SimpleDateFormat SDF_DATE_TIME_MINUS = new SimpleDateFormat("yyyyMMdd-hhmmss");
    public static final SimpleDateFormat SDF_DATE_TIME_DASH = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat SDF_DATE_TIME_DOT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    public static final SimpleDateFormat SDF_DATE_TIME_RFC822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    public static final SimpleDateFormat SDF_DATE_TIME_W3C = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);

    public static Date parseDate(String value) {
        return DateTimeUtil.parseDate(value, SDF_DATE);
    }

    public static String formatDate(Date value) {
        return DateTimeUtil.formatDate(value, SDF_DATE);
    }

    public static Date parseDate(String value, SimpleDateFormat sdf) {
        Date ret = null;
        if (value != null) {
            try {
                ret = sdf.parse(value);
                if (!value.equals(sdf.format(ret))) {
                    ret = null;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String formatDate(Date value, SimpleDateFormat sdf) {
        String ret = null;
        if (value != null) {
            ret = sdf.format(value);
        }
        return ret;
    }

    public static String convertDate(String value, SimpleDateFormat sdfFrom, SimpleDateFormat sdfTo) {
        Date date = DateTimeUtil.parseDate(value, sdfFrom);
        if (date != null) {
            return DateTimeUtil.formatDate(date, sdfTo);
        }
        return null;
    }

    public static SimpleDateFormat getDefaultSDF() {
        return SDF_DATE_TIME_DOT;
    }

    static {
        SDF_DATE_TIME_RFC822.setTimeZone(TimeZone.getTimeZone("GMT"));
        SDF_DATE_TIME_W3C.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

