/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.common.utils;

import at.itsv.dvs.common.utils.QueryParameter;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Query;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public final class HibernateHelper {
    private HibernateHelper() {
    }

    public static void silentFlush(Session session) {
        try {
            session.flush();
        }
        catch (HibernateException e) {
            throw SessionFactoryUtils.convertHibernateAccessException(e);
        }
    }

    public static Object loadLazyMappedByPK(Class clazz, Serializable primaryKey, HibernateTemplate template) throws ObjectRetrievalFailureException {
        Object valueObject = template.get(clazz, primaryKey);
        if (valueObject == null) {
            throw new ObjectRetrievalFailureException(clazz, (Object)primaryKey);
        }
        return valueObject;
    }

    public static String hqlEquals(String paramName, Object paramValue, List<QueryParameter> params) {
        StringBuilder fragment = new StringBuilder();
        fragment.append(paramName);
        if (paramValue != null) {
            params.add(new QueryParameter(paramName.replace('.', '_'), paramValue));
            fragment.append("=:");
            fragment.append(paramName.replace('.', '_'));
        } else {
            fragment.append(" IS NULL");
        }
        return fragment.toString();
    }

    public static String hqlNotEquals(String paramName, Object paramValue, List<QueryParameter> params) {
        StringBuilder fragment = new StringBuilder();
        fragment.append(paramName);
        if (paramValue != null) {
            params.add(new QueryParameter(paramName.replace('.', '_'), paramValue));
            fragment.append("!=:");
            fragment.append(paramName.replace('.', '_'));
        } else {
            fragment.append(" IS NOT NULL");
        }
        return fragment.toString();
    }

    public static void setQueryParameters(Query query, List<QueryParameter> params) {
        for (QueryParameter param : params) {
            query.setParameter(param.getName(), param.getValue());
        }
    }
}

