/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.tool.main;

import at.itsv.dvs.common.config.MandantTool;
import at.itsv.dvs.common.config.RegelTool;
import at.itsv.dvs.common.exception.DVSBaseException;
import at.itsv.dvs.common.spring.SpringAdapter;
import at.itsv.dvs.common.utils.StringUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class Tool {
    public static void main(String[] args) throws DVSBaseException, FileNotFoundException {
        Action action;
        Table table;
        if (args.length != 3) {
            System.out.println("Anzahl Parameter ung\u00fcltig: " + Tool.getUsage());
            System.exit(1);
        }
        if ((table = Table.parse(args[0])) == null) {
            System.out.println("Erster Parameter ung\u00fcltig: " + Tool.getUsage());
            System.exit(1);
        }
        if ((action = Action.parse(args[1])) == null) {
            System.out.println("Zweiter Parameter ung\u00fcltig: " + Tool.getUsage());
            System.exit(1);
        }
        String filename = args[2];
        block0 : switch (table) {
            case REGEL: {
                RegelTool regelTool = (RegelTool)SpringAdapter.getContext().getBean("regelTool");
                switch (action) {
                    case LIST: {
                        regelTool.list(new FileOutputStream(filename));
                        break block0;
                    }
                    case LISTDEFAULT: {
                        regelTool.listdefault(new FileOutputStream(filename));
                        break block0;
                    }
                    case INSERT: {
                        regelTool.insert(new FileInputStream(filename), filename);
                        break block0;
                    }
                }
                System.out.println("Zweiter Parameter f\u00fcr ersten Parameter " + table.value + " ung\u00fcltig: " + Tool.getUsage());
                System.exit(1);
                break;
            }
            case MANDANT: {
                MandantTool mandantTool = (MandantTool)SpringAdapter.getContext().getBean("mandantTool");
                switch (action) {
                    case LIST: {
                        mandantTool.list(new FileOutputStream(filename));
                        break block0;
                    }
                    case INSERT: {
                        mandantTool.insert(new FileInputStream(filename), filename);
                        break block0;
                    }
                }
                System.out.println("Zweiter Parameter f\u00fcr ersten Parameter " + table.value + " ung\u00fcltig: " + Tool.getUsage());
                System.exit(1);
            }
        }
    }

    private static String getUsage() {
        return "Usage:\nTool (REGEL|MANDANT) (-list|-listdefault|-insert) <file>";
    }

    private static enum Action {
        LIST("-list"),
        LISTDEFAULT("-listdefault"),
        INSERT("-insert");

        private String value;

        private Action(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Action parse(String valueStr) {
            String value = StringUtil.getSafeString(valueStr);
            for (Action action : Action.values()) {
                if (!action.value.equals(value)) continue;
                return action;
            }
            return null;
        }
    }

    private static enum Table {
        REGEL("REGEL"),
        MANDANT("MANDANT");

        private String value;

        private Table(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Table parse(String valueStr) {
            String value = StringUtil.getSafeString(valueStr);
            for (Table table : Table.values()) {
                if (!table.value.equals(value)) continue;
                return table;
            }
            return null;
        }
    }
}

