/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.annotations.Version;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.java.JavaXFactory;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.validator.ClassValidator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfiguration
extends Configuration {
    private static Log log = LogFactory.getLog(AnnotationConfiguration.class);
    public static final String ARTEFACT = "hibernate.mapping.precedence";
    public static final String DEFAULT_PRECEDENCE = "hbm, class";
    private Map namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<String, AnnotatedClassType> classTypes;
    private Set<String> defaultNamedQueryNames;
    private Set<String> defaultNamedNativeQueryNames;
    private Set<String> defaultSqlResulSetMappingNames;
    private Set<String> defaultNamedGenerators;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<String[]>> tableUniqueConstraints;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private List<XClass> annotatedClasses;
    private Map<String, XClass> annotatedClassEntities;
    private Map<String, Document> hbmEntities;
    private List<CacheHolder> caches;
    private List<Document> hbmDocuments;
    private String precedence = null;
    private boolean inSecondPass = false;
    private transient ReflectionManager reflectionManager;
    private boolean isDefaultProcessed = false;

    public AnnotationConfiguration() {
    }

    public AnnotationConfiguration(SettingsFactory sf) {
        super(sf);
    }

    protected List<XClass> orderAndFillHierarchy(List<XClass> original) {
        ArrayList<XClass> copy = new ArrayList<XClass>(original);
        for (XClass clazz : original) {
            XClass superClass = clazz.getSuperclass();
            while (!this.reflectionManager.equals(superClass, Object.class) && !copy.contains(superClass)) {
                if (superClass.isAnnotationPresent(Entity.class) || superClass.isAnnotationPresent(MappedSuperclass.class)) {
                    copy.add(superClass);
                }
                superClass = superClass.getSuperclass();
            }
        }
        ArrayList<XClass> workingCopy = new ArrayList<XClass>(copy);
        ArrayList<XClass> newList = new ArrayList<XClass>(copy.size());
        while (workingCopy.size() > 0) {
            XClass clazz = (XClass)workingCopy.get(0);
            this.orderHierarchy(workingCopy, newList, copy, clazz);
        }
        return newList;
    }

    private void orderHierarchy(List<XClass> copy, List<XClass> newList, List<XClass> original, XClass clazz) {
        if (this.reflectionManager.equals(clazz, Object.class)) {
            return;
        }
        this.orderHierarchy(copy, newList, original, clazz.getSuperclass());
        if (original.contains(clazz)) {
            if (!newList.contains(clazz)) {
                newList.add(clazz);
            }
            copy.remove(clazz);
        }
    }

    public AnnotationConfiguration addAnnotatedClass(Class persistentClass) throws MappingException {
        XClass persistentXClass = this.reflectionManager.toXClass(persistentClass);
        try {
            this.annotatedClasses.add(persistentXClass);
            return this;
        }
        catch (MappingException me) {
            log.error("Could not compile the mapping annotations", me);
            throw me;
        }
    }

    public AnnotationConfiguration addPackage(String packageName) throws MappingException {
        log.info("Mapping package " + packageName);
        try {
            AnnotationBinder.bindPackage(packageName, this.createExtendedMappings());
            return this;
        }
        catch (MappingException me) {
            log.error("Could not compile the mapping annotations", me);
            throw me;
        }
    }

    public ExtendedMappings createExtendedMappings() {
        return new ExtendedMappings(this.classes, this.collections, this.tables, this.namedQueries, this.namedSqlQueries, this.sqlResultSetMappings, this.defaultNamedQueryNames, this.defaultNamedNativeQueryNames, this.defaultSqlResulSetMappingNames, this.defaultNamedGenerators, this.imports, this.secondPasses, this.propertyReferences, this.namingStrategy, this.typeDefs, this.filterDefinitions, this.namedGenerators, this.joins, this.classTypes, this.extendsQueue, this.tableNameBinding, this.columnNameBindingPerTable, this.auxiliaryDatabaseObjects, this.generatorTables, this.tableUniqueConstraints, this.mappedByResolver, this.propertyRefResolver, this.reflectionManager);
    }

    @Override
    public void setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy, String region, boolean cacheLazyProperty) throws MappingException {
        this.caches.add(new CacheHolder(clazz, concurrencyStrategy, region, true, cacheLazyProperty));
    }

    @Override
    public void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) throws MappingException {
        this.caches.add(new CacheHolder(collectionRole, concurrencyStrategy, region, false, false));
    }

    @Override
    protected void reset() {
        super.reset();
        this.namedGenerators = new HashMap();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<String, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.defaultNamedQueryNames = new HashSet<String>();
        this.defaultNamedNativeQueryNames = new HashSet<String>();
        this.defaultSqlResulSetMappingNames = new HashSet<String>();
        this.defaultNamedGenerators = new HashSet<String>();
        this.tableUniqueConstraints = new HashMap<Table, List<String[]>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.annotatedClasses = new ArrayList<XClass>();
        this.caches = new ArrayList<CacheHolder>();
        this.hbmEntities = new HashMap<String, Document>();
        this.annotatedClassEntities = new HashMap<String, XClass>();
        this.hbmDocuments = new ArrayList<Document>();
        this.namingStrategy = EJB3NamingStrategy.INSTANCE;
        this.setEntityResolver(new EJB3DTDEntityResolver());
        this.reflectionManager = new JavaXFactory();
    }

    @Override
    protected void secondPassCompile() throws MappingException {
        StringTokenizer precedences;
        log.debug("Execute first pass mapping processing");
        ArrayList<XClass> tempAnnotatedClasses = new ArrayList<XClass>(this.annotatedClasses.size());
        for (XClass clazz : this.annotatedClasses) {
            if (clazz.isAnnotationPresent(Entity.class)) {
                this.annotatedClassEntities.put(clazz.getName(), clazz);
                tempAnnotatedClasses.add(clazz);
                continue;
            }
            if (!clazz.isAnnotationPresent(MappedSuperclass.class)) continue;
            tempAnnotatedClasses.add(clazz);
        }
        this.annotatedClasses = tempAnnotatedClasses;
        if (!this.isDefaultProcessed) {
            AnnotationBinder.bindDefaults(this.createExtendedMappings());
            this.isDefaultProcessed = true;
        }
        if (this.precedence == null) {
            this.precedence = this.getProperties().getProperty(ARTEFACT);
        }
        if (this.precedence == null) {
            this.precedence = DEFAULT_PRECEDENCE;
        }
        if (!(precedences = new StringTokenizer(this.precedence, ",; ", false)).hasMoreElements()) {
            throw new MappingException("hibernate.mapping.precedence cannot be empty: " + this.precedence);
        }
        while (precedences.hasMoreElements()) {
            String artifact = (String)precedences.nextElement();
            this.removeConflictedArtifact(artifact);
            this.processArtifactsOfType(artifact);
        }
        int cacheNbr = this.caches.size();
        for (int index = 0; index < cacheNbr; ++index) {
            CacheHolder cacheHolder = this.caches.get(index);
            if (cacheHolder.isClass) {
                super.setCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region, cacheHolder.cacheLazy);
                continue;
            }
            super.setCollectionCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region);
        }
        this.caches.clear();
        this.inSecondPass = true;
        this.processFkSecondPassInOrder();
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            SecondPass sp = (SecondPass)iter.next();
            if (!(sp instanceof CreateKeySecondPass)) continue;
            sp.doSecondPass(this.classes);
            iter.remove();
        }
        super.secondPassCompile();
        this.inSecondPass = false;
        for (Map.Entry<Table, List<String[]>> entry : this.tableUniqueConstraints.entrySet()) {
            Table table = entry.getKey();
            List<String[]> uniqueConstraints = entry.getValue();
            int uniqueIndexPerTable = 0;
            for (String[] columnNames : uniqueConstraints) {
                String keyName = "key" + uniqueIndexPerTable++;
                this.buildUniqueKeyFromColumnNames(columnNames, table, keyName);
            }
        }
        for (PersistentClass persistentClazz : this.classes.values()) {
            String className = persistentClazz.getClassName();
            if (!StringHelper.isNotEmpty(className)) continue;
            try {
                new ClassValidator(ReflectHelper.classForName(className), null, null, null, this.reflectionManager).apply(persistentClazz);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    private void processFkSecondPassInOrder() {
        log.debug("processing manytoone fk mappings");
        Iterator iter = this.secondPasses.iterator();
        TreeSet<FkSecondPass> fkSecondPasses = new TreeSet<FkSecondPass>(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof FkSecondPass) || !(o2 instanceof FkSecondPass)) {
                    throw new AssertionFailure("comparint FkSecondPass with non FkSecondPass");
                }
                FkSecondPass f1 = (FkSecondPass)o1;
                FkSecondPass f2 = (FkSecondPass)o2;
                int compare = f1.getValue().getTable().getQuotedName().compareTo(f2.getValue().getTable().getQuotedName());
                if (compare == 0) {
                    compare = f1.hashCode() < f2.hashCode() ? -1 : (f1.hashCode() == f2.hashCode() ? 0 : 1);
                }
                return compare;
            }
        });
        while (iter.hasNext()) {
            SecondPass sp = (SecondPass)iter.next();
            if (!(sp instanceof FkSecondPass)) continue;
            fkSecondPasses.add((FkSecondPass)sp);
            iter.remove();
        }
        if (fkSecondPasses.size() > 0) {
            HashMap isADependencyOf = new HashMap();
            ArrayList<FkSecondPass> orderedFkSecondPasses = new ArrayList<FkSecondPass>(fkSecondPasses.size());
            ArrayList<FkSecondPass> endOfQueueFkSecondPasses = new ArrayList<FkSecondPass>(fkSecondPasses.size());
            ArrayList<String> orderedTable = new ArrayList<String>(fkSecondPasses.size());
            for (FkSecondPass sp : fkSecondPasses) {
                String referenceEntityName = sp.getValue().getReferencedEntityName();
                PersistentClass classMapping = this.getClassMapping(referenceEntityName);
                if (sp.isInPrimaryKey()) {
                    String dependentTable = classMapping.getTable().getQuotedName();
                    if (!isADependencyOf.containsKey(dependentTable)) {
                        isADependencyOf.put(dependentTable, new HashSet());
                    }
                    String table = sp.getValue().getTable().getQuotedName();
                    ((Set)isADependencyOf.get(dependentTable)).add(table);
                    int beAfter = orderedTable.indexOf(dependentTable);
                    int beBefore = orderedFkSecondPasses.size();
                    Set dependencies = (Set)isADependencyOf.get(table);
                    if (dependencies != null) {
                        for (String tableDep : dependencies) {
                            int index = orderedTable.indexOf(tableDep);
                            beBefore = index != -1 && index < beBefore ? index : beBefore;
                        }
                    }
                    int currentIndex = orderedTable.indexOf(table);
                    if (beBefore < beAfter || currentIndex != -1 && (currentIndex < beAfter || currentIndex > beBefore)) {
                        StringBuilder sb = new StringBuilder("Foreign key circularity dependency involving the following tables: ");
                        sb.append(table);
                        if (beAfter > -1) {
                            sb.append(", ").append(dependentTable);
                        }
                        if (beBefore < orderedFkSecondPasses.size()) {
                            sb.append(", ").append(orderedTable.get(beBefore));
                        }
                        throw new AnnotationException(sb.toString());
                    }
                    currentIndex = currentIndex == -1 ? beBefore : currentIndex;
                    orderedTable.add(currentIndex, table);
                    orderedFkSecondPasses.add(currentIndex, sp);
                    continue;
                }
                endOfQueueFkSecondPasses.add(sp);
            }
            Iterator it = orderedFkSecondPasses.listIterator();
            while (it.hasNext()) {
                ((SecondPass)it.next()).doSecondPass(this.classes);
            }
            it = endOfQueueFkSecondPasses.listIterator();
            while (it.hasNext()) {
                ((SecondPass)it.next()).doSecondPass(this.classes);
            }
        }
    }

    private void processArtifactsOfType(String artifact) {
        if ("hbm".equalsIgnoreCase(artifact)) {
            log.debug("Process hbm files");
            for (Document document : this.hbmDocuments) {
                super.add(document);
            }
            this.hbmDocuments.clear();
            this.hbmEntities.clear();
        } else if ("class".equalsIgnoreCase(artifact)) {
            log.debug("Process annotated classes");
            List<XClass> orderedClasses = this.orderAndFillHierarchy(this.annotatedClasses);
            Map<XClass, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses, this.reflectionManager);
            ExtendedMappings mappings = this.createExtendedMappings();
            for (XClass clazz : orderedClasses) {
                AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, mappings);
            }
            this.annotatedClasses.clear();
            this.annotatedClassEntities.clear();
        } else {
            log.warn("Unknown artifact: " + artifact);
        }
    }

    private void removeConflictedArtifact(String artifact) {
        block3: {
            block2: {
                if (!"hbm".equalsIgnoreCase(artifact)) break block2;
                for (String entity : this.hbmEntities.keySet()) {
                    if (!this.annotatedClassEntities.containsKey(entity)) continue;
                    this.annotatedClasses.remove(this.annotatedClassEntities.get(entity));
                    this.annotatedClassEntities.remove(entity);
                }
                break block3;
            }
            if (!"class".equalsIgnoreCase(artifact)) break block3;
            for (String entity : this.annotatedClassEntities.keySet()) {
                if (!this.hbmEntities.containsKey(entity)) continue;
                this.hbmDocuments.remove(this.hbmEntities.get(entity));
                this.hbmEntities.remove(entity);
            }
        }
    }

    private void buildUniqueKeyFromColumnNames(String[] columnNames, Table table, String keyName) {
        int size = columnNames.length;
        Column[] columns = new Column[size];
        HashSet<Column> unbound = new HashSet<Column>();
        ExtendedMappings mappings = this.createExtendedMappings();
        for (int index = 0; index < size; ++index) {
            columns[index] = new Column(mappings.getPhysicalColumnName(columnNames[index], table));
            unbound.add(columns[index]);
        }
        for (Column column : columns) {
            if (!table.containsColumn(column)) continue;
            UniqueKey uc = table.getOrCreateUniqueKey(keyName);
            uc.addColumn(table.getColumn(column));
            unbound.remove(column);
        }
        if (unbound.size() > 0) {
            StringBuilder sb = new StringBuilder("Unable to create unique key constraint (");
            for (String columnName : columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") on table ").append(table.getName()).append(": ");
            for (Column column : unbound) {
                sb.append(column.getName()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" not found");
            throw new AnnotationException(sb.toString());
        }
    }

    @Override
    protected void parseMappingElement(Element subelement, String name) {
        Attribute rsrc = subelement.attribute("resource");
        Attribute file = subelement.attribute("file");
        Attribute jar = subelement.attribute("jar");
        Attribute pckg = subelement.attribute("package");
        Attribute clazz = subelement.attribute("class");
        if (rsrc != null) {
            log.debug(name + "<-" + rsrc);
            this.addResource(rsrc.getValue());
        } else if (jar != null) {
            log.debug(name + "<-" + jar);
            this.addJar(new File(jar.getValue()));
        } else if (file != null) {
            log.debug(name + "<-" + file);
            this.addFile(file.getValue());
        } else if (pckg != null) {
            log.debug(name + "<-" + pckg);
            this.addPackage(pckg.getValue());
        } else if (clazz != null) {
            log.debug(name + "<-" + clazz);
            Class loadedClass = null;
            try {
                loadedClass = ReflectHelper.classForName(clazz.getValue());
            }
            catch (ClassNotFoundException cnf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", cnf);
            }
            catch (NoClassDefFoundError ncdf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", ncdf);
            }
            this.addAnnotatedClass(loadedClass);
        } else {
            throw new MappingException("<mapping> element in configuration specifies no attributes");
        }
    }

    @Override
    protected void add(Document doc) throws MappingException {
        boolean ejb3Xml = "entity-mappings".equals(doc.getRootElement().getName());
        if (this.inSecondPass) {
            if (!ejb3Xml) {
                super.add(doc);
            }
        } else if (!ejb3Xml) {
            Element hmNode = doc.getRootElement();
            Attribute packNode = hmNode.attribute("package");
            String defaultPackage = packNode != null ? packNode.getValue() : "";
            HashSet entityNames = new HashSet();
            AnnotationConfiguration.findClassNames(defaultPackage, hmNode, entityNames);
            for (String entity : entityNames) {
                this.hbmEntities.put(entity, doc);
            }
            this.hbmDocuments.add(doc);
        } else {
            List<String> classnames = ((JavaXFactory)this.reflectionManager).getXMLContext().addDocument(doc);
            for (String classname : classnames) {
                try {
                    this.annotatedClasses.add(this.reflectionManager.classForName(classname, this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to load class defined in XML: " + classname, e);
                }
            }
        }
    }

    private static void findClassNames(String defaultPackage, Element startNode, Set names) {
        Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
        JoinedIterator classIterator = new JoinedIterator(classes);
        while (classIterator.hasNext()) {
            Element element = (Element)classIterator.next();
            String entityName = element.attributeValue("entity-name");
            if (entityName == null) {
                entityName = AnnotationConfiguration.getClassName(element.attribute("name"), defaultPackage);
            }
            names.add(entityName);
            AnnotationConfiguration.findClassNames(defaultPackage, element, names);
        }
    }

    private static String getClassName(Attribute name, String defaultPackage) {
        if (name == null) {
            return null;
        }
        String unqualifiedName = name.getValue();
        if (unqualifiedName == null) {
            return null;
        }
        if (unqualifiedName.indexOf(46) < 0 && defaultPackage != null) {
            return defaultPackage + '.' + unqualifiedName;
        }
        return unqualifiedName;
    }

    public void setPrecedence(String precedence) {
        this.precedence = precedence;
    }

    @Override
    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            ArrayList errors = new ArrayList();
            SAXReader saxReader = this.xmlHelper.createSAXReader("XML InputStream", errors, this.getEntityResolver());
            try {
                saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://java.sun.com/xml/ns/persistence/orm orm_1_0.xsd");
            }
            catch (SAXException e) {
                saxReader.setValidation(false);
            }
            Document doc = saxReader.read(new InputSource(xmlInputStream));
            if (errors.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)errors.get(0));
            }
            this.add(doc);
            AnnotationConfiguration annotationConfiguration = this;
            return annotationConfiguration;
        }
        catch (DocumentException e) {
            throw new MappingException("Could not parse mapping document in input stream", e);
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException ioe) {
                log.warn("Could not close input stream", ioe);
            }
        }
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    static {
        Version.touch();
    }

    private static class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;
        public boolean cacheLazy;

        public CacheHolder(String role, String usage, String region, boolean isClass, boolean cacheLazy) {
            this.role = role;
            this.usage = usage;
            this.region = region;
            this.isClass = isClass;
            this.cacheLazy = cacheLazy;
        }
    }
}

