/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Collections;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Type;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.WrappedInferredData;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.reflection.XProperty;
import org.hibernate.util.StringHelper;

public class IdBagBinder
extends BagBinder {
    protected Collection createCollection(PersistentClass persistentClass) {
        return new IdentifierBag(persistentClass);
    }

    protected boolean bindStarToManySecondPass(Map persistentClasses, String collType, Ejb3JoinColumn[] fkJoinColumns, Ejb3JoinColumn[] keyColumns, Ejb3JoinColumn[] inverseColumns, Ejb3Column[] elementColumns, boolean isEmbedded, XProperty property, boolean unique, TableBinder associationTableBinder, boolean ignoreNotFound, ExtendedMappings mappings) {
        boolean result = super.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, unique, associationTableBinder, ignoreNotFound, mappings);
        CollectionId collectionIdAnn = property.getAnnotation(CollectionId.class);
        if (collectionIdAnn != null) {
            String generatorType;
            SimpleValueBinder simpleValue = new SimpleValueBinder();
            WrappedInferredData propertyData = new WrappedInferredData(new PropertyInferredData(property, null, mappings.getReflectionManager()), "id");
            Ejb3Column[] idColumns = Ejb3Column.buildColumnFromAnnotation(collectionIdAnn.columns(), null, Nullability.FORCED_NOT_NULL, this.propertyHolder, propertyData, Collections.EMPTY_MAP, mappings);
            Table table = this.collection.getCollectionTable();
            simpleValue.setTable(table);
            simpleValue.setColumns(idColumns);
            Type typeAnn = collectionIdAnn.type();
            if (typeAnn == null || BinderHelper.isDefault(typeAnn.type())) {
                throw new AnnotationException("@CollectionId is missing type: " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
            }
            simpleValue.setExplicitType(typeAnn);
            simpleValue.setMappings(mappings);
            SimpleValue id = simpleValue.make();
            ((IdentifierCollection)this.collection).setIdentifier(id);
            String generator = collectionIdAnn.generator();
            if ("identity".equals(generator) || "assigned".equals(generator) || "sequence".equals(generator) || "native".equals(generator)) {
                generatorType = generator;
                generator = "";
            } else {
                generatorType = null;
            }
            BinderHelper.makeIdGenerator(id, generatorType, generator, mappings, this.localGenerators);
        }
        return result;
    }
}

