/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import javax.persistence.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XProperty;
import org.hibernate.util.StringHelper;

public class PropertyBinder {
    private static Log log = LogFactory.getLog(PropertyBinder.class);
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private String propertyAccessorName;
    private Ejb3Column[] columns;
    private PropertyHolder holder;
    private ExtendedMappings mappings;
    private Value value;
    private boolean insertable = true;
    private boolean updatable = true;
    private String cascade;
    private XProperty property;
    private XClass returnedClass;

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setPropertyAccessorName(String propertyAccessorName) {
        this.propertyAccessorName = propertyAccessorName;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.insertable = columns[0].isInsertable();
        this.updatable = columns[0].isUpdatable();
        this.columns = columns;
    }

    public void setHolder(PropertyHolder holder) {
        this.holder = holder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setCascade(String cascadeStrategy) {
        this.cascade = cascadeStrategy;
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    private void validateBind() {
    }

    private void validateMake() {
    }

    public Property bind() {
        this.validateBind();
        if (log.isDebugEnabled()) {
            log.debug("binding property " + this.name + " with lazy=" + this.lazy);
        }
        String containerClassName = this.holder == null ? null : this.holder.getClassName();
        SimpleValueBinder value = new SimpleValueBinder();
        value.setMappings(this.mappings);
        value.setPropertyName(this.name);
        value.setReturnedClassName(this.returnedClassName);
        value.setColumns(this.columns);
        value.setPersistentClassName(containerClassName);
        value.setType(this.property, this.returnedClass);
        value.setMappings(this.mappings);
        SimpleValue propertyValue = value.make();
        this.setValue(propertyValue);
        Property prop = this.make();
        this.holder.addProperty(prop, this.columns);
        return prop;
    }

    public Property make() {
        GenerationTime generated;
        this.validateMake();
        log.debug("Building property " + this.name);
        Property prop = new Property();
        prop.setName(this.name);
        prop.setValue(this.value);
        prop.setInsertable(this.insertable);
        prop.setUpdateable(this.updatable);
        prop.setLazy(this.lazy);
        prop.setCascade(this.cascade);
        prop.setPropertyAccessorName(this.propertyAccessorName);
        Generated ann = this.property != null ? this.property.getAnnotation(Generated.class) : null;
        GenerationTime generationTime = generated = ann != null ? ann.value() : null;
        if (generated != null && !GenerationTime.NEVER.equals((Object)generated)) {
            if (this.property.isAnnotationPresent(Version.class) && GenerationTime.INSERT.equals((Object)generated)) {
                throw new AnnotationException("@Generated(INSERT) on a @Version property not allowed, use ALWAYS: " + StringHelper.qualify(this.holder.getPath(), this.name));
            }
            if (prop.isInsertable()) {
                throw new AnnotationException("Cannot have @Generated property and insertable columns: " + StringHelper.qualify(this.holder.getPath(), this.name));
            }
            if (GenerationTime.ALWAYS.equals((Object)generated) && prop.isUpdateable()) {
                throw new AnnotationException("Cannot have @Generated(ALWAYS) property and updatable columns: " + StringHelper.qualify(this.holder.getPath(), this.name));
            }
            prop.setGeneration(PropertyGeneration.parse(generated.toString().toLowerCase()));
        }
        log.trace("Cascading " + this.name + " with " + this.cascade);
        return prop;
    }

    public void setProperty(XProperty property) {
        this.property = property;
    }

    public void setReturnedClass(XClass returnedClass) {
        this.returnedClass = returnedClass;
    }
}

