/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.hql.ast.tree.DeleteStatement;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Delete;
import org.hibernate.util.StringHelper;

public class MultiTableDeleteExecutor
extends AbstractStatementExecutor {
    private static final Log log = LogFactory.getLog(MultiTableDeleteExecutor.class);
    private final Queryable persister;
    private final String idInsertSelect;
    private final String[] deletes;

    public MultiTableDeleteExecutor(HqlSqlWalker walker) {
        super(walker, log);
        if (!walker.getSessionFactoryHelper().getFactory().getDialect().supportsTemporaryTables()) {
            throw new HibernateException("cannot perform multi-table deletes using dialect not supporting temp tables");
        }
        DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        String bulkTargetAlias = fromElement.getTableAlias();
        this.persister = fromElement.getQueryable();
        this.idInsertSelect = this.generateIdInsertSelect(this.persister, bulkTargetAlias, deleteStatement.getWhereClause());
        log.trace("Generated ID-INSERT-SELECT SQL (multi-table delete) : " + this.idInsertSelect);
        String[] tableNames = this.persister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.persister.getContraintOrderedTableKeyColumnClosure();
        String idSubselect = this.generateIdSubselect(this.persister);
        this.deletes = new String[tableNames.length];
        for (int i = tableNames.length - 1; i >= 0; --i) {
            Delete delete = new Delete().setTableName(tableNames[i]).setWhere("(" + StringHelper.join(", ", columnNames[i]) + ") IN (" + idSubselect + ")");
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                delete.setComment("bulk delete");
            }
            this.deletes[i] = delete.toStatementString();
        }
    }

    public String[] getSqlStatements() {
        return this.deletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        this.createTemporaryTableIfNecessary(this.persister, session);
        try {
            int resultCount;
            PreparedStatement ps;
            block13: {
                ps = null;
                resultCount = 0;
                try {
                    try {
                        ps = session.getBatcher().prepareStatement(this.idInsertSelect);
                        Iterator paramSpecifications = this.getWalker().getParameters().iterator();
                        int pos = 1;
                        while (paramSpecifications.hasNext()) {
                            ParameterSpecification paramSpec = (ParameterSpecification)paramSpecifications.next();
                            pos += paramSpec.bind(ps, parameters, session, pos);
                        }
                        resultCount = ps.executeUpdate();
                        Object var9_11 = null;
                        if (ps == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (ps == null) throw throwable;
                        session.getBatcher().closeStatement(ps);
                        throw throwable;
                    }
                    session.getBatcher().closeStatement(ps);
                }
                catch (SQLException e) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), e, "could not insert/select ids for bulk delete", this.idInsertSelect);
                }
            }
            for (int i = 0; i < this.deletes.length; ++i) {
                try {
                    Object var11_14;
                    try {
                        ps = session.getBatcher().prepareStatement(this.deletes[i]);
                        ps.executeUpdate();
                        var11_14 = null;
                        if (ps == null) continue;
                    }
                    catch (Throwable throwable) {
                        var11_14 = null;
                        if (ps == null) throw throwable;
                        session.getBatcher().closeStatement(ps);
                        throw throwable;
                    }
                    session.getBatcher().closeStatement(ps);
                    continue;
                }
                catch (SQLException e) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), e, "error performing bulk delete", this.deletes[i]);
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.dropTemporaryTableIfNecessary(this.persister, session);
        }
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

