/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.reflection.Filter;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XMethod;
import org.hibernate.reflection.XProperty;
import org.hibernate.reflection.java.JavaXAnnotatedElement;
import org.hibernate.reflection.java.JavaXFactory;
import org.hibernate.reflection.java.JavaXProperty;
import org.hibernate.reflection.java.generics.CompoundTypeEnvironment;
import org.hibernate.reflection.java.generics.TypeEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaXClass
extends JavaXAnnotatedElement
implements XClass {
    private final TypeEnvironment context;
    private final Class clazz;

    public JavaXClass(Class clazz, TypeEnvironment env, JavaXFactory factory) {
        super(clazz, factory);
        this.clazz = clazz;
        this.context = env;
    }

    @Override
    public String getName() {
        return this.toClass().getName();
    }

    @Override
    public XClass getSuperclass() {
        return this.getFactory().toXClass(this.toClass().getSuperclass(), new CompoundTypeEnvironment(this.getTypeEnvironment(), this.getFactory().getTypeEnvironment(this.toClass())));
    }

    @Override
    public XClass[] getInterfaces() {
        Class<?>[] classes = this.toClass().getInterfaces();
        int length = classes.length;
        XClass[] xClasses = new XClass[length];
        if (length != 0) {
            CompoundTypeEnvironment environment = new CompoundTypeEnvironment(this.getTypeEnvironment(), this.getFactory().getTypeEnvironment(this.toClass()));
            for (int index = 0; index < length; ++index) {
                xClasses[index] = this.getFactory().toXClass(classes[index], environment);
            }
        }
        return xClasses;
    }

    @Override
    public boolean isInterface() {
        return this.toClass().isInterface();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.toClass().getModifiers());
    }

    @Override
    public boolean isPrimitive() {
        return this.toClass().isPrimitive();
    }

    @Override
    public boolean isEnum() {
        return this.toClass().isEnum();
    }

    private List<XProperty> getDeclaredFieldProperties(Filter filter) {
        LinkedList<XProperty> result = new LinkedList<XProperty>();
        for (Field f : this.toClass().getDeclaredFields()) {
            if (!JavaXProperty.isProperty(f, this.getTypeEnvironment().bind(f.getGenericType()), filter)) continue;
            result.add(this.getFactory().getXProperty(f, this));
        }
        return result;
    }

    private List<XProperty> getDeclaredMethodProperties(Filter filter) {
        LinkedList<XProperty> result = new LinkedList<XProperty>();
        for (Method m : this.toClass().getDeclaredMethods()) {
            if (!JavaXProperty.isProperty(m, this.getTypeEnvironment().bind(m.getGenericReturnType()), filter)) continue;
            result.add(this.getFactory().getXProperty(m, this));
        }
        return result;
    }

    @Override
    public List<XProperty> getDeclaredProperties(String accessType) {
        return this.getDeclaredProperties(accessType, XClass.DEFAULT_FILTER);
    }

    @Override
    public List<XProperty> getDeclaredProperties(String accessType, Filter filter) {
        if (accessType.equals("field")) {
            return this.getDeclaredFieldProperties(filter);
        }
        if (accessType.equals("property")) {
            return this.getDeclaredMethodProperties(filter);
        }
        throw new IllegalArgumentException("Unknown access type " + accessType);
    }

    @Override
    public List<XMethod> getDeclaredMethods() {
        LinkedList<XMethod> result = new LinkedList<XMethod>();
        for (Method m : this.toClass().getDeclaredMethods()) {
            result.add(this.getFactory().getXMethod(m, this));
        }
        return result;
    }

    public Class<?> toClass() {
        return this.clazz;
    }

    @Override
    public boolean isAssignableFrom(XClass c) {
        return this.toClass().isAssignableFrom(((JavaXClass)c).toClass());
    }

    boolean isArray() {
        return this.toClass().isArray();
    }

    TypeEnvironment getTypeEnvironment() {
        return this.context;
    }
}

