/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.util.ArrayHelper;

public class StatisticsImpl
implements Statistics,
StatisticsImplementor {
    private static final Log log = LogFactory.getLog(StatisticsImpl.class);
    private SessionFactoryImplementor sessionFactory;
    private boolean isStatisticsEnabled;
    private long startTime;
    private long sessionOpenCount;
    private long sessionCloseCount;
    private long flushCount;
    private long connectCount;
    private long prepareStatementCount;
    private long closeStatementCount;
    private long entityLoadCount;
    private long entityUpdateCount;
    private long entityInsertCount;
    private long entityDeleteCount;
    private long entityFetchCount;
    private long collectionLoadCount;
    private long collectionUpdateCount;
    private long collectionRemoveCount;
    private long collectionRecreateCount;
    private long collectionFetchCount;
    private long secondLevelCacheHitCount;
    private long secondLevelCacheMissCount;
    private long secondLevelCachePutCount;
    private long queryExecutionCount;
    private long queryExecutionMaxTime;
    private String queryExecutionMaxTimeQueryString;
    private long queryCacheHitCount;
    private long queryCacheMissCount;
    private long queryCachePutCount;
    private long commitedTransactionCount;
    private long transactionCount;
    private long optimisticFailureCount;
    private final Map secondLevelCacheStatistics = new HashMap();
    private final Map entityStatistics = new HashMap();
    private final Map collectionStatistics = new HashMap();
    private final Map queryStatistics = new HashMap();

    public StatisticsImpl() {
        this.clear();
    }

    public StatisticsImpl(SessionFactoryImplementor sessionFactory) {
        this.clear();
        this.sessionFactory = sessionFactory;
    }

    public synchronized void clear() {
        this.secondLevelCacheHitCount = 0L;
        this.secondLevelCacheMissCount = 0L;
        this.secondLevelCachePutCount = 0L;
        this.sessionCloseCount = 0L;
        this.sessionOpenCount = 0L;
        this.flushCount = 0L;
        this.connectCount = 0L;
        this.prepareStatementCount = 0L;
        this.closeStatementCount = 0L;
        this.entityDeleteCount = 0L;
        this.entityInsertCount = 0L;
        this.entityUpdateCount = 0L;
        this.entityLoadCount = 0L;
        this.entityFetchCount = 0L;
        this.collectionRemoveCount = 0L;
        this.collectionUpdateCount = 0L;
        this.collectionRecreateCount = 0L;
        this.collectionLoadCount = 0L;
        this.collectionFetchCount = 0L;
        this.queryExecutionCount = 0L;
        this.queryCacheHitCount = 0L;
        this.queryExecutionMaxTime = 0L;
        this.queryExecutionMaxTimeQueryString = null;
        this.queryCacheMissCount = 0L;
        this.queryCachePutCount = 0L;
        this.transactionCount = 0L;
        this.commitedTransactionCount = 0L;
        this.optimisticFailureCount = 0L;
        this.secondLevelCacheStatistics.clear();
        this.entityStatistics.clear();
        this.collectionStatistics.clear();
        this.queryStatistics.clear();
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void openSession() {
        ++this.sessionOpenCount;
    }

    public synchronized void closeSession() {
        ++this.sessionCloseCount;
    }

    public synchronized void flush() {
        ++this.flushCount;
    }

    public synchronized void connect() {
        ++this.connectCount;
    }

    public synchronized void loadEntity(String entityName) {
        ++this.entityLoadCount;
        ++this.getEntityStatistics((String)entityName).loadCount;
    }

    public synchronized void fetchEntity(String entityName) {
        ++this.entityFetchCount;
        ++this.getEntityStatistics((String)entityName).fetchCount;
    }

    public synchronized EntityStatistics getEntityStatistics(String entityName) {
        EntityStatistics es = (EntityStatistics)this.entityStatistics.get(entityName);
        if (es == null) {
            es = new EntityStatistics(entityName);
            this.entityStatistics.put(entityName, es);
        }
        return es;
    }

    public synchronized void updateEntity(String entityName) {
        ++this.entityUpdateCount;
        EntityStatistics es = this.getEntityStatistics(entityName);
        ++es.updateCount;
    }

    public synchronized void insertEntity(String entityName) {
        ++this.entityInsertCount;
        EntityStatistics es = this.getEntityStatistics(entityName);
        ++es.insertCount;
    }

    public synchronized void deleteEntity(String entityName) {
        ++this.entityDeleteCount;
        EntityStatistics es = this.getEntityStatistics(entityName);
        ++es.deleteCount;
    }

    public synchronized CollectionStatistics getCollectionStatistics(String role) {
        CollectionStatistics cs = (CollectionStatistics)this.collectionStatistics.get(role);
        if (cs == null) {
            cs = new CollectionStatistics(role);
            this.collectionStatistics.put(role, cs);
        }
        return cs;
    }

    public synchronized void loadCollection(String role) {
        ++this.collectionLoadCount;
        ++this.getCollectionStatistics((String)role).loadCount;
    }

    public synchronized void fetchCollection(String role) {
        ++this.collectionFetchCount;
        ++this.getCollectionStatistics((String)role).fetchCount;
    }

    public synchronized void updateCollection(String role) {
        ++this.collectionUpdateCount;
        ++this.getCollectionStatistics((String)role).updateCount;
    }

    public synchronized void recreateCollection(String role) {
        ++this.collectionRecreateCount;
        ++this.getCollectionStatistics((String)role).recreateCount;
    }

    public synchronized void removeCollection(String role) {
        ++this.collectionRemoveCount;
        ++this.getCollectionStatistics((String)role).removeCount;
    }

    public synchronized SecondLevelCacheStatistics getSecondLevelCacheStatistics(String regionName) {
        SecondLevelCacheStatistics slcs = (SecondLevelCacheStatistics)this.secondLevelCacheStatistics.get(regionName);
        if (slcs == null) {
            if (this.sessionFactory == null) {
                return null;
            }
            Cache cache = this.sessionFactory.getSecondLevelCacheRegion(regionName);
            if (cache == null) {
                return null;
            }
            slcs = new SecondLevelCacheStatistics(cache);
            this.secondLevelCacheStatistics.put(regionName, slcs);
        }
        return slcs;
    }

    public synchronized void secondLevelCachePut(String regionName) {
        ++this.secondLevelCachePutCount;
        ++this.getSecondLevelCacheStatistics((String)regionName).putCount;
    }

    public synchronized void secondLevelCacheHit(String regionName) {
        ++this.secondLevelCacheHitCount;
        ++this.getSecondLevelCacheStatistics((String)regionName).hitCount;
    }

    public synchronized void secondLevelCacheMiss(String regionName) {
        ++this.secondLevelCacheMissCount;
        ++this.getSecondLevelCacheStatistics((String)regionName).missCount;
    }

    public synchronized void queryExecuted(String hql, int rows, long time) {
        ++this.queryExecutionCount;
        if (this.queryExecutionMaxTime < time) {
            this.queryExecutionMaxTime = time;
            this.queryExecutionMaxTimeQueryString = hql;
        }
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            qs.executed(rows, time);
        }
    }

    public synchronized void queryCacheHit(String hql, String regionName) {
        ++this.queryCacheHitCount;
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            ++qs.cacheHitCount;
        }
        SecondLevelCacheStatistics slcs = this.getSecondLevelCacheStatistics(regionName);
        ++slcs.hitCount;
    }

    public synchronized void queryCacheMiss(String hql, String regionName) {
        ++this.queryCacheMissCount;
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            ++qs.cacheMissCount;
        }
        SecondLevelCacheStatistics slcs = this.getSecondLevelCacheStatistics(regionName);
        ++slcs.missCount;
    }

    public synchronized void queryCachePut(String hql, String regionName) {
        ++this.queryCachePutCount;
        if (hql != null) {
            QueryStatistics qs = this.getQueryStatistics(hql);
            ++qs.cachePutCount;
        }
        SecondLevelCacheStatistics slcs = this.getSecondLevelCacheStatistics(regionName);
        ++slcs.putCount;
    }

    public synchronized QueryStatistics getQueryStatistics(String queryString) {
        QueryStatistics qs = (QueryStatistics)this.queryStatistics.get(queryString);
        if (qs == null) {
            qs = new QueryStatistics(queryString);
            this.queryStatistics.put(queryString, qs);
        }
        return qs;
    }

    public long getEntityDeleteCount() {
        return this.entityDeleteCount;
    }

    public long getEntityInsertCount() {
        return this.entityInsertCount;
    }

    public long getEntityLoadCount() {
        return this.entityLoadCount;
    }

    public long getEntityFetchCount() {
        return this.entityFetchCount;
    }

    public long getEntityUpdateCount() {
        return this.entityUpdateCount;
    }

    public long getQueryExecutionCount() {
        return this.queryExecutionCount;
    }

    public long getQueryCacheHitCount() {
        return this.queryCacheHitCount;
    }

    public long getQueryCacheMissCount() {
        return this.queryCacheMissCount;
    }

    public long getQueryCachePutCount() {
        return this.queryCachePutCount;
    }

    public long getFlushCount() {
        return this.flushCount;
    }

    public long getConnectCount() {
        return this.connectCount;
    }

    public long getSecondLevelCacheHitCount() {
        return this.secondLevelCacheHitCount;
    }

    public long getSecondLevelCacheMissCount() {
        return this.secondLevelCacheMissCount;
    }

    public long getSecondLevelCachePutCount() {
        return this.secondLevelCachePutCount;
    }

    public long getSessionCloseCount() {
        return this.sessionCloseCount;
    }

    public long getSessionOpenCount() {
        return this.sessionOpenCount;
    }

    public long getCollectionLoadCount() {
        return this.collectionLoadCount;
    }

    public long getCollectionFetchCount() {
        return this.collectionFetchCount;
    }

    public long getCollectionUpdateCount() {
        return this.collectionUpdateCount;
    }

    public long getCollectionRemoveCount() {
        return this.collectionRemoveCount;
    }

    public long getCollectionRecreateCount() {
        return this.collectionRecreateCount;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void logSummary() {
        log.info("Logging statistics....");
        log.info("start time: " + this.startTime);
        log.info("sessions opened: " + this.sessionOpenCount);
        log.info("sessions closed: " + this.sessionCloseCount);
        log.info("transactions: " + this.transactionCount);
        log.info("successful transactions: " + this.commitedTransactionCount);
        log.info("optimistic lock failures: " + this.optimisticFailureCount);
        log.info("flushes: " + this.flushCount);
        log.info("connections obtained: " + this.connectCount);
        log.info("statements prepared: " + this.prepareStatementCount);
        log.info("statements closed: " + this.closeStatementCount);
        log.info("second level cache puts: " + this.secondLevelCachePutCount);
        log.info("second level cache hits: " + this.secondLevelCacheHitCount);
        log.info("second level cache misses: " + this.secondLevelCacheMissCount);
        log.info("entities loaded: " + this.entityLoadCount);
        log.info("entities updated: " + this.entityUpdateCount);
        log.info("entities inserted: " + this.entityInsertCount);
        log.info("entities deleted: " + this.entityDeleteCount);
        log.info("entities fetched (minimize this): " + this.entityFetchCount);
        log.info("collections loaded: " + this.collectionLoadCount);
        log.info("collections updated: " + this.collectionUpdateCount);
        log.info("collections removed: " + this.collectionRemoveCount);
        log.info("collections recreated: " + this.collectionRecreateCount);
        log.info("collections fetched (minimize this): " + this.collectionFetchCount);
        log.info("queries executed to database: " + this.queryExecutionCount);
        log.info("query cache puts: " + this.queryCachePutCount);
        log.info("query cache hits: " + this.queryCacheHitCount);
        log.info("query cache misses: " + this.queryCacheMissCount);
        log.info("max query time: " + this.queryExecutionMaxTime + "ms");
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setStatisticsEnabled(boolean b) {
        this.isStatisticsEnabled = b;
    }

    public long getQueryExecutionMaxTime() {
        return this.queryExecutionMaxTime;
    }

    public String[] getQueries() {
        return ArrayHelper.toStringArray(this.queryStatistics.keySet());
    }

    public String[] getEntityNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.entityStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllClassMetadata().keySet());
    }

    public String[] getCollectionRoleNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.collectionStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllCollectionMetadata().keySet());
    }

    public String[] getSecondLevelCacheRegionNames() {
        if (this.sessionFactory == null) {
            return ArrayHelper.toStringArray(this.secondLevelCacheStatistics.keySet());
        }
        return ArrayHelper.toStringArray(this.sessionFactory.getAllSecondLevelCacheRegions().keySet());
    }

    public void endTransaction(boolean success) {
        ++this.transactionCount;
        if (success) {
            ++this.commitedTransactionCount;
        }
    }

    public long getSuccessfulTransactionCount() {
        return this.commitedTransactionCount;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public void closeStatement() {
        ++this.closeStatementCount;
    }

    public void prepareStatement() {
        ++this.prepareStatementCount;
    }

    public long getCloseStatementCount() {
        return this.closeStatementCount;
    }

    public long getPrepareStatementCount() {
        return this.prepareStatementCount;
    }

    public void optimisticFailure(String entityName) {
        ++this.optimisticFailureCount;
        ++this.getEntityStatistics((String)entityName).optimisticFailureCount;
    }

    public long getOptimisticFailureCount() {
        return this.optimisticFailureCount;
    }

    public String toString() {
        return "Statistics[" + "start time=" + this.startTime + ",sessions opened=" + this.sessionOpenCount + ",sessions closed=" + this.sessionCloseCount + ",transactions=" + this.transactionCount + ",successful transactions=" + this.commitedTransactionCount + ",optimistic lock failures=" + this.optimisticFailureCount + ",flushes=" + this.flushCount + ",connections obtained=" + this.connectCount + ",statements prepared=" + this.prepareStatementCount + ",statements closed=" + this.closeStatementCount + ",second level cache puts=" + this.secondLevelCachePutCount + ",second level cache hits=" + this.secondLevelCacheHitCount + ",second level cache misses=" + this.secondLevelCacheMissCount + ",entities loaded=" + this.entityLoadCount + ",entities updated=" + this.entityUpdateCount + ",entities inserted=" + this.entityInsertCount + ",entities deleted=" + this.entityDeleteCount + ",entities fetched=" + this.entityFetchCount + ",collections loaded=" + this.collectionLoadCount + ",collections updated=" + this.collectionUpdateCount + ",collections removed=" + this.collectionRemoveCount + ",collections recreated=" + this.collectionRecreateCount + ",collections fetched=" + this.collectionFetchCount + ",queries executed to database=" + this.queryExecutionCount + ",query cache puts=" + this.queryCachePutCount + ",query cache hits=" + this.queryCacheHitCount + ",query cache misses=" + this.queryCacheMissCount + ",max query time=" + this.queryExecutionMaxTime + ']';
    }

    public String getQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }
}

