/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jca.cci.connection.DelegatingConnectionFactory;
import org.springframework.util.Assert;

public class SingleConnectionFactory
extends DelegatingConnectionFactory
implements DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Connection target;
    private Connection connection;
    private final Object connectionMonitor = new Object();

    public SingleConnectionFactory() {
    }

    public SingleConnectionFactory(Connection target) {
        Assert.notNull(target, "Target Connection must not be null");
        this.target = target;
        this.connection = this.getCloseSuppressingConnectionProxy(target);
    }

    public SingleConnectionFactory(ConnectionFactory targetConnectionFactory) {
        Assert.notNull(targetConnectionFactory, "Target ConnectionFactory must not be null");
        this.setTargetConnectionFactory(targetConnectionFactory);
    }

    public void afterPropertiesSet() {
        if (this.connection == null && this.getTargetConnectionFactory() == null) {
            throw new IllegalArgumentException("Connection or 'targetConnectionFactory' is required");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws ResourceException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.initConnection();
            }
            return this.connection;
        }
    }

    public Connection getConnection(ConnectionSpec connectionSpec) throws ResourceException {
        throw new NotSupportedException("SingleConnectionFactory does not support custom ConnectionSpec");
    }

    public void destroy() {
        this.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection() throws ResourceException {
        if (this.getTargetConnectionFactory() == null) {
            throw new IllegalStateException("'targetConnectionFactory' is required for lazily initializing a Connection");
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.target != null) {
                this.closeConnection(this.target);
            }
            this.target = this.doCreateConnection();
            this.prepareConnection(this.target);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Established shared CCI Connection: " + this.target);
            }
            this.connection = this.getCloseSuppressingConnectionProxy(this.target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.target != null) {
                this.closeConnection(this.target);
            }
            this.target = null;
            this.connection = null;
        }
    }

    protected Connection doCreateConnection() throws ResourceException {
        return this.getTargetConnectionFactory().getConnection();
    }

    protected void prepareConnection(Connection con) throws ResourceException {
    }

    protected void closeConnection(Connection con) {
        try {
            con.close();
        }
        catch (Throwable ex) {
            this.logger.warn("Could not close shared CCI Connection", ex);
        }
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        private CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

