/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.type.TypeFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class FilterDefinitionFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean {
    private String filterName;
    private Map parameterTypeMap = new HashMap();
    private String defaultFilterCondition;
    private FilterDefinition filterDefinition;

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void setParameterTypes(Properties parameterTypes) {
        if (parameterTypes != null) {
            this.parameterTypeMap = new HashMap(parameterTypes.size());
            Enumeration<?> names = parameterTypes.propertyNames();
            while (names.hasMoreElements()) {
                String paramName = (String)names.nextElement();
                String typeName = parameterTypes.getProperty(paramName);
                this.parameterTypeMap.put(paramName, TypeFactory.heuristicType(typeName));
            }
        } else {
            this.parameterTypeMap = new HashMap();
        }
    }

    public void setDefaultFilterCondition(String defaultFilterCondition) {
        this.defaultFilterCondition = defaultFilterCondition;
    }

    public void setBeanName(String name) {
        if (this.filterName == null) {
            this.filterName = name;
        }
    }

    public void afterPropertiesSet() {
        this.filterDefinition = new FilterDefinition(this.filterName, this.defaultFilterCondition, this.parameterTypeMap);
    }

    public Object getObject() {
        return this.filterDefinition;
    }

    public Class getObjectType() {
        return FilterDefinition.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

