/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.JDBCExceptionReporter;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class LocalDataSourceConnectionProvider
implements ConnectionProvider {
    private DataSource dataSource;
    private DataSource dataSourceToUse;

    public void configure(Properties props) throws HibernateException {
        this.dataSource = LocalSessionFactoryBean.getConfigTimeDataSource();
        if (this.dataSource == null) {
            throw new HibernateException("No local DataSource found for configuration - 'dataSource' property must be set on LocalSessionFactoryBean");
        }
        this.dataSourceToUse = this.getDataSourceToUse(this.dataSource);
    }

    protected DataSource getDataSourceToUse(DataSource originalDataSource) {
        return originalDataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        try {
            return this.dataSourceToUse.getConnection();
        }
        catch (SQLException ex) {
            JDBCExceptionReporter.logExceptions(ex);
            throw ex;
        }
    }

    public void closeConnection(Connection con) throws SQLException {
        try {
            con.close();
        }
        catch (SQLException ex) {
            JDBCExceptionReporter.logExceptions(ex);
            throw ex;
        }
    }

    public void close() {
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

