/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.commons.cli;

import at.itsv.dvs.commons.cli.CliOption;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class CommandLineHandler {
    private Options options = null;
    private String progName = null;
    private int helpWidth = 74;
    private Comparator<Option> optionComparator = new DefaultOptionComparator();

    protected CommandLine parseCmdLine(String[] args) {
        this.options = this.initializeOptions();
        try {
            GnuParser parser = new GnuParser();
            CommandLine cli = parser.parse(this.options, args);
            return cli;
        }
        catch (ParseException ex) {
            this.printHelp(this.progName, this.options);
            return null;
        }
    }

    protected abstract Options initializeOptions();

    protected void printHelp() {
        this.printHelp(this.progName, this.options);
    }

    protected void printHelp(String progName, Options options) {
        Objects.requireNonNull(progName, "progName must not be null");
        Objects.requireNonNull(options, "options must not be null");
        String cmdLineSyntax = this.getCmdLineSyntax();
        boolean autoUsage = cmdLineSyntax == null || cmdLineSyntax.length() == 0;
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(this.helpWidth);
        formatter.setOptionComparator(this.getOptionComparator());
        formatter.printHelp(progName + (autoUsage ? "" : " ") + cmdLineSyntax, options, autoUsage);
    }

    protected String getCmdLineSyntax() {
        return "";
    }

    protected boolean isWindowsOS() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("win") >= 0;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    protected void setOptionComparator(Comparator<Option> optionComparator) {
        this.optionComparator = optionComparator;
    }

    public String getProgName() {
        return this.progName;
    }

    protected void setProgName(String progName) {
        this.progName = progName + "." + (this.isWindowsOS() ? "cmd" : "sh");
    }

    public Options getOptions() {
        return this.options;
    }

    protected int getHelpWidth() {
        return this.helpWidth;
    }

    protected void setHelpWidth(int helpWidth) {
        this.helpWidth = helpWidth;
    }

    public static class DefaultOptionComparator
    implements Comparator<Option> {
        @Override
        public int compare(Option o1, Option o2) {
            if (o1 instanceof CliOption && o2 instanceof CliOption) {
                return ((CliOption)o1).getOptionID() - ((CliOption)o2).getOptionID();
            }
            return o1.getId() - o2.getId();
        }
    }
}

