/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.toolkit.data;

import at.itsv.dvs.commons.cli.CliOption;
import at.itsv.dvs.commons.cli.CommandLineHandler;
import at.itsv.dvs.io.AbstractExporter;
import at.itsv.dvs.io.AbstractImporter;
import at.itsv.dvs.io.AbstractSARTExporter;
import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.io.DVSExporter;
import at.itsv.dvs.io.DVSImportException;
import at.itsv.dvs.io.DVSImporter;
import at.itsv.dvs.io.EBSARTExporter;
import at.itsv.dvs.io.EBXMLExporter;
import at.itsv.dvs.io.EinzelBestandExporter;
import at.itsv.dvs.io.EinzelBestandImporter;
import at.itsv.dvs.io.ExportListener;
import at.itsv.dvs.io.ExportTemplateManager;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.io.SAEBExporter;
import at.itsv.dvs.io.SAPAKExporter;
import at.itsv.dvs.io.SAPAKImporter;
import at.itsv.dvs.io.SASBExporter;
import at.itsv.dvs.io.SASBImporter;
import at.itsv.dvs.io.XMLPAKExporter;
import at.itsv.dvs.io.XMLPAKImporter;
import at.itsv.dvs.model.DVSBestand;
import at.itsv.dvs.model.DVSBestandSART;
import at.itsv.dvs.model.DVSError;
import at.itsv.dvs.model.DVSPaket;
import at.itsv.dvs.toolkit.util.ToolkitConstants;
import at.itsv.dvs.toolkit.util.ToolkitUtils;
import at.itsv.dvs.util.DVSConstants;
import at.itsv.dvs.util.DVSUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;

public abstract class AbstractDVSDataTool
extends CommandLineHandler
implements ImportListener,
ExportListener {
    private Logger logger = null;
    protected String profile = null;
    protected Properties properties = null;
    protected boolean verbose = false;
    protected boolean verboseError = false;
    protected boolean debug = false;
    protected int oID = 0;
    protected String VSTR;
    protected int filesProcessed = 0;
    protected int paketParsed = 0;
    protected int paketErraneous = 0;
    protected int bestandParsed = 0;
    protected int bestandErraneous = 0;

    public AbstractDVSDataTool() {
    }

    public AbstractDVSDataTool(Logger logger) {
        this.logger = logger;
    }

    protected boolean init(CommandLine cli) {
        if (cli.hasOption("p")) {
            this.profile = cli.getOptionValue("p");
            try {
                this.properties = new Properties();
                this.properties.load(new FileInputStream(this.profile));
            }
            catch (IOException ex) {
                this.printError(ToolkitUtils.getMessage("cli.error.invalid.profile", this.profile));
                return false;
            }
        }
        if (cli.hasOption("v")) {
            this.verbose = true;
        }
        if (cli.hasOption("ve")) {
            this.verboseError = true;
        }
        if (cli.hasOption("d")) {
            this.debug = true;
        }
        this.VSTR = System.getProperty("at.itsv.dvs.VSTR");
        if (this.VSTR == null || this.VSTR.length() < 2) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.vstr", this.VSTR));
            return false;
        }
        return true;
    }

    @Override
    protected Options initializeOptions() {
        Options options = new Options();
        CliOption profile = new CliOption("p", "profile", true, ToolkitUtils.getMessage("cli.msg.profile", new Object[0]));
        profile.setRequired(true);
        profile.setArgName("path");
        profile.setOptionID(++this.oID);
        options.addOption((Option)profile);
        this.oID = this.initializeImportOptions(options, this.oID);
        this.oID = this.initializeExportOptions(options, this.oID);
        OptionGroup og = new OptionGroup();
        og.setRequired(false);
        CliOption verbose = new CliOption("v", "verbose", false, ToolkitUtils.getMessage("cli.msg.verbose", new Object[0]));
        verbose.setOptionID(++this.oID);
        CliOption verboseError = new CliOption("ve", "verbose-error", false, ToolkitUtils.getMessage("cli.msg.verbose.error", new Object[0]));
        verboseError.setOptionID(++this.oID);
        og.addOption((Option)verbose);
        og.addOption((Option)verboseError);
        CliOption debug = new CliOption("d", "debug", false, ToolkitUtils.getMessage("cli.msg.debug", new Object[0]));
        debug.setOptionID(++this.oID);
        options.addOptionGroup(og);
        options.addOption((Option)debug);
        return options;
    }

    protected int initializeImportOptions(Options options, int oID) {
        CliOption iType = new CliOption("i", "import", true, ToolkitUtils.getMessage("cli.msg.itype", new Object[0]) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", ToolkitConstants.ImportType.list()));
        iType.setArgName("type");
        iType.setOptionID(++oID);
        CliOption iPath = new CliOption("ip", "ipath", true, ToolkitUtils.getMessage("cli.msg.ipath", new Object[0]));
        iPath.setArgName("path");
        iPath.setOptionID(++oID);
        CliOption iCharset = new CliOption("ic", "icharset", true, ToolkitUtils.getMessage("cli.msg.icharset", new Object[0]));
        iCharset.setArgName("charset");
        iCharset.setOptionID(++oID);
        CliOption iTypeArgs = new CliOption("ia", "iargs", true, ToolkitUtils.getMessage("cli.msg.iargs", new Object[0]));
        iTypeArgs.setArgName("args");
        iTypeArgs.setOptionID(++oID);
        CliOption iPattern = new CliOption("ipt", "ipattern", true, ToolkitUtils.getMessage("cli.msg.ipattern", new Object[0]));
        iPattern.setArgName("pattern");
        iPattern.setOptionID(++oID);
        options.addOption((Option)iType);
        options.addOption((Option)iPath);
        options.addOption((Option)iCharset);
        options.addOption((Option)iTypeArgs);
        options.addOption((Option)iPattern);
        return oID;
    }

    protected int initializeExportOptions(Options options, int oID) {
        CliOption eType = new CliOption("e", "export", true, ToolkitUtils.getMessage("cli.msg.etype", new Object[0]) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", ToolkitConstants.ExportType.list()));
        eType.setArgName("type");
        eType.setOptionID(++oID);
        CliOption ePath = new CliOption("ep", "epath", true, ToolkitUtils.getMessage("cli.msg.epath", new Object[0]));
        ePath.setArgName("path");
        ePath.setOptionID(++oID);
        CliOption eCharset = new CliOption("ec", "echarset", true, ToolkitUtils.getMessage("cli.msg.echarset", new Object[0]));
        eCharset.setArgName("charset");
        eCharset.setOptionID(++oID);
        CliOption eTypeArgs = new CliOption("ea", "eargs", true, ToolkitUtils.getMessage("cli.msg.eargs", new Object[0]));
        eTypeArgs.setArgName("args");
        eTypeArgs.setOptionID(++oID);
        CliOption eDirection = new CliOption("ed", "edir", true, ToolkitUtils.getMessage("cli.msg.edirection", new Object[0]) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", DVSConstants.DirectionType.list()) + ". " + ToolkitUtils.getMessage("cli.msg.values.default", DVSConstants.DirectionType.OUT.name()));
        eDirection.setArgName("direction");
        eDirection.setOptionID(++oID);
        CliOption eZIP = new CliOption("ez", "ezip", true, ToolkitUtils.getMessage("cli.msg.ezip", new Object[0]) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", DVSConstants.CompressionType.list()) + ". " + ToolkitUtils.getMessage("cli.msg.values.default.ezip", new Object[0]));
        eZIP.setArgName("zip-type");
        eZIP.setOptionID(++oID);
        CliOption eDate = new CliOption("edt", "edate", true, ToolkitUtils.getMessage("cli.msg.edate", new Object[0]));
        eDate.setArgName("date");
        eDate.setOptionID(++oID);
        CliOption eTemplate = new CliOption("etf", "etemplate", true, ToolkitUtils.getMessage("cli.msg.etemplatefile", new Object[0]));
        eTemplate.setArgName("template");
        eTemplate.setOptionID(++oID);
        options.addOption((Option)eType);
        options.addOption((Option)ePath);
        options.addOption((Option)eCharset);
        options.addOption((Option)eTypeArgs);
        options.addOption((Option)eDirection);
        options.addOption((Option)eZIP);
        options.addOption((Option)eDate);
        options.addOption((Option)eTemplate);
        return oID;
    }

    public void importFile(String fileName, int fileNo, int fileTotal) {
        ++this.filesProcessed;
        this.printInfoV(ToolkitUtils.getMessage("cli.msg.import.file", fileName, fileNo, fileTotal));
        this.printInfoV(this.getSeparator());
    }

    public void importPaket(DVSPaket paket) {
        ++this.paketParsed;
        int bestandCount = paket.getBestandListe().size();
        this.bestandParsed += bestandCount;
        if (this.verboseError && !paket.isErroneous() && !paket.hasErroneousBestand()) {
            return;
        }
        this.printInfoV("Paket: " + paket.getUrsprungsPartnerCode() + "/" + paket.getZielPartnerCode() + " - " + bestandCount + (bestandCount == 1 ? " Bestand" : " Bestaende") + (paket.isErroneous() ? " - ERROR" : ""));
        if (paket.isErroneous()) {
            ++this.paketErraneous;
            this.printErrorList(paket.getErrorList(), "");
        }
        List lb = paket.getBestandListe();
        int j = 0;
        for (DVSBestand bestand : lb) {
            if (this.verboseError && !bestand.isErroneous()) continue;
            this.printInfoV("\tBestand(" + ++j + "): " + bestand.getUrsprungsPartnerCode() + "/" + bestand.getZielPartnerCode() + "/" + bestand.getProjektKennzeichen() + "/" + bestand.getListKennzeichen() + " - " + bestand.getSatzAnzahl() + " Zeile(n)" + (bestand.isErroneous() ? " - ERROR" : ""));
            if (bestand instanceof DVSBestandSART) {
                this.printInfoV("\t\tSpeicherort: " + (bestand.getDataLocation() != null ? bestand.getDataLocation().getLocationInfo() : "") + " - (" + ((DVSBestandSART)bestand).getLineStart() + "/" + ((DVSBestandSART)bestand).getLineEnd() + ")");
            } else {
                this.printInfoV("\t\tSpeicherort: " + (bestand.getDataLocation() != null ? bestand.getDataLocation().getLocationInfo() : ""));
            }
            if (!bestand.isErroneous()) continue;
            ++this.bestandErraneous;
            this.printErrorList(bestand.getErrorList(), "\t\t");
        }
        this.printInfoV(this.getSeparator());
    }

    public void importBestand(DVSBestand bestand) {
    }

    protected void printErrorList(List<DVSError> errors, String prefix) {
        if (!this.isDebug()) {
            return;
        }
        for (DVSError error : errors) {
            this.printInfoV(prefix + "ERROR" + "[" + error.getErrorLine() + "/" + error.getErrorColumn() + "]: " + error.getMessage());
        }
    }

    public void exportFile(String fileName) throws DVSExportException {
        this.printInfoV(this.getSeparator());
        this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.file", fileName));
        this.printInfoV(this.getSeparator());
    }

    public void exportPaket(DVSPaket paket) throws DVSExportException {
    }

    public void exportBestand(DVSBestand bestand) throws DVSExportException {
    }

    protected DVSImporter getImporter(CommandLine cli, String VSTR) throws DVSImportException {
        String iPattern;
        String iExtArgs;
        XMLPAKImporter importer = null;
        String sItype = cli.getOptionValue("i");
        ToolkitConstants.ImportType iType = ToolkitConstants.ImportType.fromString(sItype);
        if (iType == null) {
            sItype = this.properties.getProperty("import.type");
            iType = ToolkitConstants.ImportType.fromString(sItype);
        }
        if (iType == null) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", ToolkitUtils.getMessage("cli.msg.itype", new Object[0]), sItype) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", ToolkitConstants.ImportType.list()));
            return null;
        }
        String iPath = cli.getOptionValue("ip");
        if (iPath == null) {
            iPath = this.properties.getProperty("import.path");
        }
        if (iPath == null) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value.null", ToolkitUtils.getMessage("cli.msg.ipath", new Object[0])));
            return null;
        }
        String iCharset = cli.getOptionValue("ic");
        if (iCharset == null) {
            iCharset = this.properties.getProperty("import.charset");
        }
        if ((iExtArgs = cli.getOptionValue("ia")) == null) {
            iExtArgs = this.properties.getProperty("import.extargs");
        }
        if ((iPattern = cli.getOptionValue("ipt")) == null) {
            iPattern = this.properties.getProperty("import.pattern");
        }
        String ZVPA = this.getNestedOptionValue("ZVPA", iExtArgs);
        String UVPA = this.getNestedOptionValue("UVPA", iExtArgs);
        if (UVPA == null || UVPA == "") {
            UVPA = VSTR;
        }
        String splitData = this.getNestedOptionValue("splitData", iExtArgs);
        switch (iType) {
            case XML4: 
            case XML5: {
                importer = iCharset == null || iCharset == "" ? new XMLPAKImporter(iPath) : new XMLPAKImporter(iPath, iCharset);
                importer.setVSTR(VSTR);
                if (iType != ToolkitConstants.ImportType.XML4) break;
                importer.setXmlType(DVSConstants.XMLType.XSD14);
                break;
            }
            case SART: {
                importer = iCharset == null || iCharset == "" ? new SAPAKImporter(iPath) : new SAPAKImporter(iPath, iCharset);
                if (splitData == null) break;
                ((SAPAKImporter)importer).setSplitData(Boolean.parseBoolean(splitData));
                break;
            }
            case SAMMEL: {
                if (ZVPA == null || ZVPA.length() == 0) {
                    this.printError(ToolkitUtils.getMessage("cli.error.invalid.value.null", "ZVPA"));
                    return null;
                }
                importer = iCharset == null || iCharset == "" ? new SASBImporter(iPath, ZVPA, UVPA) : new SASBImporter(iPath, iCharset, ZVPA, UVPA);
                if (splitData == null) break;
                ((SAPAKImporter)importer).setSplitData(Boolean.parseBoolean(splitData));
                break;
            }
            case EZBINARY: 
            case EZSART: {
                if (ZVPA == null || ZVPA.length() == 0) {
                    this.printError(ToolkitUtils.getMessage("cli.error.invalid.value.null", "ZVPA"));
                    return null;
                }
                importer = iCharset == null || iCharset == "" ? new EinzelBestandImporter(iPath, VSTR, ZVPA, UVPA) : new EinzelBestandImporter(iPath, iCharset, VSTR, ZVPA, UVPA);
                String useDirStruct = this.getNestedOptionValue("useDirStruct", iExtArgs);
                if (useDirStruct != null) {
                    ((EinzelBestandImporter)importer).setUseDirStruct(Boolean.parseBoolean(useDirStruct));
                }
                if (iType != ToolkitConstants.ImportType.EZSART) break;
                ((EinzelBestandImporter)importer).setSart(true);
                String lineFlags = this.getNestedOptionValue("lineFlags", iExtArgs);
                if (lineFlags == null) break;
                ((EinzelBestandImporter)importer).setLineFlags(Boolean.parseBoolean(lineFlags));
                break;
            }
        }
        if (importer != null) {
            ((AbstractImporter)importer).addImportListener((ImportListener)this);
            if (DVSUtils.getImportListener() != null) {
                ((AbstractImporter)importer).addImportListener(DVSUtils.getImportListener());
            }
            if (iPattern != null && iPattern != "") {
                ((AbstractImporter)importer).setPattern(iPattern);
            }
        }
        if (importer != null) {
            this.printInfoV(this.getSeparator());
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.import.settings", new Object[0]));
            this.printInfoV(this.getSeparator());
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.import.type", new Object[0]) + "=" + iType.toString());
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.import.path", new Object[0]) + "=" + iPath);
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.import.charset", new Object[0]) + "=" + (iCharset != null ? iCharset : "[" + ((AbstractImporter)importer).getCharset() + "]"));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.import.pattern", new Object[0]) + "=" + (iPattern != null ? iPattern : "*"));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.impexp.eargs", new Object[0]) + "=" + (iExtArgs != null ? iExtArgs : ""));
            this.printInfoV(this.getSeparator());
        }
        return importer;
    }

    protected DVSExporter getExporter(CommandLine cli, String VSTR) throws DVSExportException {
        String eTemplateFile;
        String eDate;
        String eZIP;
        String eDirection;
        String eExtArgs;
        EBXMLExporter exporter = null;
        String sEtype = cli.getOptionValue("e");
        ToolkitConstants.ExportType eType = ToolkitConstants.ExportType.fromString(sEtype);
        if (eType == null) {
            sEtype = this.properties.getProperty("export.type");
            eType = ToolkitConstants.ExportType.fromString(sEtype);
        }
        if (eType == null) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", ToolkitUtils.getMessage("cli.msg.etype", new Object[0]), sEtype) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", ToolkitConstants.ExportType.list()));
            return null;
        }
        String ePath = cli.getOptionValue("ep");
        if (ePath == null) {
            ePath = this.properties.getProperty("export.path");
        }
        if (ePath == null) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value.null", ToolkitUtils.getMessage("cli.msg.epath", new Object[0])));
            return null;
        }
        String eCharset = cli.getOptionValue("ec");
        if (eCharset == null) {
            eCharset = this.properties.getProperty("export.charset");
        }
        if ((eExtArgs = cli.getOptionValue("ea")) == null) {
            eExtArgs = this.properties.getProperty("export.extargs");
        }
        if ((eDirection = cli.getOptionValue("ed")) == null) {
            eDirection = this.properties.getProperty("export.direction");
        }
        if ((eZIP = cli.getOptionValue("ez")) == null) {
            eZIP = this.properties.getProperty("export.ziptype");
        }
        if ((eDate = cli.getOptionValue("edt")) == null) {
            eDate = this.properties.getProperty("export.date");
        }
        if ((eTemplateFile = cli.getOptionValue("etf")) == null) {
            eTemplateFile = this.properties.getProperty("export.templatefile");
        }
        String oneFilePerPaket = this.getNestedOptionValue("oneFilePerPaket", eExtArgs);
        String addCR = this.getNestedOptionValue("addCR", eExtArgs);
        String minLineLength = this.getNestedOptionValue("minLineLength", eExtArgs);
        String fileNameOldStyle = this.getNestedOptionValue("fileNameOldStyle", eExtArgs);
        String fileNamePrefix = this.getNestedOptionValue("fileNamePrefix", eExtArgs);
        switch (eType) {
            case EBXML4: {
                eType = ToolkitConstants.ExportType.XML4;
            }
            case EBXML5: {
                exporter = new EBXMLExporter(ePath, VSTR);
            }
            case XML4: 
            case XML5: {
                if (exporter == null) {
                    exporter = new XMLPAKExporter(ePath, VSTR);
                }
                if (eType != ToolkitConstants.ExportType.XML4) break;
                ((XMLPAKExporter)exporter).setXmlType(DVSConstants.XMLType.XSD14);
                break;
            }
            case EBSART: {
                exporter = eCharset == null || eCharset == "" ? new EBSARTExporter(ePath, VSTR) : new EBSARTExporter(ePath, eCharset, VSTR);
            }
            case SART: {
                if (exporter == null) {
                    exporter = eCharset == null || eCharset == "" ? new SAPAKExporter(ePath, VSTR) : new SAPAKExporter(ePath, eCharset, VSTR);
                }
                if (oneFilePerPaket != null) {
                    this.setOneFilePerPaket((AbstractSARTExporter)exporter, oneFilePerPaket);
                }
                if (addCR != null) {
                    this.setAddCR((AbstractSARTExporter)exporter, addCR);
                }
                if (minLineLength != null) {
                    this.setMinLineLength((AbstractSARTExporter)exporter, minLineLength);
                }
                if (fileNameOldStyle == null) break;
                this.setFileNameOldStyle((AbstractSARTExporter)exporter, fileNameOldStyle);
                break;
            }
            case SAMMEL: {
                exporter = eCharset == null || eCharset == "" ? new SASBExporter(ePath, VSTR) : new SASBExporter(ePath, eCharset, VSTR);
                if (oneFilePerPaket != null) {
                    this.setOneFilePerPaket((AbstractSARTExporter)exporter, oneFilePerPaket);
                }
                if (addCR != null) {
                    this.setAddCR((AbstractSARTExporter)exporter, addCR);
                }
                if (minLineLength == null) break;
                this.setMinLineLength((AbstractSARTExporter)exporter, minLineLength);
                break;
            }
            case EZBINARY: {
                String useDirStruct = this.getNestedOptionValue("useDirStruct", eExtArgs);
                String testFlag = this.getNestedOptionValue("testFlag", eExtArgs);
                String zvob = this.getNestedOptionValue("zvob", eExtArgs);
                exporter = new EinzelBestandExporter(ePath, VSTR);
                if (useDirStruct != null) {
                    ((EinzelBestandExporter)exporter).setUseDirStruct(Boolean.parseBoolean(useDirStruct));
                }
                if (testFlag != null) {
                    ((EinzelBestandExporter)exporter).setTestFlag(Boolean.parseBoolean(testFlag));
                }
                if (zvob == null) break;
                ((EinzelBestandExporter)exporter).setZVOB(zvob);
                break;
            }
            case EZSART: {
                String useDirStruct = this.getNestedOptionValue("useDirStruct", eExtArgs);
                String testFlag = this.getNestedOptionValue("testFlag", eExtArgs);
                String zvob = this.getNestedOptionValue("zvob", eExtArgs);
                exporter = eCharset == null || eCharset == "" ? new SAEBExporter(ePath, VSTR) : new SAEBExporter(ePath, eCharset, VSTR);
                String addLineFlags = this.getNestedOptionValue("addLineFlags", eExtArgs);
                if (useDirStruct != null) {
                    ((SAEBExporter)exporter).setUseDirStruct(Boolean.parseBoolean(useDirStruct));
                }
                if (testFlag != null) {
                    ((SAEBExporter)exporter).setTestFlag(Boolean.parseBoolean(testFlag));
                }
                if (zvob != null) {
                    ((SAEBExporter)exporter).setZVOB(zvob);
                }
                if (oneFilePerPaket != null) {
                    this.setOneFilePerPaket((AbstractSARTExporter)exporter, oneFilePerPaket);
                }
                if (addCR != null) {
                    this.setAddCR((AbstractSARTExporter)exporter, addCR);
                }
                if (minLineLength != null) {
                    this.setMinLineLength((AbstractSARTExporter)exporter, minLineLength);
                }
                if (addLineFlags == null) break;
                ((SAEBExporter)exporter).setAddLineFlags(Boolean.parseBoolean(addLineFlags));
                break;
            }
        }
        if (exporter != null) {
            ((AbstractExporter)exporter).addExportListener((ExportListener)this);
            if (DVSUtils.getExportListener() != null) {
                ((AbstractExporter)exporter).addExportListener(DVSUtils.getExportListener());
            }
            ((AbstractExporter)exporter).setFileNamePrefix(fileNamePrefix);
            if (eDirection != null && eDirection.length() > 0) {
                try {
                    ((AbstractExporter)exporter).setDirection(DVSConstants.DirectionType.valueOf((String)eDirection));
                }
                catch (IllegalArgumentException ex) {
                    this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", ToolkitUtils.getMessage("cli.msg.edirection", new Object[0]), eDirection) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", DVSConstants.DirectionType.list()));
                    return null;
                }
            }
            if (eZIP != null && eZIP.length() > 0) {
                try {
                    ((AbstractExporter)exporter).setCompressionType(DVSConstants.CompressionType.valueOf((String)eZIP));
                }
                catch (IllegalArgumentException ex) {
                    this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", ToolkitUtils.getMessage("cli.msg.ezip", new Object[0]), eZIP) + ". " + ToolkitUtils.getMessage("cli.msg.values.allowed", DVSConstants.CompressionType.list()));
                    return null;
                }
            }
            if (eDate != null && eDate.length() > 0) {
                try {
                    ((AbstractExporter)exporter).setDate(DVSUtils.getFileDateFromString((String)eDate));
                }
                catch (ParseException ex) {
                    this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", ToolkitUtils.getMessage("cli.msg.edate", new Object[0]), eDate));
                    return null;
                }
            }
            if (eTemplateFile != null && eTemplateFile.length() > 0) {
                ((AbstractExporter)exporter).addExportListener((ExportListener)new ExportTemplateManager(eTemplateFile));
            }
        }
        if (exporter != null) {
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.settings", new Object[0]));
            this.printInfoV(this.getSeparator());
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.type", new Object[0]) + "=" + (Object)((Object)eType));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.path", new Object[0]) + "=" + ePath);
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.charset", new Object[0]) + "=" + (eCharset != null ? eCharset : "[" + ((AbstractExporter)exporter).getCharset() + "]"));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.direction", new Object[0]) + "=" + (eDirection != null ? eDirection : "[" + ((AbstractExporter)exporter).getDirection().name() + "]"));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.zip", new Object[0]) + "=" + (eZIP != null ? eZIP : "[" + ((AbstractExporter)exporter).getCompressionType().name() + "]"));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.date", new Object[0]) + "=" + (eDate != null ? eDate : "[" + DVSUtils.getFileDateString((Date)((AbstractExporter)exporter).getDate()) + "]"));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.export.templatefile", new Object[0]) + "=" + (eTemplateFile != null ? eTemplateFile : ""));
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.impexp.eargs", new Object[0]) + "=" + (eExtArgs != null ? eExtArgs : ""));
            this.printInfoV(this.getSeparator());
        }
        return exporter;
    }

    protected void setOneFilePerPaket(AbstractSARTExporter exporter, String oneFilePerPaket) {
        if (!this.isBooleanString(oneFilePerPaket)) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", "oneFilePerPaket", oneFilePerPaket));
            return;
        }
        exporter.setOneFilePerPaket(Boolean.parseBoolean(oneFilePerPaket));
    }

    protected void setAddCR(AbstractSARTExporter exporter, String addCR) {
        if (!this.isBooleanString(addCR)) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", "addCR", addCR));
            return;
        }
        exporter.setAddCR(Boolean.parseBoolean(addCR));
    }

    protected void setMinLineLength(AbstractSARTExporter exporter, String minLineLength) {
        try {
            exporter.setMinLineLength(Integer.parseInt(minLineLength));
        }
        catch (NumberFormatException ex) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", "minLineLength", minLineLength));
            return;
        }
    }

    protected void setFileNameOldStyle(AbstractSARTExporter exporter, String fileNameOldStyle) {
        if (!this.isBooleanString(fileNameOldStyle)) {
            this.printError(ToolkitUtils.getMessage("cli.error.invalid.value", "fileNameOldStyle", fileNameOldStyle));
            return;
        }
        exporter.setFileNameOldStyle(Boolean.parseBoolean(fileNameOldStyle));
    }

    protected boolean isBooleanString(String bString) {
        return bString != null && (bString.equals("true") || bString.equals("false"));
    }

    protected String getNestedOptionValue(String arg, String argumentsLine) {
        String[] arr;
        if (argumentsLine == null || !argumentsLine.contains(arg)) {
            return null;
        }
        String value = null;
        for (String a : arr = argumentsLine.split(",")) {
            if (!a.trim().startsWith(arg)) continue;
            String[] arr2 = a.split("=");
            if (arr2.length != 2) break;
            value = arr2[1];
            break;
        }
        return value;
    }

    @Override
    protected void printHelp(String progName, Options options) {
        super.printHelp(progName, options);
        this.printImportHelp(progName, options);
        this.printExportHelp(progName, options);
    }

    protected void printImportHelp(String progName, Options options) {
        this.printInfo("\n" + ToolkitUtils.getMessage("cli.msg.iargs.header", new Object[0]));
        this.printInfo(this.getSeparator());
        this.printInfo("[" + ToolkitConstants.ImportType.SART.name() + "]");
        this.printInfo("splitData=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.splitData", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ImportType.SAMMEL.name() + "]");
        this.printInfo("ZVPA=<2*DIGIT>\t\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.ZVPA", new Object[0]));
        this.printInfo("UVPA=<2*DIGIT>\t\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.UVPA", new Object[0]));
        this.printInfo("splitData=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.splitData", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ImportType.EZBINARY.name() + "]");
        this.printInfo("ZVPA=<2*DIGIT>\t\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.ZVPA", new Object[0]));
        this.printInfo("UVPA=<2*DIGIT>\t\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.UVPA", new Object[0]));
        this.printInfo("useDirStruct=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.ieargs.useDirStruct", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ImportType.EZSART.name() + "]");
        this.printInfo("ZVPA=<2*DIGIT>\t\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.ZVPA", new Object[0]));
        this.printInfo("UVPA=<2*DIGIT>\t\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.UVPA", new Object[0]));
        this.printInfo("useDirStruct=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.ieargs.useDirStruct", new Object[0]));
        this.printInfo("lineFlags=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.iargs.lineFlags", new Object[0]));
    }

    protected void printExportHelp(String progName, Options options) {
        this.printInfo("\n" + ToolkitUtils.getMessage("cli.msg.eargs.header", new Object[0]));
        this.printInfo(this.getSeparator());
        this.printInfo("[" + ToolkitConstants.ExportType.SART.name() + "]");
        this.printInfo("oneFilePerPaket=true|false\t" + ToolkitUtils.getMessage("cli.msg.eargs.oneFilePerPaket", new Object[0]));
        this.printInfo("addCR=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.addCR", new Object[0]));
        this.printInfo("minLineLength=<number>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.minLineLength", new Object[0]));
        this.printInfo("fileNameOldStyle=true|false\t" + ToolkitUtils.getMessage("cli.msg.eargs.fileNameOldStyle", new Object[0]));
        this.printInfo("fileNamePrefix=<value>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.fileNamePrefix", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ExportType.SAMMEL.name() + "]");
        this.printInfo("oneFilePerPaket=true|false\t" + ToolkitUtils.getMessage("cli.msg.eargs.oneFilePerPaket", new Object[0]));
        this.printInfo("addCR=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.addCR", new Object[0]));
        this.printInfo("minLineLength=<number>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.minLineLength", new Object[0]));
        this.printInfo("fileNamePrefix=<value>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.fileNamePrefix", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ExportType.EZBINARY.name() + "]");
        this.printInfo("useDirStruct=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.ieargs.useDirStruct", new Object[0]));
        this.printInfo("testFlag=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.testFlag", new Object[0]));
        this.printInfo("zvob=<value>\t\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.zvob", new Object[0]));
        this.printInfo("fileNamePrefix=<value>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.fileNamePrefix", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ExportType.EZSART.name() + "]");
        this.printInfo("addCR=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.addCR", new Object[0]));
        this.printInfo("minLineLength=<number>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.minLineLength", new Object[0]));
        this.printInfo("addLineFlags=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.addLineFlags", new Object[0]));
        this.printInfo("useDirStruct=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.ieargs.useDirStruct", new Object[0]));
        this.printInfo("testFlag=true|false\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.testFlag", new Object[0]));
        this.printInfo("zvob=<value>\t\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.zvob", new Object[0]));
        this.printInfo("fileNamePrefix=<value>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.fileNamePrefix", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ExportType.XML5.name() + "]");
        this.printInfo("fileNamePrefix=<value>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.fileNamePrefix", new Object[0]));
        this.printInfo("\n[" + ToolkitConstants.ExportType.XML4.name() + "]");
        this.printInfo("fileNamePrefix=<value>\t\t" + ToolkitUtils.getMessage("cli.msg.eargs.fileNamePrefix", new Object[0]));
    }

    protected void printGlobalSettings() {
        this.printInfoV(this.getSeparator());
        this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.settings", new Object[0]));
        this.printInfoV(this.getSeparator());
        this.printInfoV("VSTR=" + this.getVSTR());
        this.printInfoV("Profil=" + this.getProfile());
    }

    protected void printStatistics(long duration) {
        this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.statistics", new Object[0]));
        this.printInfoV(this.getSeparator());
        this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.statistics.files", this.filesProcessed));
        if (this.paketErraneous == 0) {
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.statistics.paket", this.paketParsed));
        } else {
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.statistics.paket.with.error", this.paketParsed, this.paketErraneous));
        }
        if (this.bestandErraneous == 0) {
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.statistics.bestand", this.bestandParsed));
        } else {
            this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.statistics.bestand.with.error", this.bestandParsed, this.bestandErraneous));
        }
        this.printInfoV(this.getSeparator());
        this.printInfoV(ToolkitUtils.getMessage("cli.msg.global.duration", new Object[0]) + ": " + (duration == 0L ? "< 1sec" : duration + "sec"));
        this.printInfoV(this.getSeparator());
    }

    protected void printInfo(String message) {
        if (this.logger != null) {
            this.logger.info(message);
        } else {
            System.out.println(message);
        }
    }

    protected void printInfoV(String message) {
        if (this.verbose || this.verboseError) {
            if (this.logger != null) {
                this.logger.info(message);
            } else {
                System.out.println(message);
            }
        }
    }

    protected void printError(String message) {
        if (this.logger != null) {
            this.logger.error(this.getSeparator());
            this.logger.error(message);
            this.logger.error(this.getSeparator());
        } else {
            System.out.println(this.getSeparator());
            System.out.println(message);
            System.out.println(this.getSeparator());
        }
    }

    protected String getSeparator() {
        return "-------------------------------------------------------------------------------------------------------";
    }

    public String getProfile() {
        return this.profile;
    }

    public String getVSTR() {
        return this.VSTR;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isVerboseError() {
        return this.verboseError;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isErraneous() {
        return this.paketErraneous > 0 || this.bestandErraneous > 0;
    }
}

