/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.toolkit.data;

import at.itsv.dvs.io.DVSExportException;
import at.itsv.dvs.io.DVSExporter;
import at.itsv.dvs.io.DVSImportException;
import at.itsv.dvs.io.DVSImporter;
import at.itsv.dvs.model.DVSModel;
import at.itsv.dvs.toolkit.data.AbstractDVSDataTool;
import at.itsv.dvs.toolkit.util.ToolkitUtils;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DVSConverter
extends AbstractDVSDataTool {
    private static final Logger logger = LoggerFactory.getLogger(DVSConverter.class);

    public DVSConverter(Logger logger) {
        super(logger);
    }

    public static void main(String[] args) throws Exception {
        if (!DVSConverter.convert(args)) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    protected static boolean convert(String[] args) throws Exception {
        DVSConverter dvsConverter = new DVSConverter(logger);
        dvsConverter.setProgName("dvsConverter");
        dvsConverter.setHelpWidth(120);
        CommandLine cli = dvsConverter.parseCmdLine(args);
        if (cli == null) {
            return false;
        }
        if (!dvsConverter.init(cli)) {
            return false;
        }
        dvsConverter.printGlobalSettings();
        try {
            DVSImporter importer = dvsConverter.getImporter(cli, dvsConverter.getVSTR());
            if (importer == null) {
                dvsConverter.printHelp();
                return false;
            }
            DVSExporter exporter = dvsConverter.getExporter(cli, dvsConverter.getVSTR());
            if (exporter == null) {
                dvsConverter.printHelp();
                return false;
            }
            long start = System.currentTimeMillis();
            DVSModel dvsModel = importer.doImport();
            exporter.doExport(dvsModel);
            long end = System.currentTimeMillis();
            long duration = (end - start) / 1000L;
            dvsConverter.printStatistics(duration);
            return !dvsConverter.isErraneous();
        }
        catch (DVSExportException | DVSImportException ex) {
            dvsConverter.printInfoV(dvsConverter.getSeparator());
            dvsConverter.printError(ToolkitUtils.getMessage("cli.msg.global.errortext", new Object[0]) + " --> " + ex.getMessage());
            dvsConverter.printInfoV(dvsConverter.getSeparator());
            if (dvsConverter.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

