/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.toolkit.data;

import at.itsv.dvs.io.AbstractImporter;
import at.itsv.dvs.io.DVSImportException;
import at.itsv.dvs.io.DVSImporter;
import at.itsv.dvs.io.ImportListener;
import at.itsv.dvs.toolkit.data.AbstractDVSDataTool;
import at.itsv.dvs.toolkit.util.ToolkitUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DVSTester
extends AbstractDVSDataTool
implements ImportListener {
    private static final Logger logger = LoggerFactory.getLogger(DVSTester.class);

    public DVSTester(Logger logger) {
        super(logger);
    }

    public static void main(String[] args) throws Exception {
        if (!DVSTester.test(args)) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    protected static boolean test(String[] args) throws Exception {
        DVSTester dvsTester = new DVSTester(logger);
        dvsTester.setProgName("dvsTester");
        dvsTester.setHelpWidth(120);
        CommandLine cli = dvsTester.parseCmdLine(args);
        if (cli == null) {
            return false;
        }
        if (!dvsTester.init(cli)) {
            return false;
        }
        dvsTester.printGlobalSettings();
        try {
            DVSImporter importer = dvsTester.getImporter(cli, dvsTester.getVSTR());
            if (importer == null) {
                dvsTester.printHelp();
                return false;
            }
            ((AbstractImporter)importer).setRetainData(false);
            long start = System.currentTimeMillis();
            importer.doImport();
            long end = System.currentTimeMillis();
            long duration = (end - start) / 1000L;
            dvsTester.printStatistics(duration);
            return !dvsTester.isErraneous();
        }
        catch (DVSImportException ex) {
            dvsTester.printInfoV(dvsTester.getSeparator());
            dvsTester.printError(ToolkitUtils.getMessage("cli.msg.global.errortext", new Object[0]) + " --> " + ex.getMessage());
            dvsTester.printInfoV(dvsTester.getSeparator());
            if (dvsTester.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    protected int initializeExportOptions(Options options, int oID) {
        return oID;
    }

    @Override
    protected void printExportHelp(String progName, Options options) {
    }
}

