/*
 * Decompiled with CFR 0.152.
 */
package at.itsv.dvs.toolkit.transport;

import at.itsv.dvs.commons.cli.CliOption;
import at.itsv.dvs.commons.cli.CommandLineHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DVSSimpleFTPClient
extends CommandLineHandler
implements CopyStreamListener {
    private static final Logger logger = LoggerFactory.getLogger(DVSSimpleFTPClient.class);
    public static final int DEFAULT_FTP_PORT = 21;
    public static final int DEFAULT_FTP_BUFSIZE = 1024;

    public static void main(String[] args) throws Exception {
        if (!DVSSimpleFTPClient.transport(args)) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean transport(String[] args) throws Exception {
        DVSSimpleFTPClient dvsFTPClient = new DVSSimpleFTPClient();
        dvsFTPClient.setProgName("dvsSimpleFTPClient");
        dvsFTPClient.setHelpWidth(120);
        CommandLine cli = dvsFTPClient.parseCmdLine(args);
        if (cli == null) {
            return false;
        }
        String host = cli.getOptionValue("h");
        int port = 21;
        if (cli.hasOption("po")) {
            port = Integer.parseInt(cli.getOptionValue("po"));
        }
        String user = cli.getOptionValue("u");
        String pwd = null;
        if (cli.hasOption("pwd")) {
            pwd = cli.getOptionValue("pwd");
        }
        if (pwd == null) {
            pwd = DVSSimpleFTPClient.getPassword();
        }
        String localFile = cli.getOptionValue("lf");
        String remoteFile = cli.getOptionValue("rf");
        int bufSize = 1024;
        if (cli.hasOption("b")) {
            bufSize = Integer.parseInt(cli.getOptionValue("b"));
        }
        FTPClient fc = null;
        try {
            fc = new FTPClient();
            fc.setCopyStreamListener((CopyStreamListener)dvsFTPClient);
            fc.setBufferSize(bufSize);
            fc.connect(host, port);
            int reply = fc.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                logger.error("FTP server refused connection");
                fc.disconnect();
                boolean bl = false;
                return bl;
            }
            if (!fc.login(user, pwd)) {
                logger.error("Could not login - " + fc.getReplyString());
                fc.disconnect();
                boolean bl = false;
                return bl;
            }
            logger.info("Connected to [" + host + ":" + port + "] as user [" + user + "]");
            fc.setFileType(2);
            boolean success = true;
            if (cli.hasOption("g")) {
                success = DVSSimpleFTPClient.GET(fc, localFile, remoteFile);
            } else {
                if (Files.notExists(Paths.get(localFile, new String[0]), new LinkOption[0])) {
                    logger.error("Local file does not exist.");
                    boolean bl = false;
                    return bl;
                }
                success = DVSSimpleFTPClient.PUT(fc, localFile, remoteFile);
            }
            if (!success) {
                logger.error("Transfer error - " + fc.getReplyString());
                fc.disconnect();
                boolean bl = false;
                return bl;
            }
            logger.info("File transfered successfully");
            fc.logout();
        }
        finally {
            if (fc != null && fc.isConnected()) {
                fc.disconnect();
            }
        }
        return true;
    }

    protected static boolean GET(FTPClient fc, String localFile, String remoteFile) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(localFile));){
            logger.info("Retrieve remote file [" + remoteFile + "] to [" + localFile + "] ...");
            boolean bl = fc.retrieveFile(remoteFile, (OutputStream)out);
            return bl;
        }
    }

    protected static boolean PUT(FTPClient fc, String localFile, String remoteFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(localFile));){
            logger.info("Store local file [" + localFile + "] to [" + remoteFile + "] ...");
            boolean bl = fc.storeFile(remoteFile, (InputStream)in);
            return bl;
        }
    }

    protected static String getPassword() throws IOException {
        String pwd = null;
        Console con = System.console();
        if (con != null) {
            pwd = new String(con.readPassword("Please enter password: ", new Object[0]));
        } else {
            System.out.print("Please enter password: ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            pwd = br.readLine();
        }
        return pwd;
    }

    public void bytesTransferred(CopyStreamEvent event) {
    }

    public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
    }

    @Override
    protected Options initializeOptions() {
        int oID = 0;
        Options options = new Options();
        CliOption host = new CliOption("h", "host", true, "Name or IP-Adress of FTP-Server");
        host.setRequired(true);
        host.setOptionID(++oID);
        CliOption port = new CliOption("po", "port", true, "Portnumber of FTP-Server. Default 21");
        port.setOptionID(++oID);
        CliOption user = new CliOption("u", "user", true, "Name of FTP-User");
        user.setRequired(true);
        user.setOptionID(++oID);
        CliOption password = new CliOption("pwd", "password", true, "Password of FTP-User");
        password.setOptionID(++oID);
        CliOption localFile = new CliOption("lf", "localfile", true, "Fully qualified path to local file");
        localFile.setRequired(true);
        localFile.setOptionID(++oID);
        CliOption remoteFile = new CliOption("rf", "remotefile", true, "Fully qualified path to remote file");
        remoteFile.setRequired(true);
        remoteFile.setOptionID(++oID);
        OptionGroup action = new OptionGroup();
        action.setRequired(true);
        CliOption get = new CliOption("g", "get", false, "Retrieve remote file");
        get.setOptionID(++oID);
        CliOption put = new CliOption("p", "put", false, "Transfer local file");
        put.setOptionID(++oID);
        action.addOption((Option)get);
        action.addOption((Option)put);
        CliOption bufSize = new CliOption("b", "bufsize", true, "Network buffer size in bytes. Default is 1024");
        bufSize.setOptionID(++oID);
        options.addOption((Option)host);
        options.addOption((Option)port);
        options.addOption((Option)user);
        options.addOption((Option)password);
        options.addOption((Option)localFile);
        options.addOption((Option)remoteFile);
        options.addOptionGroup(action);
        options.addOption((Option)bufSize);
        return options;
    }
}

