  var msecsperday = 1000*60*60*24; // so many milliseconds per day, needed for calculating day numbers between dates
  var monthnames = ['JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC'];

  //
  // ========================== utility functions ====================================================================
  //

  // find the minimum of 2 values
  //
  function min(p1,p2) {
    return (p1<p2?p1:p2);
  }

  // find the largest of 2 values
  //
  function max(p1,p2) {
   return (p1>p2?p1:p2);
  }

  // 
  // do a logical AND over a variable number of booleans P<n>
  // this is necessary in MediaWiki as the Ampersand in the javascript source is destroyed by the MediaWiki parser
  // as an asset this provides boolean short ciruiting by terminating the processing as soon 
  // as the result is guaranteed to be FALSE
  //
  function doAnd(p1,p2,p3,p4) {
    // console.log("doAnd.P1="+p1+".P2="+p2+".P3="+p3+".P4="+p4);
    var i = 0;
    var res = true;
    while (true) {
      if (!res) {
        return false;
      }
      if (i>=arguments.length) {
        return res;
      }
      if (!(arguments[i++])) {
        res = false;
      }
    }
  }

  //
  // check if num is in range lo thru hi
  //
  function isInRange(num,lo,hi) {
    return doAnd((num>=lo),(num<=hi));
  }

  //
  // difference in days between Date objects
  //
  function daydiff(dat1,dat2) { // returns difference in days between 2 dates
    return Math.round((dat1-dat2)/msecsperday);
  }

  function dateFromOracle(datst) { // parse a date from a string "day month year ..."
    var parts = datst.match(/(\d+)/g);
    var dat;
    if (parts==null) { 
      dat = null; 
    }
    else {
      dat = new Date(parts[2], parts[1]-1, parts[0], 0, 0, 0); // months are 0-based
    }
    return dat;
  }

  function makeWikiUrlEnc(pnam) { // build a URL-part from a Mediawiki Pagename by replacing blanks with underscores
                                  // this should be enhanced when additional peculiarities are encountered!
    return pnam.replace(/ /g,'_');
  }

  // ================================= charting ==========================================================================
  //
  // the generic point class
  //
  function point(thex,they) {
    this.x = thex;
    this.y = they;
    this.getX = function() {
      return this.x;
    }
    this.getY = function() {
      return this.y;
    }
    this.distance = function(that) {
      return Math.sqrt(Math.pow(this.x-that.getX(),2)+Math.pow(this.y-that.getY(),2));
    }
    this.coordPair = function(delim) { 
      return ""+this.x+delim+this.y;
    }
    this.toString = function() {
      return this.coordPair("/");
    }
    this.middlePoint = function(that) {
        return new point(this.getX()+(that.getX()-this.getX())/2,
                         this.getY()+(that.getY()-this.getY())/2);
    }
  }
  //
  // initialize shapetype-definitions
  //
  function define_shapetypes() {
    if (!(window.shapedefs===undefined)) {
      return;
    }
    window.shapedefs = {
      rect: {
        width: 120,
        height: 50 },
      diam: {
        width: 150,
        height: 50 },
      joint: {
        width: 5, 
        height: 5 },
      flpt: {
        width: 130,
        height: 50 },
      conn: {
        hopmultx: 0,
        hopmulty: 0,
        expandchartonplace: false,
        connstyle: 'ortho',
        defxpos: 5,
        defypos: 5 },
      conndef: {
        connstyle: 'beeline' },
      team: {
        width: 240,
        height: 100 },
      memb: {
        hopmultx: 0,
        hopmulty: 0,
        defxpos: 200,
        defypos: 200,
        width: 60,
        height: 30 },
      elip:  {
        hopmultx: 0,
        hopmulty: 0,
        expandchartonplace: false,
        connstyle: 'ortho',
        defxpos: 5,
        defypos: 5 }
      } // end of JSON-initializer for shapedefs 
  }
  function getShapeDef(clas,attr,def) { // get shape definition attribute <attr> for shape class <clas>
                                        // if not found, try with base class (first 4 chars of <clas>)
                                        // if not found, use <def> as default value
    define_shapetypes();
    var cn = clas;
    var lt = "shape definition property "+attr+" for class "+cn+", defaulting to "+def+" is ";
    var v;
    var c = window.shapedefs[cn];
    if (!(c===undefined)) {
      v = c[attr];
      if (!(v===undefined)) {
        console.log(lt+""+v);
        return v;
      }
    }
    cn=clas.substr(0,4);
    c = window.shapedefs[cn];
    if (!(c===undefined)) {
      v = c[attr];
      if (!(v===undefined)) {
        console.log(lt+""+v);
        return v;
      }
    }
    console.log(lt+""+def);
    return def;
  }
  //
  // variables for this chart instance
  //
  var </html>{{{cname}}}<html>selectedElement = 0;
  var </html>{{{cname}}}<html>currentX = 0;
  var </html>{{{cname}}}<html>currentY = 0;
  var </html>{{{cname}}}<html>currentMatrix = 0;
  //
  // the generic chart class
  //
  function chart() {
    this.deltax=20;   // default space between "near" shapes is 10 pixels
    this.deltay=20;
    this.gridx = 200; // default grid X spacing is 200 pixels
    this.gridy = 70;  // default grid Y spacing is  70 pixels
    this.penx = this.gridx;
    this.peny = this.gridy;
    this.hopx = 0;        // default hop between automatic advancing placements is one grid down (ascending Y direction)
    this.hopy = this.gridy;
    this.urlprefix='http://zpvwiki.sozvers.at/zpv/index.php/';
    this.minx=0;
    this.maxx=600;
    this.miny=0;
    this.maxy=500;
    this.width="";
    this.height="";
    //
    // calculated values
    //
    this.shapes=new Array(100);
    this.shapecount=0;
    //
    // grids takes account of occupied grid lines, has one array for X and one for Y
    //
    this.grids = new Object;
    this.grids["X"] = [];
    this.grids["Y"] = [];
    //
    // instance methods
    //
    this.toString = function() {
      return this.minx+"/"+this.miny+".."+this.maxx+"/"+this.maxy;
    }
    this.addShape = function(s) {                 // add a new shape to this chart
      if (this.shapecount>=this.shapes.length) {
        this.shapes.length += 1; }
      this.shapes[this.shapecount++] = s;
      s.myindex = this.shapecount-1;
    }
    this.getMaxX = function() {                 // return the maxX
      return this.maxx; }
    this.getMinX = function() {                 // return the minX
      return this.minx; }
    this.getMaxY = function() {                 // return the maxY
      return this.maxy; }
    this.getMinY = function() {
      return this.miny; }
    this.getHeight = function() {
      return this.height; }
    this.getWidth = function() {
      return this.width; }
    this.getMaxDate = function() {
      return this.maxdate; }
    this.setMaxX = function(newMaxX) {          // set the new max-X coordinate for the chart
      this.maxx = newMaxX;
      this.checkRedraw(); }
    this.setMaxY = function(newMaxY) {          // set the new max-Y coordinate for the chart
      this.maxy = newMaxY;
      this.checkRedraw(); }
    this.setMinX = function(newMinX) {          // set the new min-X coordinate for the chart
      this.minx = newMinX;
      this.checkRedraw(); }
    this.setMinY = function(newMinY) {          // set the new min-Y coordinate for the chart
      this.miny = newMinY;
      this.checkRedraw(); }
    this.setWidth = function(newWidth) {        // set the width of the chart on the display area
      this.width = newWidth;
      this.checkRedraw(); }
    this.setHeight = function(newHeight) {      // set the height of the chart on the display area
      this.height = newHeight;
      this.checkRedraw(); }
    this.getPenX = function() {                 // get current drawing position's X
      return this.penx; }
    this.getPenY = function() {                 // get current drawing position's Y
      return this.peny; }
    this.movePen = function(px, py) {           // set a new drawing position for this chart
      this.penx = px;
      this.peny = py;
    }
    this.checkRedraw = function() {             // check if the chart shall be re-drawn after setting a parameter
      if (this.rootelement!=null) {             // chart ist drawn already, SVG element can be manipulated
        this.styleElement = this.parentelement
        this.rootelement.setAttribute("viewBox",this.minx+" "+this.miny+" "+this.maxx+" "+this.maxy);
        if (this.width.length>0) {
          this.rootelement.setAttribute("width",this.width); }
        else {
          this.rootelement.removeAttribute("width"); }
        if (this.height.length>0) {
          this.rootelement.setAttribute("height",this.height); }
        else {
          this.rootelement.removeAttribute("height"); }
      }
    }
    this.getDeltaX = function() {
      return this.deltax;
    }
    this.getDeltaY = function() {
      return this.deltay;
    }
    this.setDeltaX = function(ndx) {
      this.deltax = ndx; 
    }
    this.setDeltaY = function(ndy) {
      this.deltay = ndy;
      console.log("chart's deltaY is now "+this.deltay);
    }
    this.isFreeGrid = function(dim,pos) {       // checks if grid line <pos> in dimension <dim> is free
      console.log("trying "+dim+" grid line at "+pos); 
      return (this.grids[dim].indexOf(pos)<0);
    }
    this.markUsedGrid = function(dim,pos) {     // mark the grid line <pos> in dimension <dim> as used
      this.grids[dim].push(pos);
      console.log("grid "+dim+" line array has now "+this.grids[dim].length+" elements");
    }
    this.getFreeGrid = function(dim,baseg,dg) { // find the next free grid line in dimension <dim>, starting with <baseg>+<dg>, 
                                                // if occupied, increment by another <dg>, until a free line is found
      var ng = baseg + dg;
      while (!this.isFreeGrid(dim,ng)) {
        ng += dg;
      }
      this.markUsedGrid(dim,ng);
      return ng;
    }
    this.draw = function(nam) {                                // draw this chart to an SVG element named NAM
      this.rootelement=document.getElementById(nam);
      this.parentelement=this.rootelement.parent;
      if (this.rootelement==null) {
        alert('root element with ID '+nam+' is NULL!');
        return; }
      if (this.rootelement.namespaceURI != "http://www.w3.org/2000/svg") {	// Alert the user if their browser does not support SVG.
        alert("Inline SVG in HTML5 is not supported (namespace-URI is "+this.rootelement.namespaceURI+
              "). This document requires a browser that supports HTML5 inline SVG."); 
        return; }
      // everything asserted ok for drawing
      //
      // ... first draw a background rectangle for catching click events
      //
      var shape = document.createElementNS("http://www.w3.org/2000/svg", "rect");
      shape.setAttribute("x",this.minx);
      shape.setAttribute("y",this.miny);
      shape.setAttribute("width",this.maxx);
      shape.setAttribute("height",this.maxy);
      shape.setAttribute("class","rectbg");
      shape.setAttribute("onclick","click</html>{{{cname}}}<html>bg(evt)");
      this.rootelement.appendChild(shape); 
      //
      // draw all shapes
      // TODO: take Z-axis into account
      //
      var i;
      for (i=0; i<this.shapecount; i++) {
        this.shapes[i].draw(this.rootelement);
        }
        var vb = this.minx+" "+this.miny+" "+this.maxx+" "+this.maxy
        console.log("will set viewbox of chart </html>{{{cname}}}<html> to "+vb);
        this.rootelement.setAttribute("viewBox",vb);
        // $('body').click( function (e) { 
        //    // if ( e.target == this ) 
        //    console.log("click on chart X/Y="+e.clientX+"/"+e.clientY+" registered");
        //    return true;
        //  });
     } // end of chart.draw()
  } // end of class chart
  //
  // Class Shape
  //
  function shape(chart,nam,clas,px,py) {
    this.myindex = null;
    this.tooltip = null;
    this.href = null;
    this.mychart = chart;
    chart.addShape(this);
    this.class = clas;
    this.name = nam;
    this.height = getShapeDef(clas,'height',50);
    this.width = getShapeDef(clas,'width',120);
    //
    this.toString = function() {
      return "["+this.myindex+"]"+((this.name==null)?"":this.name)+"("+((this.class==null)?"no_class":this.class)+")";
    }
    this.getWidth = function() {
      return this.width;
    }
    this.getHeight = function() {
      return this.height;
    }
    this.setWidth = function(newW) {
      this.width = newW;
    }
    this.setHeight = function(newH) {
      this.height = newH;
    }
    this.getX = function() {
      return this.xpos;
    }
    this.setX = function(newX) {
      this.xpos = newX;
    }
    this.getY = function() { 
      return this.ypos;
    }
    this.setY = function(newY) {
      this.ypos = newY;
    }
    this.getMinX = function() {
      return this.xpos-(this.getWidth()/2);
    }
    this.getMaxX = function() {
      return this.xpos+(this.getWidth()/2);
    }
    this.getMinY = function() {
      return this.ypos-(this.getHeight()/2);
    }
    this.getMaxY = function() {
      return this.ypos+(this.getHeight()/2);
    }
    this.getBox = function() {                         // get a String representation for the rectangular box represented by the shape
      return this.getMinX()+"/"+this.getMinY()+".."+this.getMaxX()+"/"+this.getMaxY();
    }
    this.findGrid = function(p,hinfo) {                // find the next grid position in direction hinfo
      xs = this.mychart.gridx;
      ys = this.mychart.gridy;
      var px = p.x;
      var py = p.y;
      if ((this.xpos % xs)>0) {         // we are not yet already on a grid position
        switch (hinfo) {
        case 'E':
        case 'N':
        case 'S':
          px = (Math.floor(this.xpos/xs)+1)*xs;
          break;
        case 'W':
          px = (Math.floor(this.xpos/xs))*xs;
          break;
        }
      }
      if ((this.ypos % ys)>0) {
        switch (hinfo) {
        case 'S':
        case 'E':
        case 'W':
          py = (Math.floor(this.ypos/ys)+1)*ys;
          break;
        case 'N':
          py = (Math.floor(this.ypos/ys))*ys;
          break;
        }
      }
      console.log('Fitting Grid to '+this.xpos+'/'+this.ypos+' is '+px+'/'+py);
      var np = new point(px,py);
      return new point(px,py);
    }
    this.findNextGrid = function(p,hinfo) {          // find the next grid point to p in direction hinfo
      mx = p.x;
      my = p.y;
      switch (hinfo) {
      case 'N':
        p.y -= this.mychart.gridy;
        break;
      case 'E':
        p.x += this.mychart.gridx;
        break;
      case 'S':
        p.y += this.mychart.gridy;
        break;
      case 'W':
        p.x -= this.mychart.gridx;
        break;
      }
      console.log('Next Grid from '+mx+'/'+my+' in '+hinfo+' direction is '+p.x+'/'+p.y);
      return p;
    }
    this.placeSet = function(nx,ny) {                        // place this shape exactly at <nx>/<ny>
      var np;
      this.setX(nx);
      this.setY(ny);
      this.mychart.movePen(this.xpos+(this.mychart.hopx*getShapeDef(this.class,'hopmultx',1)), 
                           this.ypos+(this.mychart.hopy*getShapeDef(this.class,'hopmulty',1)));
      if (getShapeDef(this.class,'expandchartonplace',true)) {
      if (this.getMaxX()>this.mychart.getMaxX()) {
        np = this.findNextGrid(this.findGrid(new point(this.getMaxX(),this.getMaxY()),'E'),'E');
        console.log('shape '+this.toString()+" at "+this.getBox()+' forces maxX-expansion to '+np.getX());
        this.mychart.setMaxX(np.getX());
      }
      if (this.getMaxY()>this.mychart.getMaxY()) {
        np = this.findNextGrid(this.findGrid(new point(this.getMaxX(),this.getMaxY()),'S'),'S');
        console.log('shape '+this.toString()+" at "+this.getBox()+' forces maxY-expansion to '+np.getY());
        this.mychart.setMaxY(np.getY());
      }
      if (this.getMinX()<this.mychart.getMinX()) {
        np = this.findNextGrid(this.findGrid(new point(this.getMinX(),this.getMinY()),'W'),'W');
        console.log('shape '+this.toString()+" at "+this.getBox()+' forces minX-expansion to '+np.getX());
        this.mychart.setMinX(np.getX());
      }
      if (this.getMinY()<this.mychart.getMinY()) {
        np = this.findNextGrid(this.findGrid(new point(this.getMinX(),this.getMinY()),'N'),'N');
        console.log('shape '+this.toString()+" at "+this.getBox()+' forces minY-expansion to '+np.getY());
        this.mychart.setMinY(np.getY());
      }
      }
      console.log('Shape '+this.toString()+' is now at X='+this.xpos+',Y='+this.ypos+', next shape will be placed at X='+this.mychart.getPenX()+', Y='+this.mychart.getPenY());
    }
    if (px==null) { px = getShapeDef(this.class,'defxpos',chart.getPenX()); }
    if (py==null) { py = getShapeDef(this.class,'defypos',chart.getPenY()); }
    this.placeSet(px,py);
    var ds = '';
    chart.movePen(this.xpos+chart.hopx, this.ypos+chart.hopy); // default position for next instanciated element is determined by chart hopX
    console.log('Shape '+this.toString()+' is now at X='+this.xpos+',Y='+this.ypos+', next shape will be placed at X='+chart.getPenX()+', Y='+chart.getPenY());
    //
    this.getChart = function() {
      return this.mychart;
    }
    this.setHref = function(newHref) {
      this.href = newHref;
    }
    this.setTooltip = function(tttext) {
      this.tooltip = tttext;
    }
    this.getPos = function() {                         
      return new point(this.xpos,this.ypos);
    }
    this.getPos = function() {                        // get a point representing the current position of this shape
      return new point(this.xpos, this.ypos);
    }
    this.setPos = function(p) {                       // place the shape at point p
      this.placeSet(p.x,p.y);
    }
    this.resolveConnDir = function(connDir,refPoint) {         // adapt ConnDir according to refPoint
      var r = false;
      var dx=0;
      var dy=0;
      var sx=0;
      var sy=0;
      var alpha=0;
      var beta=0;
      if (connDir=="C") {
        var rx;
        var ry;
        if (!(refPoint==null)) {
          rx = refPoint.getX();
          ry = refPoint.getY();
        } else {
          rx = this.mychart.getMinX();
          ry = this.mychart.getMinY();
        }
        dx = rx-this.getX();
        dy = ry-this.getY();
        sx = this.getMaxX()-this.getX();
        sy = this.getMaxY()-this.getY();
        alpha = Math.atan2(dy,dx);
        beta = Math.atan2(sy,sx);
        if (isInRange(alpha,0-Math.PI,     0-Math.PI+beta)) connDir = "W";
        if (isInRange(alpha,0-Math.PI+beta,0-beta))         connDir = "N";
        if (isInRange(alpha,0-beta,        0))              connDir = "E"
        if (isInRange(alpha,0,             beta))           connDir = "E";
        if (isInRange(alpha,beta,          Math.PI-beta))   connDir = "S";
        if (isInRange(alpha,Math.PI-beta,  Math.PI))        connDir = "W";
        r = true;
      }
      if (r) console.log("resolveConnDir, refPoint="+rx+"/"+ry+", this="+this.getMinX()+"/"+this.getMinY()+"["+this.getX()+"/"+this.getY()+"]"+this.getMaxX()+"/"+this.getMaxY()+
                         ", dx/dy="+dx+"/"+dy+", sx/sy="+sx+"/"+sy+
                         ", Pi="+Math.PI+", alpha="+alpha+", beta="+beta+", new connDir="+connDir);
      return connDir;
    }
    this.getConnPoint = function(connDir,refPoint) { // Get the point of the <connDir> connection point of this shape
      connDir = this.resolveConnDir(connDir,refPoint);
      var cpx = 0;
      var cpy = 0;
      var mix = this.getMinX();
      var miy = this.getMinY();
      var mxx = this.getMaxX();
      var mxy = this.getMaxY();
      var pox = this.getX();
      var poy = this.getY();
      var ht  = this.getHeight();
      var wd  = this.getWidth();
      switch (connDir) {
      case 'N':
        cpx = pox;
        cpy = miy;
        break;
      case 'N2E':
        cpx = pox+(wd/6);
        cpy = miy;
        break;
      case 'N2W':
        cpx = pox-(wd/6);
        cpy = miy;
        break;
      case 'N51':
        cpx = pox+(wd/3);
        cpy = miy;
        break;
      case 'N55':
        cpx = pox-(wd/3)
        cpy = this.getMinY();
        break;
      case 'E':
        cpx = mxx;
        cpy = poy;
        break;
      case 'E2N':
        cpx = mxx;
        cpy = poy-(ht/6);
        break;
      case 'E2S':
        cpx = mxx;
        cpy = poy+(ht/6);
        break;
      case 'E51':
        cpx = mxx;
        cpy = poy-(th/3);
        break;
      case 'E55':
        cpx = mxx;
        cpy = poy+(ht/3);
        break;
      case 'W':
        cpx = mix;
        cpy = poy;
        break;
      case 'W2N':
        cpx = mix;
        cpy = poy-(ht/6);
        break;
      case 'W2S':
        cpx = mix;
        cpy = poy+(ht/6);
        break;
      case 'W51':
        cpx = mix;
        cpy = poy-(ht/3);
        break;
      case 'W55':
        cpx = mix;
        cpy = poy+(ht/3);
        break;
      case 'S':
        cpx = pox;
        cpy = mxy;
        break;
      case 'S2E':
        cpx = pox-(ht/6);
        cpy = mxy;
        break;
      case 'S2W':
        cpx = pox+(ht/6);
        cpy = mxy;
        break;
      case 'S51':
        cpx = pox-(wd/3);
        cpy = mxy;
        break;
      case 'S55':
        cpx = pox+(wd/3);
        cpy = mxy;      
        break;
      otherwise
        cpx = pox
        cpy = poy;
      }
      return new point(cpx,cpy);
    }
    this.xright = function() {                                   // get an X-position one grid-spacing to the right of this
      return this.findNextGrid(this.getPos(),"E").getX();
    }
    this.xleft = function() {                                   // get an X-position one grid-spacing to the left of this
      return this.findNextGrid(this.getPos(),"W").getX();
    }
    this.ybetween = function(theShape) {                         // get an Y-position that is halfway between this and theShape
      return (this.getY()-theShape.getY())/2+theShape.getY();
    }
    this.placeDist = function(theShape,hinfo,distX,distY) {      // place this shape in the vincinity <dist> to theShape, position derived from hinfo
      var dx;
      var dy;
      var stepx = this.getWidth()/2 + theShape.getWidth()/2 + distX;
      var stepy = this.getHeight()/2 + theShape.getHeight()/2 + distY;
      switch (hinfo) {
      case 'N':
        dx = 0;
        dy = 0-stepy;
        break;
      case 'NE':
        dx = stepx;
        dy = 0-stepy;
        break;
      case 'E':
        dx = stepx;
        dy = 0;
        break;
      case 'SE':
        dx = stepx;
        dy = stepy;
        break;
      case 'S':
        dx = 0;
        dy = stepy;
        break;
      case 'SW':
        dx = 0-stepx;
        dy = stepy;
        break;
      case 'W':
        dx = 0-stepx;
        dy = 0;
        break;
      case 'NW':
        dx = 0-stepx;
        dy = 0-stepy;
        break;
      }
      console.log("placing shape "+this.toString()+" Near("+hinfo+") to shape "+theShape.toString()+", dx="+dx+", dy="+dy);
      this.placeSet(theShape.getX() + dx,theShape.getY() + dy);
    }                                               // end of shape.placeDist()
    this.placeNear = function(theShape, hinfo) {    // place in standard vincinity
      this.placeDist(theShape,hinfo,this.mychart.getDeltaX(),this.mychart.getDeltaY());
    }
    this.placeNearGrid = function(theShape, hinfo) { // place on the next grid point in direction of hinfo
      this.setPos(theShape.findNextGrid(theShape.findGrid(theShape.getPos(),hinfo),hinfo));
      console.log("Shape "+this.toString()+" placed at "+this.xpos+"/"+this.ypos+", being "+hinfo+"-grid-near to shape "+theShape.name+
                  " being at "+theShape.xpos+"/"+theShape.ypos);
    }
    this.placeAt = function(theShape, hinfo) {      // place directly adjacent
      this.placeDist(theShape,hinfo,0,0);
    }
    this.placeIn = function(theParent, hinfo) {         // place this member shape inside a parent shape, position derived from hinfo: N, NE, E, SE, S, SW, W, NW
      var dx = 0;
      var dy = 0;
      switch (hinfo) {
      case 'N':
        dx = 0;
        dy = -30;
        break;
      case 'NE':
        dx = 60;
        dy = -20;
        break;
      case 'E':
        dx = 80;
        dy = 0;
        break;
      case 'SE':
        dx = 60;
        dy = 20;
        break;
      case 'S':
        dx = 0;
        dy = 30;
        break;
      case 'SW':
        dx = -60;
        dy = 20;
        break;
      case 'W':
        dx = -80;
        dy = 0;
        break;
      case 'NW':
        dx = -60;
        dy = -20;
        break;
      }
      this.xpos = theParent.getX()+dx;
      this.ypos = theParent.getY()+dy;
      // console.log('Member shape '+this.name+' is now at X='+this.xpos+',Y='+this.ypos);
    }                                               // end of shape.placeIn()
    this.alignX = function(theShape) {             // align this shape vertically below theShape
      console.log('X-Aligning Shape '+this.toString()+' at X='+this.xpos+',Y='+this.ypos+' with shape '+theShape.name+' at X='+theShape.getX()+',Y='+theShape.getY());
      this.setX(theShape.getX());
      this.mychart.movePen(this.xpos, this.ypos);
      console.log('Shape '+this.toString()+' is now at X='+this.xpos+',Y='+this.ypos);
    }
    this.alignY = function(theShape) {            // align this shape horizontally right of theShape
      console.log('Y-Aligning Shape '+this.toString()+' at X='+this.xpos+',Y='+this.ypos+' with shape '+theShape.name+' at X='+theShape.getX()+',Y='+theShape.getY());
      this.setY(theShape.getY());
      this.mychart.movePen(this.xpos, this.ypos);
      console.log('Shape '+this.toString()+' is now at X='+this.xpos+',Y='+this.ypos);
    }
    this.connect = function(fromShape, fromConn, toShape, toConn) {              // let this shape be a connection from fromShape's fromConn to toShape's toConn
      this.fromPoint = fromShape.getConnPoint(fromConn,toShape.getPos());
      this.fromConnDir = fromConn;
      this.toPoint   = toShape.getConnPoint(toConn,fromShape.getPos());
      this.toConnDir = toConn;
      this.setPos(this.fromPoint.middlePoint(this.toPoint));
    }
    this.expandAlignHoriz = function(shapeA, shapeB) {   // expand this shape to span shapeA and shapeB horizontally
      var minx = min(shapeA.getMinX(), shapeB.getMinX());
      var maxx = max(shapeA.getMaxX(), shapeB.getMaxX());
      this.setX((maxx-minx)/2 + minx);
      this.setWidth(maxx-minx);
    }
    this.AlignRight = function(shapeA) { // Align the right side (largest X) of this shape to that of shapeA
      this.setX(shapeA.getX()+(shapeA.getWidth()/2)-(this.getWidth()/2));
    }
    this.AlignLeft = function(shapeA)  { // Align the left side (smallest X) of this shape to that of shapeA
      this.setX(shapeA.getX()-(shapeA.getWidth()/2)+(this.getWidth()/2));
    }
    this.AlignBottom = function(shapeA) { // Align the bottom side (largest Y) of this shape to that of shapeA
      this.setY(shapeA.getY()+(shapeA.getHeight()/2)-(this.getHeight()/2));
    }
    this.AlignTop = function(shapeA)  { // Align the top side (smallest Y) of this shape to that of shapeA
      this.setY(shapeA.getY()-(shapeA.getHeight()/2)+(this.getHeight()/2));
    }
    this.draw = function(theRoot) {                 // draw this shape to the SVG element THEROOT
      var shape;
      var textx = this.xpos;
      var texty = this.ypos;
      console.log('Drawing shape named '+this.toString()+" of class "+this.class+" at "+this.xpos+"/"+this.ypos+" size "+this.width+" x "+this.height);
      // console.dir(this);
      switch (this.class.substr(0,4)) {
      case 'rect':
        shape = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        shape.setAttribute("x",this.xpos-this.getWidth()/2);
        shape.setAttribute("y",this.ypos-this.getHeight()/2);
        shape.setAttribute("width",this.getWidth());
        shape.setAttribute("height",this.getHeight());
        shape.setAttribute("class",this.class);
        break;
      case 'tdoc':
        shape = document.createElementNS("http://www.w3.org/2000/svg", "use");
        shape.setAttributeNS("http://www.w3.org/1999/xlink", 'href', '#'+this.class.substr(0,4));
        shape.setAttribute("x",this.xpos);
        shape.setAttribute("y",this.ypos);
        shape.setAttribute("class",this.class);
        break;
      case 'team':
        shape = document.createElementNS("http://www.w3.org/2000/svg", "ellipse");
        shape.setAttribute("cx",this.xpos);
        shape.setAttribute("cy",this.ypos);
        shape.setAttribute("rx",this.getWidth()/2);
        shape.setAttribute("ry",this.getHeight()/2);
        shape.setAttribute("class",this.class);
        break;
      case 'memb':
        shape = document.createElementNS("http://www.w3.org/2000/svg", "ellipse");
        shape.setAttribute("cx",this.xpos);
        shape.setAttribute("cy",this.ypos);
        shape.setAttribute("rx",this.getWidth()/2);
        shape.setAttribute("ry",this.getHeight()/2);
        shape.setAttribute("class",this.class)
        break;
      case 'elip':
        shape = document.createElementNS("http://www.w3.org/2000/svg", "ellipse");
        shape.setAttribute("cx",this.xpos);
        shape.setAttribute("cy",this.ypos);
        shape.setAttribute("rx",this.getWidth()/2);
        shape.setAttribute("ry",this.getHeight()/2);
        shape.setAttribute("class",this.class);
        break;
      case 'conn':
        shape = document.createElementNS("http://www.w3.org/2000/svg", "path");
        var hdx = this.mychart.getDeltaX()/2;
        var hdy = this.mychart.getDeltaY()/2;
        var fex, fey, lex, ley, mex, mey;
        switch (this.fromConnDir.substr(0,1)) {
          case 'N':
            fex = this.fromPoint.getX();
            fey = this.mychart.getFreeGrid("Y",this.fromPoint.getY(),-hdy);
            break;
          case 'E':
            fex = this.mychart.getFreeGrid("X",this.fromPoint.getX(),+hdx);
            fey = this.fromPoint.getY();
            break;
          case 'S':
            fex = this.fromPoint.getX();
            fey = this.mychart.getFreeGrid("Y",this.fromPoint.getY(),+hdy);
            break;
          case 'W':
            fex = this.mychart.getFreeGrid("X",this.fromPoint.getX(),-hdx);
            fey = this.fromPoint.getY();         
            break;
        }
        switch (this.toConnDir.substr(0,1)) {
          case 'N':
            lex = this.toPoint.getX();
            ley = this.mychart.getFreeGrid("Y",this.toPoint.getY(),-hdy);
            break;
          case 'E':
            lex = this.mychart.getFreeGrid("X",this.toPoint.getX(),+hdx);
            ley = this.toPoint.getY();
            break;
          case 'S':
            lex = this.toPoint.getX();
            ley = this.mychart.getFreeGrid("Y",this.toPoint.getY(),+hdy);
            break;
          case 'W':
            lex = this.mychart.getFreeGrid("X",this.toPoint.getX(),-hdx);
            ley = this.toPoint.getY();
            break; 
        }
        mex = lex;
        mey = fey;
        var dd;
        var cst = getShapeDef(this.class,'connstyle','unknown');
        switch (cst) {
          case 'ortho':
            dd = 'M '+this.fromPoint.coordPair(' ')+' L '+fex+' '+fey+' L '+mex+' '+mey+' L '+lex+' '+ley+' L '+this.toPoint.coordPair(' ');
            break;
          case 'beeline':
            dd = 'M '+this.fromPoint.coordPair(' ')+' L '+this.toPoint.coordPair(' ');
            break;
          default:                                 // no valid connstyle
            dd = "";
            console.log("connection shape "+this.toString()+" has invalid connstyle="+cst);
        }
        shape.setAttribute("d",dd);
        shape.setAttribute("class",this.class)
        textx = mex;
        texty = mey;
        break;
      default: // no explicitely coded shape, assume it's a defined shape to be 'use'd
        shape = document.createElementNS("http://www.w3.org/2000/svg", "use");
        shape.setAttributeNS("http://www.w3.org/1999/xlink", 'href', '#'+this.class);
        shape.setAttribute("x",this.xpos);
        shape.setAttribute("y",this.ypos);
        shape.setAttribute("class",this.class);
      }
      shape.setAttribute("transform","matrix(1 0 0 1 0 0)");
      shape.setAttribute("onmousedown","select</html>{{{cname}}}<html>Element(evt)");
      if (this.tooltip) {     // there is a tooltip, place shape and <title> tag in a <g> element
          var gt = document.createElementNS("http://www.w3.org/2000/svg", "g");
          var tt = document.createElementNS("http://www.w3.org/2000/svg", "title");
          var ttxn = document.createTextNode(this.tooltip);
          tt.appendChild(ttxn);
          gt.appendChild(tt);
          gt.appendChild(shape);
          shape = gt;
      }
      if (this.href) {
        var alink = document.createElementNS("http://www.w3.org/2000/svg", "a");
        alink.setAttributeNS("http://www.w3.org/1999/xlink", 'href',this.href);
        theRoot.appendChild(alink);
        alink.appendChild(shape);
        shape = alink;
      }
      theRoot.appendChild(shape);
      var bb = shape.getBBox();
      var cr = shape.getBoundingClientRect();
      console.log("shape "+this.toString()+" drawn at "+this.xpos+"/"+this.ypos+
        ", BoundingClientRect is "+cr.width+" x "+cr.height+" at "+cr.x+" / "+cr.y+
        ", BBox is "+bb.width+" x "+bb.height+" at "+bb.x+" / "+bb.y);
      this.d_min_x = cr.x;
      this.d_min_y = cr.y;
      this.d_max_x = cr.x+cr.width;
      this.d_max_y = cr.y+cr.height;
      if (this.name) {
        var txt = document.createElementNS("http://www.w3.org/2000/svg", "text");
        txt.setAttribute("x",textx);
        txt.setAttribute("y",texty);
        txt.setAttribute("class",this.class+"text");
        var txn = document.createTextNode(this.name);
        txt.appendChild(txn);
        theRoot.appendChild(txt);
      }
    // console.log("shape "+this.toString()+" drawn");
    }
    this.makeConn = function(theShape,conclass,fromConn,toConn) {
      var con = new shape(this.mychart,"",conclass);
      con.connect(this,fromConn,theShape,toConn);
    }
    this.next = function(theShape) {
      this.makeConn(theShape,'connflow','S','N');
    }
    this.connectOrg = function(theShape) {             // establish an Org-Chart connection between this and theShape
      this.makeConn(theShape,'conndef','C','C');
    }
  }  // end of class shape
  
  function select</html>{{{cname}}}<html>Element(evt) { //handler for click event on draggable SVG element in chart 
    </html>{{{cname}}}<html>selectedElement = evt.target;
    </html>{{{cname}}}<html>currentX = evt.clientX;
    </html>{{{cname}}}<html>currentY = evt.clientY;
    </html>{{{cname}}}<html>currentMatrix = </html>{{{cname}}}<html>selectedElement.getAttributeNS(null, "transform").slice(7,-1).split(' ');
    for(var i=0; i<</html>{{{cname}}}<html>currentMatrix.length; i++) {
      </html>{{{cname}}}<html>currentMatrix[i] = parseFloat(</html>{{{cname}}}<html>currentMatrix[i]);
    }	 
  </html>{{{cname}}}<html>selectedElement.setAttributeNS(null, "onmousemove", "move</html>{{{cname}}}<html>Element(evt)");
  </html>{{{cname}}}<html>selectedElement.setAttributeNS(null, "onmouseout", "deselect</html>{{{cname}}}<html>Element(evt)");
  </html>{{{cname}}}<html>selectedElement.setAttributeNS(null, "onmouseup", "deselect</html>{{{cname}}}<html>Element(evt)");
  }

  function move</html>{{{cname}}}<html>Element(evt){
    console.log("will move element");
    dx = evt.clientX - </html>{{{cname}}}<html>currentX;
    dy = evt.clientY - </html>{{{cname}}}<html>currentY;
    </html>{{{cname}}}<html>currentMatrix[4] += dx;
    </html>{{{cname}}}<html>currentMatrix[5] += dy;
    newMatrix = "matrix(" + </html>{{{cname}}}<html>currentMatrix.join(' ') + ")";            
    </html>{{{cname}}}<html>selectedElement.setAttributeNS(null, "transform", newMatrix);
    </html>{{{cname}}}<html>currentX = evt.clientX;
    </html>{{{cname}}}<html>currentY = evt.clientY;
    console.log("Element moved by "+dx+"/"+dy);
  }

  function deselect</html>{{{cname}}}<html>Element(evt){
  if(</html>{{{cname}}}<html>selectedElement != 0) {
    </html>{{{cname}}}<html>selectedElement.removeAttributeNS(null, "onmousemove");
    </html>{{{cname}}}<html>selectedElement.removeAttributeNS(null, "onmouseout");
    </html>{{{cname}}}<html>selectedElement.removeAttributeNS(null, "onmouseup");
    </html>{{{cname}}}<html>selectedElement = 0;
    }
  }

  function click</html>{{{cname}}}<html>bg(e) {
    console.log("Click event on BG element of chart </html>{{{cname}}}<html> X/Y="+e.clientX+"/"+e.clientY+" registered."); 
  }

  function setup_</html>{{{cname}}}<html>_chart(nam) {
    the</html>{{{cname}}}<html>SVGelementName = nam;
    the</html>{{{cname}}}<html>Chart = new chart();
    //
    // populate the chart
    //
</html>
{{{setupcode}}}
<html>
    //
    // ... and now draw it
    //
    the</html>{{{cname}}}<html>Chart.draw(the</html>{{{cname}}}<html>SVGelementName);

</html>{{{postdrawcode|}}}<html>

    the</html>{{{cname}}}<html>Chart.checkRedraw();
    </html>{{{cname}}}<html>updateForm();
  }

 function </html>{{{cname}}}<html>updateForm() {
   document.getElementById('</html>{{{cname}}}<html>minXinput').value = the</html>{{{cname}}}<html>Chart.getMinX();
   document.getElementById('</html>{{{cname}}}<html>maxXinput').value = the</html>{{{cname}}}<html>Chart.getMaxX();
   document.getElementById('</html>{{{cname}}}<html>width').value     = the</html>{{{cname}}}<html>Chart.getWidth();
   document.getElementById('</html>{{{cname}}}<html>minYinput').value = the</html>{{{cname}}}<html>Chart.getMinY();
   document.getElementById('</html>{{{cname}}}<html>maxYinput').value = the</html>{{{cname}}}<html>Chart.getMaxY();
   document.getElementById('</html>{{{cname}}}<html>height').value    = the</html>{{{cname}}}<html>Chart.getHeight();
   document.getElementById("</html>{{{cname}}}<html>htmloutput").value= document.getElementById("</html>{{{divname}}}<html>").outerHTML;
 }

 function </html>{{{cname}}}<html>changeMinX(inpID) {
   the</html>{{{cname}}}<html>Chart.setMinX(document.getElementById(inpID).value);
   document.getElementById(inpID).value  = the</html>{{{cname}}}<html>Chart.getMinX();
 }

 function </html>{{{cname}}}<html>changeMaxX(inpID) {
   the</html>{{{cname}}}<html>Chart.setMaxX(document.getElementById(inpID).value);
   document.getElementById(inpID).value  = the</html>{{{cname}}}<html>Chart.getMaxX();
 }

 function </html>{{{cname}}}<html>changeMinY(inpID) {
   the</html>{{{cname}}}<html>Chart.setMinY(document.getElementById(inpID).value);
   document.getElementById(inpID).value  = the</html>{{{cname}}}<html>Chart.getMinY();
 }

 function </html>{{{cname}}}<html>changeMaxY(inpID) {
   the</html>{{{cname}}}<html>Chart.setMaxY(document.getElementById(inpID).value);
   document.getElementById(inpID).value  = the</html>{{{cname}}}<html>Chart.getMaxY();
 }

 function </html>{{{cname}}}<html>changeWidth(inpID) {
   the</html>{{{cname}}}<html>Chart.setWidth(document.getElementById(inpID).value);
   document.getElementById(inpID).value  = the</html>{{{cname}}}<html>Chart.getWidth();
 }

 function </html>{{{cname}}}<html>changeHeight(inpID) {
   the</html>{{{cname}}}<html>Chart.setHeight(document.getElementById(inpID).value);
   document.getElementById(inpID).value  = the</html>{{{cname}}}<html>Chart.getHeight();   
 }

 function </html>{{{cname}}}<html>_toggle_cpanel(panel_id) {
   // console.log("will toggle visibility state of "+panel_id);
   var panel = document.getElementById(panel_id);
   if (panel.style.display=='none') {
     panel.style.display='block';
   } else {
     panel.style.display='none';
   }
 }

 </script>

<button id="</html>{{{cnam