#
#		ITSV GmbH
#	CCDB - Command and Control Database
#
#	FILE:			managed file jsdata_specialtemplates
#	DESCRIPTION:	this file contains definitions for special templates in CCDB wiki pages
#
# ------------------------------------------------------------------------------
#
# special template "showctx"
#
# this template displays the wiki page parsing context in the embedding page
#
@showctx.qexpression
	logger.debug("wiki.showctx.ctx: "+aux.objTxt(this.ctx)); 
	"\r\n<pre> wiki parsing context: \r\n"+ctxTxt(this.ctx)+"\r\n</pre>"
#
# ------------------------------------------------------------------------------
#
# special template "dquery"
#
# this template executes a CCDB query in display the result in the embedding page
#
# initialization
# this js-expression is executed when loading the special templates
# for "dquery", the javascript class "aux.Result" ist enhanced by a <.toWikiText()> method,
#   which converts a Result value to wikitext
@dquery.init.qexpression
	/* 
	 * enhance Result with a toWikiText() method
     *	toWikiText() generates wikitext depending on the <.resulttype>:
     *	- dbresult: a table with oine row per row in the dbresult and
     *		a header row derived from the metaData
     *	- (others): a <pre>-formatted list with all attributes of the result object	 
	 */
	aux.Result.prototype.toWikiText = function() {
		if (this.resulttype=="dbresult") {
			let cv, cvv; 
			let wikitext = "{|\r\n";
			if (this.metaData) {
				wikitext += "! ";
				for (let hi=0; hi<this.metaData.length; hi++) {
					if (hi>0) wikitext += "!!";
					wikitext += this.metaData[hi].name;
				}
			}
			if (this.rows) {
				for (let ri=0; ri<this.rows.length; ri++) {
					wikitext += "|-\r\n";
					if (this.rows[ri]) {
						wikitext += "| ";
						for (let ci=0; ci<this.rows[ri].length; ci++) {
							if (ci>0) wikitext += " || ";
							cv = this.rows[ri][ci];
							if (cv) {
								if (cv.value) {
									cvv = cv.value; 
								} else {
									if (typeof(cv)=='object') {
										cvv = "<pre>"+aux.objTxt(cv)+"</pre>";
									} else {
										cvv = cv;
									}
								}
								if (cv.rawhtml) {
									wikitext += "<html>"+cv.rawhtml+"</html>";
								} else {
									if (cv.hyperlink) {
										if (cv.hyperlink.href) {
											if (cv.hyperlink.title) {
												wikitext += "<html><a href=\""+cv.hyperlink.href+"\" title=\""+cv.hyperlink.title+"\">"+cvv+"</a></html>";
											} else {
												wikitext += "<html><a href=\""+cv.hyperlink.href+"\" >"+cvv+"</a></html>";
											}
										}
									} else {
										wikitext += cvv;
									}
								}
							}
						}
						wikitext += "\r\n";
					}
				}
			}
			wikitext += "\r\n|}";
			return wikitext;
		} else {
			return "<pre>\r\n"+aux.objTxt(res)+"\r\n</pre>";
		}
	};
	logger.debug("wiki.dquery.init.UDBG.Result_class: "+aux.objTxt(aux.Result));
#
# template execution:
#	when executing the template "dquery", the CCDB-query from parameter <dataname> is executed
#	all other template parameters are passed into the dquery's <.query> parameter
#	upon completion of the dquery, the result object is rendered to wikitext and the wikitext returned to the wiki parser
#
@dquery.aexpression
	proc: {
		this.dquery = require("./dquery.js",logger,prefs);
		this.query = aux.deepCopy(this.ctx.TPARAMS.named_params);
		logger.debug("wiki.dquery.UDBG.query: "+aux.objTxt(this.query));
		let callback = this;
		this.dquery.dquery(this.req,this.session,this.query,
			function(err,res) {
				cbproc: {
					if (err) {
						callback(err,res);
						break cbproc;
					}
					callback(null,{wikitext: res.toWikiText()});
				}
			});
	}
