/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.io.UnicodeWriter;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.rtext.CurrentTextAreaEvent;
import org.fife.rtext.CurrentTextAreaListener;
import org.fife.rtext.FileTypeIconManager;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.SearchManager;
import org.fife.rtext.SpellingSupport;
import org.fife.rtext.StatusBar;
import org.fife.rtext.SyntaxFilters;
import org.fife.rtext.actions.CapsLockAction;
import org.fife.rtext.actions.ToggleTextModeAction;
import org.fife.ui.UIUtil;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.CaretStyle;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.Macro;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.search.FindInFilesDialog;
import org.fife.ui.search.FindInFilesEvent;
import org.fife.ui.search.FindInFilesListener;
import org.fife.ui.search.FindInFilesSearchContext;
import org.fife.ui.search.ReplaceInFilesDialog;

public abstract class AbstractMainView
extends JPanel
implements PropertyChangeListener,
ActionListener,
SearchListener,
FindInFilesListener,
HyperlinkListener {
    public static final int DOCUMENT_SELECT_TOP = 1;
    public static final int DOCUMENT_SELECT_LEFT = 2;
    public static final int DOCUMENT_SELECT_BOTTOM = 3;
    public static final int DOCUMENT_SELECT_RIGHT = 4;
    public static final String AUTO_INSERT_CLOSING_CURLYS = "MainView.autoInsertClosingCurlys";
    public static final String CURRENT_DOCUMENT_PROPERTY = "MainView.currentDocument";
    public static final String DEFAULT_ENCODING_PROPERTY = "MainView.defaultEncoding";
    public static final String FILE_SIZE_CHECK_PROPERTY = "MainView.fileSizeCheck";
    public static final String FRACTIONAL_METRICS_PROPERTY = "MainView.fractionalMetrics";
    public static final String MARK_ALL_COLOR_PROPERTY = "MainView.markAllColor";
    public static final String MARK_OCCURRENCES_COLOR_PROPERTY = "MainView.markOccurrencesColor";
    public static final String MARK_OCCURRENCES_PROPERTY = "MainView.markOccurrences";
    public static final String MAX_FILE_SIZE_PROPERTY = "MainView.maxFileSize";
    public static final String REMEMBER_WS_LINES_PROPERTY = "MainView.rememberWhitespaceLines";
    public static final String ROUNDED_SELECTION_PROPERTY = "MainView.roundedSelection";
    public static final String SMOOTH_TEXT_PROPERTY = "MainView.smoothText";
    public static final String TEXT_AREA_ADDED_PROPERTY = "MainView.textAreaAdded";
    public static final String TEXT_AREA_REMOVED_PROPERTY = "MainView.textAreaRemoved";
    private RTextEditorPane currentTextArea;
    public FindInFilesSearchContext searchContext;
    private SearchManager searchManager;
    private boolean lineNumbersEnabled;
    private boolean lineWrapEnabled;
    private String defaultLineTerminator;
    private String defaultEncoding;
    private boolean guessFileContentType;
    public FindInFilesDialog findInFilesDialog;
    public ReplaceInFilesDialog replaceInFilesDialog;
    public GoToDialog goToDialog;
    private int textMode;
    private int tabSize;
    private boolean emulateTabsWithWhitespace;
    private Font printFont;
    private Color caretColor;
    private Color selectionColor;
    private Color selectedTextColor;
    private boolean useSelectedTextColor;
    private Object backgroundObject;
    private float imageAlpha;
    private String backgroundImageFileName;
    protected RText owner;
    private SyntaxFilters syntaxFilters;
    private boolean highlightCurrentLine;
    private Color currentLineColor;
    private boolean highlightModifiedDocDisplayNames;
    private Color modifiedDocumentDisplayNameColor;
    private boolean checkForModification;
    private long modificationCheckDelay = 10000L;
    private boolean bracketMatchingEnabled;
    private boolean matchBothBrackets;
    private Color matchedBracketBGColor;
    private Color matchedBracketBorderColor;
    private boolean marginLineEnabled;
    private int marginLinePosition;
    private Color marginLineColor;
    private boolean highlightSecondaryLanguages;
    private Color[] secondaryLanguageColors;
    private boolean hyperlinksEnabled;
    private Color hyperlinkColor;
    private int hyperlinkModifierKey;
    private boolean whitespaceVisible;
    private boolean showEOLMarkers;
    private boolean showTabLines;
    private Color tabLinesColor;
    private boolean rememberWhitespaceLines;
    private boolean autoInsertClosingCurlys;
    private boolean aaEnabled;
    private boolean fractionalMetricsEnabled;
    private Color markAllHighlightColor;
    private boolean markOccurrences;
    private Color markOccurrencesColor;
    private boolean roundedSelectionEdges;
    private int caretBlinkRate;
    private CaretStyle[] carets;
    private boolean doFileSizeCheck;
    private float maxFileSize;
    private boolean ignoreBackupExtensions;
    private Font textAreaFont;
    private boolean textAreaUnderline;
    private Color textAreaForeground;
    private ComponentOrientation textAreaOrientation;
    private EventListenerList listenerList = new EventListenerList();
    private Map<String, Boolean> codeFoldingEnabledStates;
    private Icon bookmarkIcon;
    private boolean bookmarksEnabled;
    private Font lineNumberFont;
    private Color lineNumberColor;
    private Color gutterBorderColor;
    private SpellingSupport spellingSupport;
    private ToggleTextModeAction toggleTextModeAction;
    private CapsLockAction capsLockAction;
    private static Cursor macroCursor;

    public AbstractMainView() {
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource("org/fife/rtext/graphics/bookmark.png");
        if (url != null) {
            this.bookmarkIcon = new ImageIcon(url);
        }
        this.checkForModification = true;
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            public void run() {
                AbstractMainView.this.checkFilesForOutsideModification();
            }
        }, this.modificationCheckDelay, this.modificationCheckDelay);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.startsWith("FileModified. ")) {
            this.handleFileModifiedEvent(command);
        }
    }

    public void addCurrentTextAreaListener(CurrentTextAreaListener l) {
        this.listenerList.add(CurrentTextAreaListener.class, l);
    }

    private synchronized void addNewEmptyFile(String fileNameAndPath, String encoding) {
        if (encoding == null) {
            encoding = RTextFileChooser.getDefaultEncoding();
        }
        if (!fileNameAndPath.equals(this.getDefaultFileName())) {
            try {
                new File(fileNameAndPath).createNewFile();
            }
            catch (IOException ioe) {
                String text = this.owner.getString("ErrorWritingFile", new Object[]{fileNameAndPath, ioe.getMessage()});
                JOptionPane.showMessageDialog(this, text, this.owner.getString("ErrorDialogTitle", new Object[0]), 0);
            }
        }
        try {
            this.currentTextArea = this.createRTextEditorPane(fileNameAndPath, encoding);
        }
        catch (IOException ioe) {
            this.owner.displayException(ioe);
            this.ensureFilesAreOpened();
            return;
        }
        RTextScrollPane scrollPane = this.createScrollPane(this.currentTextArea);
        this.currentTextArea.applyComponentOrientation(this.getTextAreaOrientation());
        this.addTextAreaImpl(this.currentTextArea.getFileName(), (Component)scrollPane, this.currentTextArea.getFileFullPath());
        this.firePropertyChange(TEXT_AREA_ADDED_PROPERTY, null, (Object)this.currentTextArea);
    }

    public synchronized void addNewEmptyUntitledFile() {
        this.addNewEmptyFile(this.getDefaultFileName(), this.getDefaultEncoding());
    }

    private void addTextArea(RTextEditorPane textArea) {
        textArea.discardAllEdits();
        RTextScrollPane scrollPane = this.createScrollPane(textArea);
        textArea.applyComponentOrientation(this.getTextAreaOrientation());
        this.addTextAreaImpl(textArea.getFileName(), (Component)scrollPane, textArea.getFileFullPath());
        this.firePropertyChange(TEXT_AREA_ADDED_PROPERTY, null, (Object)this.currentTextArea);
        this.moveToTopOfCurrentDocument();
    }

    protected abstract void addTextAreaImpl(String var1, Component var2, String var3);

    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        ComponentOrientation temp = this.getTextAreaOrientation();
        this.textAreaOrientation = null;
        this.setTextAreaOrientation(temp);
    }

    public boolean areTabsEmulated() {
        return this.emulateTabsWithWhitespace;
    }

    public synchronized void checkFilesForOutsideModification() {
        if (this.checkForModification) {
            this.checkForModification = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                if (!textArea.isModifiedOutsideEditor()) continue;
                sb.append(' ').append(i);
            }
            if (sb.length() == 0) {
                this.checkForModification = true;
            } else {
                final String actionCommand = "FileModified." + sb.toString();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        AbstractMainView.this.actionPerformed(new ActionEvent(this, 1001, actionCommand));
                    }
                });
            }
        }
    }

    public boolean closeAllDocuments() {
        return this.closeAllDocumentsExcept(-1);
    }

    public boolean closeAllDocumentsExcept(int except) {
        int numDocuments = this.getNumDocuments();
        this.setSelectedIndex(numDocuments - 1);
        for (int i = numDocuments - 1; i >= 0; --i) {
            if (i == except) {
                if (i <= 0) continue;
                this.setSelectedIndex(0);
                continue;
            }
            boolean closed = this.closeCurrentDocument();
            if (closed) continue;
            this.owner.setStatusBarReadOnlyIndicatorEnabled(this.currentTextArea == null ? false : this.currentTextArea.isReadOnly());
            return false;
        }
        return true;
    }

    public final boolean closeCurrentDocument() {
        RTextEditorPane old = this.currentTextArea;
        boolean closed = this.closeCurrentDocumentImpl();
        if (closed) {
            old.clearParsers();
            this.firePropertyChange(TEXT_AREA_REMOVED_PROPERTY, null, (Object)old);
        }
        return closed;
    }

    protected abstract boolean closeCurrentDocumentImpl();

    public void convertOpenFilesSpacesToTabs() {
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            this.getRTextEditorPaneAt(i).convertSpacesToTabs();
        }
    }

    public void convertOpenFilesTabsToSpaces() {
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            this.getRTextEditorPaneAt(i).convertTabsToSpaces();
        }
    }

    public void copyData(AbstractMainView fromPanel) {
        int i;
        this.currentTextArea = fromPanel.currentTextArea;
        this.searchManager = fromPanel.searchManager;
        this.searchContext = fromPanel.searchContext;
        this.lineNumbersEnabled = fromPanel.lineNumbersEnabled;
        this.lineWrapEnabled = fromPanel.lineWrapEnabled;
        this.findInFilesDialog = fromPanel.findInFilesDialog;
        if (this.findInFilesDialog != null) {
            this.findInFilesDialog.removeFindInFilesListener(fromPanel);
            this.findInFilesDialog.addFindInFilesListener(this);
        }
        this.replaceInFilesDialog = fromPanel.replaceInFilesDialog;
        if (this.replaceInFilesDialog != null) {
            this.replaceInFilesDialog.removeFindInFilesListener(fromPanel);
            this.replaceInFilesDialog.addFindInFilesListener(this);
        }
        this.goToDialog = fromPanel.goToDialog;
        this.textMode = fromPanel.textMode;
        this.tabSize = fromPanel.tabSize;
        this.emulateTabsWithWhitespace = fromPanel.emulateTabsWithWhitespace;
        this.printFont = fromPanel.printFont;
        this.caretColor = fromPanel.caretColor;
        this.selectionColor = fromPanel.selectionColor;
        this.selectedTextColor = fromPanel.selectedTextColor;
        this.useSelectedTextColor = fromPanel.useSelectedTextColor;
        this.backgroundObject = fromPanel.backgroundObject;
        this.imageAlpha = fromPanel.imageAlpha;
        this.backgroundImageFileName = fromPanel.backgroundImageFileName;
        this.owner = fromPanel.owner;
        this.syntaxFilters = fromPanel.syntaxFilters;
        this.highlightCurrentLine = fromPanel.highlightCurrentLine;
        this.currentLineColor = fromPanel.currentLineColor;
        this.highlightModifiedDocDisplayNames = fromPanel.highlightModifiedDocDisplayNames;
        this.modifiedDocumentDisplayNameColor = fromPanel.modifiedDocumentDisplayNameColor;
        this.checkForModification = fromPanel.checkForModification;
        this.modificationCheckDelay = fromPanel.modificationCheckDelay;
        this.bracketMatchingEnabled = fromPanel.bracketMatchingEnabled;
        this.matchBothBrackets = fromPanel.matchBothBrackets;
        this.matchedBracketBGColor = fromPanel.matchedBracketBGColor;
        this.matchedBracketBorderColor = fromPanel.matchedBracketBorderColor;
        this.marginLineEnabled = fromPanel.marginLineEnabled;
        this.marginLinePosition = fromPanel.marginLinePosition;
        this.marginLineColor = fromPanel.marginLineColor;
        this.highlightSecondaryLanguages = fromPanel.highlightSecondaryLanguages;
        for (int i2 = 0; i2 < this.secondaryLanguageColors.length; ++i2) {
            this.secondaryLanguageColors[i2] = fromPanel.secondaryLanguageColors[i2];
        }
        this.hyperlinksEnabled = fromPanel.hyperlinksEnabled;
        this.hyperlinkColor = fromPanel.hyperlinkColor;
        this.hyperlinkModifierKey = fromPanel.hyperlinkModifierKey;
        this.whitespaceVisible = fromPanel.whitespaceVisible;
        this.showEOLMarkers = fromPanel.showEOLMarkers;
        this.showTabLines = fromPanel.showTabLines;
        this.tabLinesColor = fromPanel.tabLinesColor;
        this.rememberWhitespaceLines = fromPanel.rememberWhitespaceLines;
        this.autoInsertClosingCurlys = fromPanel.autoInsertClosingCurlys;
        this.aaEnabled = fromPanel.aaEnabled;
        this.fractionalMetricsEnabled = fromPanel.fractionalMetricsEnabled;
        this.markAllHighlightColor = fromPanel.markAllHighlightColor;
        this.markOccurrences = fromPanel.markOccurrences;
        this.markOccurrencesColor = fromPanel.markOccurrencesColor;
        this.roundedSelectionEdges = fromPanel.roundedSelectionEdges;
        this.caretBlinkRate = fromPanel.caretBlinkRate;
        this.carets = (CaretStyle[])fromPanel.carets.clone();
        this.doFileSizeCheck = fromPanel.doFileSizeCheck;
        this.maxFileSize = fromPanel.maxFileSize;
        this.ignoreBackupExtensions = fromPanel.ignoreBackupExtensions;
        this.textAreaFont = fromPanel.textAreaFont;
        this.textAreaUnderline = fromPanel.textAreaUnderline;
        this.textAreaForeground = fromPanel.textAreaForeground;
        this.textAreaOrientation = fromPanel.textAreaOrientation;
        Object[] listeners = fromPanel.listenerList.getListenerList();
        Class<CurrentTextAreaListener> ctalClass = CurrentTextAreaListener.class;
        for (int i3 = 0; i3 < listeners.length; i3 += 2) {
            if (listeners[i3] != ctalClass) continue;
            CurrentTextAreaListener l = (CurrentTextAreaListener)listeners[i3 + 1];
            fromPanel.listenerList.remove(ctalClass, l);
            this.listenerList.add(ctalClass, l);
        }
        this.bookmarkIcon = fromPanel.bookmarkIcon;
        this.bookmarksEnabled = fromPanel.bookmarksEnabled;
        this.lineNumberFont = fromPanel.lineNumberFont;
        this.lineNumberColor = fromPanel.lineNumberColor;
        this.gutterBorderColor = fromPanel.gutterBorderColor;
        this.setPreferredSize(fromPanel.getPreferredSize());
        int numDocuments = fromPanel.getNumDocuments();
        int fromSelectedIndex = fromPanel.getSelectedIndex();
        ArrayList<RTextScrollPane> scrollPanes = new ArrayList<RTextScrollPane>(numDocuments);
        for (i = 0; i < numDocuments; ++i) {
            scrollPanes.add(fromPanel.getRTextScrollPaneAt(0));
            fromPanel.removeComponentAt(0);
        }
        for (i = 0; i < numDocuments; ++i) {
            RTextScrollPane scrollPane = (RTextScrollPane)scrollPanes.get(i);
            RTextEditorPane editorPane = (RTextEditorPane)scrollPane.getTextArea();
            this.addTextAreaImpl(editorPane.getFileName(), (Component)scrollPane, editorPane.getFileFullPath());
            editorPane.removePropertyChangeListener(fromPanel);
            editorPane.removeHyperlinkListener(fromPanel);
            editorPane.addPropertyChangeListener(this);
            editorPane.addHyperlinkListener(this);
        }
        this.removeComponentAt(0);
        this.renumberDisplayNames();
        this.setSelectedIndex(fromSelectedIndex);
        this.spellingSupport = fromPanel.spellingSupport;
    }

    protected ErrorStrip createErrorStrip(RTextEditorPane textArea) {
        ErrorStrip strip = new ErrorStrip((RSyntaxTextArea)textArea);
        strip.setLevelThreshold(ParserNotice.Level.WARNING);
        return strip;
    }

    private RTextEditorPane createRTextEditorPane(String fileName, String encoding) throws IOException {
        return this.createRTextEditorPane(FileLocation.create((String)fileName), encoding);
    }

    private RTextEditorPane createRTextEditorPane(FileLocation loc, String encoding) throws IOException {
        String style = this.getSyntaxStyleForFile(loc.getFileName());
        RTextEditorPane pane = new RTextEditorPane(this.owner, this.lineWrapEnabled, this.textMode, loc, encoding);
        pane.setFont(this.getTextAreaFont());
        pane.setForeground(this.getTextAreaForeground());
        pane.setBackgroundObject(this.getBackgroundObject());
        pane.setTabSize(this.getTabSize());
        pane.setHighlightCurrentLine(this.highlightCurrentLine);
        pane.setCurrentLineHighlightColor(this.getCurrentLineHighlightColor());
        pane.setMarginLineEnabled(this.marginLineEnabled);
        pane.setMarginLinePosition(this.getMarginLinePosition());
        pane.setMarginLineColor(this.getMarginLineColor());
        pane.setHighlightSecondaryLanguages(this.getHighlightSecondaryLanguages());
        for (int i = 0; i < this.secondaryLanguageColors.length; ++i) {
            pane.setSecondaryLanguageBackground(i + 1, this.getSecondaryLanguageColor(i));
        }
        pane.setMarkAllHighlightColor(this.getMarkAllHighlightColor());
        pane.setMarkOccurrences(this.getMarkOccurrences());
        pane.setMarkOccurrencesColor(this.getMarkOccurrencesColor());
        this.setSyntaxStyle(pane, style);
        pane.setBracketMatchingEnabled(this.isBracketMatchingEnabled());
        pane.setPaintMatchedBracketPair(this.getMatchBothBrackets());
        pane.setMatchedBracketBGColor(this.getMatchedBracketBGColor());
        pane.setMatchedBracketBorderColor(this.getMatchedBracketBorderColor());
        if (this.defaultLineTerminator != null && pane.getDocument().getLength() == 0) {
            pane.setLineSeparator(this.defaultLineTerminator, false);
        }
        pane.setWhitespaceVisible(this.isWhitespaceVisible());
        pane.setPaintTabLines(this.getShowTabLines());
        pane.setTabLineColor(this.getTabLinesColor());
        pane.setEOLMarkersVisible(this.getShowEOLMarkers());
        pane.setClearWhitespaceLinesEnabled(!this.rememberWhitespaceLines);
        pane.setCloseCurlyBraces(this.autoInsertClosingCurlys);
        pane.setCaretColor(this.getCaretColor());
        pane.setSelectionColor(this.getSelectionColor());
        pane.setSelectedTextColor(this.getSelectedTextColor());
        pane.setUseSelectedTextColor(this.getUseSelectedTextColor());
        pane.setSyntaxScheme(this.owner.getSyntaxScheme());
        pane.setHyperlinksEnabled(this.getHyperlinksEnabled());
        pane.setHyperlinkForeground(this.getHyperlinkColor());
        pane.setLinkScanningMask(this.getHyperlinkModifierKey());
        pane.setRoundedSelectionEdges(this.getRoundedSelectionEdges());
        pane.setCaretStyle(0, this.carets[0]);
        pane.setCaretStyle(1, this.carets[1]);
        pane.getCaret().setBlinkRate(this.getCaretBlinkRate());
        if (RTextEditorPane.isRecordingMacro()) {
            pane.setCursor(AbstractMainView.getMacroCursor());
        }
        pane.setTabsEmulated(this.emulateTabsWithWhitespace);
        pane.setAntiAliasingEnabled(this.aaEnabled);
        pane.setFractionalFontMetricsEnabled(this.isFractionalFontMetricsEnabled());
        pane.setCodeFoldingEnabled(this.isCodeFoldingEnabledFor(style));
        pane.addPropertyChangeListener(this.owner);
        pane.addPropertyChangeListener((StatusBar)this.owner.getStatusBar());
        pane.addPropertyChangeListener(this);
        pane.addHyperlinkListener(this);
        if (this.spellingSupport.isSpellCheckingEnabled()) {
            pane.addParser((Parser)this.spellingSupport.getSpellingParser());
        }
        InputMap im = pane.getInputMap();
        ActionMap am = pane.getActionMap();
        am.put("RTA.ToggleTextModeAction", (Action)((Object)this.toggleTextModeAction));
        im.put(KeyStroke.getKeyStroke(20, 0), "OnCapsLock");
        am.put("OnCapsLock", (Action)((Object)this.capsLockAction));
        return pane;
    }

    private RTextScrollPane createScrollPane(RTextEditorPane textArea) {
        RTextScrollPane scrollPane = new RTextScrollPane((Component)((Object)textArea), this.lineNumbersEnabled, null);
        scrollPane.applyComponentOrientation(this.getComponentOrientation());
        Gutter gutter = scrollPane.getGutter();
        gutter.setBookmarkIcon(this.bookmarkIcon);
        gutter.setBookmarkingEnabled(this.bookmarksEnabled);
        gutter.setLineNumberFont(this.lineNumberFont);
        gutter.setLineNumberColor(this.lineNumberColor);
        gutter.setBorderColor(this.gutterBorderColor);
        scrollPane.setIconRowHeaderEnabled(true);
        Color activeLineRangeColor = this.getAppropriateActiveLineRangeColor();
        gutter.setActiveLineRangeColor(activeLineRangeColor);
        RTextUtilities.removeTabbedPaneFocusTraversalKeyBindings((JComponent)scrollPane);
        return scrollPane;
    }

    public void dispose() {
    }

    private void ensureFilesAreOpened() {
        if (this.getNumDocuments() == 0) {
            this.addNewEmptyUntitledFile();
        }
    }

    public void findInFilesFileSelected(FindInFilesEvent e) {
        String fileName = e.getFileName();
        if (!this.openFile(fileName, null, true)) {
            JOptionPane.showMessageDialog((Component)((Object)this.findInFilesDialog), this.owner.getString("ErrorReloadFNF", new Object[0]), this.owner.getString("ErrorDialogTitle", new Object[0]), 0);
            return;
        }
        FindInFilesDialog fnfd = (FindInFilesDialog)((Object)e.getSource());
        String desc = this.owner.getString("FileOpened", new Object[]{fileName});
        fnfd.setStatusText(desc);
        int line = e.getLine();
        if (line != -1) {
            try {
                int start = this.currentTextArea.getLineStartOffset(line - 1);
                int end = this.currentTextArea.getLineEndOffset(line - 1) - 1;
                this.currentTextArea.setCaretPosition(end);
                this.currentTextArea.moveCaretPosition(start);
                this.currentTextArea.getCaret().setSelectionVisible(true);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RTextUtilities.centerSelectionVertically((RSyntaxTextArea)AbstractMainView.this.currentTextArea);
                    }
                });
            }
            catch (Exception exc) {
                this.owner.displayException(exc);
                this.moveToTopOfCurrentDocument();
            }
        } else {
            this.moveToTopOfCurrentDocument();
        }
    }

    protected void fireCurrentTextAreaEvent(int type, Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CurrentTextAreaListener.class) continue;
            ((CurrentTextAreaListener)listeners[i + 1]).currentTextAreaPropertyChanged(new CurrentTextAreaEvent(this, type, oldValue, newValue));
        }
    }

    private Color getAppropriateActiveLineRangeColor() {
        JLabel c = this.owner.getJMenuBar() != null ? this.owner.getJMenuBar().getMenu(0) : new JLabel();
        Color fg = c.getForeground();
        return Util.isLightForeground((Color)fg) ? fg : null;
    }

    public boolean getAutoInsertClosingCurlys() {
        return this.autoInsertClosingCurlys;
    }

    public float getBackgroundImageAlpha() {
        return this.imageAlpha;
    }

    public String getBackgroundImageFileName() {
        return this.backgroundImageFileName;
    }

    public Object getBackgroundObject() {
        return this.backgroundObject;
    }

    public boolean getBookmarksEnabled() {
        return this.bookmarksEnabled;
    }

    public int getCaretBlinkRate() {
        return this.caretBlinkRate;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public CaretStyle getCaretStyle(int mode) {
        return this.carets[mode];
    }

    public String getCodeFoldingEnabledForString() {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, Boolean>> entrySet = this.codeFoldingEnabledStates.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            if (!Boolean.TRUE.equals(entry.getValue())) continue;
            sb.append(entry.getKey() + ",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public Color getCurrentLineHighlightColor() {
        return this.currentLineColor;
    }

    public RTextEditorPane getCurrentTextArea() {
        return this.currentTextArea;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private final String getDefaultFileName() {
        return this.owner.getWorkingDirectory() + System.getProperty("file.separator") + this.owner.getNewFileName();
    }

    public boolean getDoFileSizeCheck() {
        return this.doFileSizeCheck;
    }

    public abstract String getDocumentDisplayNameAt(int var1);

    public abstract int getDocumentSelectionPlacement();

    public int getFileIndex(String fileFullPath) {
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            if (!this.getRTextEditorPaneAt(i).getFileFullPath().equals(fileFullPath)) continue;
            return i;
        }
        return -1;
    }

    private boolean getFileIsTooLarge(String fileName) {
        String desc;
        int rc;
        float maxFileSizeMB;
        File file;
        float fileSizeMB;
        if (this.getDoFileSizeCheck() && (fileSizeMB = (float)(file = new File(fileName)).length() / 1000000.0f) > (maxFileSizeMB = this.getMaxFileSize()) && (rc = JOptionPane.showConfirmDialog(this, desc = this.owner.getString("OpeningLargeFile", new Object[]{file.getAbsolutePath()}), this.owner.getString("ConfDialogTitle", new Object[0]), 0)) != 0) {
            this.ensureFilesAreOpened();
            return true;
        }
        return false;
    }

    public boolean getGuessFileContentType() {
        return this.guessFileContentType;
    }

    public Color getGutterBorderColor() {
        return this.gutterBorderColor;
    }

    public boolean getHighlightSecondaryLanguages() {
        return this.highlightSecondaryLanguages;
    }

    public Color getHyperlinkColor() {
        return this.hyperlinkColor;
    }

    public int getHyperlinkModifierKey() {
        return this.hyperlinkModifierKey;
    }

    public boolean getHyperlinksEnabled() {
        return this.hyperlinksEnabled;
    }

    protected Icon getIconFor(RTextScrollPane scrollPane) {
        RTextEditorPane textArea = (RTextEditorPane)scrollPane.getTextArea();
        return FileTypeIconManager.get().getIconFor(textArea);
    }

    public boolean getIgnoreBackupExtensions() {
        return this.ignoreBackupExtensions;
    }

    public Color getLineNumberColor() {
        return this.lineNumberColor;
    }

    public Font getLineNumberFont() {
        return this.lineNumberFont;
    }

    public boolean getLineNumbersEnabled() {
        return this.lineNumbersEnabled;
    }

    public String getLineTerminator() {
        return this.defaultLineTerminator;
    }

    public boolean getLineWrap() {
        return this.lineWrapEnabled;
    }

    private static final synchronized Cursor getMacroCursor() {
        if (macroCursor == null) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension dim = toolkit.getBestCursorSize(16, 16);
                BufferedImage transparentImage = new BufferedImage(dim.width, dim.height, 2);
                Graphics2D g2d = transparentImage.createGraphics();
                BufferedImage image = null;
                ClassLoader cl = AbstractMainView.class.getClassLoader();
                image = ImageIO.read(cl.getResource("org/fife/rtext/graphics/macrocursor.gif"));
                g2d.drawImage((Image)image, 0, 0, null);
                g2d.dispose();
                Point hotspot = new Point(0, 0);
                macroCursor = toolkit.createCustomCursor(transparentImage, hotspot, "macroCursor");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                macroCursor = Cursor.getPredefinedCursor(1);
            }
        }
        return macroCursor;
    }

    public Color getMarginLineColor() {
        return this.marginLineColor;
    }

    public int getMarginLinePosition() {
        return this.marginLinePosition;
    }

    public Color getMarkAllHighlightColor() {
        return this.markAllHighlightColor;
    }

    public boolean getMarkOccurrences() {
        return this.markOccurrences;
    }

    public Color getMarkOccurrencesColor() {
        return this.markOccurrencesColor;
    }

    public boolean getMatchBothBrackets() {
        return this.matchBothBrackets;
    }

    public Color getMatchedBracketBGColor() {
        return this.matchedBracketBGColor;
    }

    public Color getMatchedBracketBorderColor() {
        return this.matchedBracketBorderColor;
    }

    public float getMaxFileSize() {
        return this.maxFileSize;
    }

    public Color getModifiedDocumentDisplayNamesColor() {
        return this.modifiedDocumentDisplayNameColor;
    }

    public abstract int getNumDocuments();

    public File[] getOpenFiles() {
        int num = this.getNumDocuments();
        if (num == 0) {
            return null;
        }
        File[] files = new File[num];
        for (int i = 0; i < num; ++i) {
            files[i] = new File(this.getRTextEditorPaneAt(i).getFileFullPath());
        }
        return files;
    }

    public Font getPrintFont() {
        return this.printFont;
    }

    public boolean getRememberWhitespaceLines() {
        return this.rememberWhitespaceLines;
    }

    public boolean getRoundedSelectionEdges() {
        return this.roundedSelectionEdges;
    }

    public RTextEditorPane getRTextEditorPaneAt(int index) {
        RTextScrollPane sp = this.getRTextScrollPaneAt(index);
        return sp != null ? (RTextEditorPane)sp.getTextArea() : null;
    }

    public abstract RTextScrollPane getRTextScrollPaneAt(int var1);

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    public Color getSecondaryLanguageColor(int index) {
        return this.secondaryLanguageColors[index];
    }

    public abstract Component getSelectedComponent();

    public abstract int getSelectedIndex();

    public String getSelectedText() {
        return this.getCurrentTextArea().getSelectedText();
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public boolean getShowEOLMarkers() {
        return this.showEOLMarkers;
    }

    public boolean getShowTabLines() {
        return this.showTabLines;
    }

    public SpellingSupport getSpellingSupport() {
        return this.spellingSupport;
    }

    public SyntaxFilters getSyntaxFilters() {
        return this.syntaxFilters;
    }

    public String getSyntaxStyleForFile(String fileName) {
        return this.syntaxFilters.getSyntaxStyleForFile(fileName, this.getIgnoreBackupExtensions());
    }

    public Color getTabLinesColor() {
        return this.tabLinesColor;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public Font getTextAreaFont() {
        return this.textAreaFont;
    }

    public Color getTextAreaForeground() {
        return this.textAreaForeground;
    }

    public ComponentOrientation getTextAreaOrientation() {
        return this.textAreaOrientation;
    }

    public boolean getTextAreaUnderline() {
        return this.textAreaUnderline;
    }

    public int getTextMode() {
        return this.textMode;
    }

    public boolean getUseSelectedTextColor() {
        return this.useSelectedTextColor;
    }

    public boolean getWriteBOMInUtf8Files() {
        return UnicodeWriter.getWriteUtf8BOM();
    }

    private static final void guessContentType(RTextEditorPane pane) {
        String style = "text/plain";
        String firstLine = null;
        try {
            int endOffs = pane.getLineEndOffset(0);
            if (pane.getLineCount() > 1) {
                --endOffs;
            }
            firstLine = pane.getText(0, endOffs);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            return;
        }
        if (firstLine.startsWith("#!")) {
            int space = firstLine.indexOf(32, 2);
            if (space > -1) {
                if (firstLine.startsWith("#!/usr/bin/env")) {
                    int space2 = firstLine.indexOf(32, space + 1);
                    if (space2 == -1) {
                        space2 = firstLine.length();
                    }
                    firstLine = firstLine.substring(space + 1, space2);
                } else {
                    firstLine = firstLine.substring(2, space);
                }
            }
            if (firstLine.endsWith("sh")) {
                style = "text/unix";
            } else if (firstLine.endsWith("perl")) {
                style = "text/perl";
            } else if (firstLine.endsWith("php")) {
                style = "text/php";
            } else if (firstLine.endsWith("python")) {
                style = "text/python";
            } else if (firstLine.endsWith("lua")) {
                style = "text/lua";
            } else if (firstLine.endsWith("ruby")) {
                style = "text/ruby";
            }
        } else if (firstLine.startsWith("<?xml") && firstLine.endsWith("?>")) {
            style = "text/xml";
        }
        pane.setSyntaxEditingStyle(style);
    }

    private void handleAddTextFileIOException(FileLocation loc, IOException ioe, boolean load) {
        String desc = null;
        String title = this.owner.getString("ErrorDialogTitle", new Object[0]);
        if ("sun.net.ftp.FtpLoginException".equals(ioe.getClass().getName())) {
            desc = this.owner.getString("ErrorCredentials", new Object[0]);
            JOptionPane.showMessageDialog(this, desc, title, 0);
        } else if (ioe instanceof ConnectException) {
            desc = this.owner.getString("ErrorConnectionRefused", new Object[0]);
            JOptionPane.showMessageDialog(this, desc, title, 0);
        } else if (ioe instanceof UnknownHostException) {
            String host = ioe.getMessage();
            if (host == null) {
                host = "";
            }
            desc = this.owner.getString("ErrorUnknownHost", new Object[]{host});
            JOptionPane.showMessageDialog(this, desc, title, 0);
        } else if (ioe instanceof FileNotFoundException) {
            if (load) {
                desc = this.owner.getString("ErrorFileNotFound", new Object[]{loc.getFileName()});
                JOptionPane.showMessageDialog(this, desc, title, 0);
            } else {
                desc = ioe.getMessage();
                if (desc == null) {
                    desc = ioe.toString();
                }
                this.owner.displayException(ioe, desc);
            }
        } else {
            desc = ioe.getMessage();
            if (desc == null) {
                desc = ioe.toString();
            }
            this.owner.displayException(ioe, desc);
        }
    }

    private void handleFileModifiedEvent(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text.substring(text.indexOf(32)));
        int origTab = this.getSelectedIndex();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int docNumber = 0;
            try {
                docNumber = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            this.setSelectedIndex(docNumber);
            int rc = 1;
            String temp = this.owner.getString("DocModifiedMessage", new Object[]{this.currentTextArea.getFileName()});
            rc = JOptionPane.showConfirmDialog((Component)((Object)this.owner), temp, this.owner.getString("ConfDialogTitle", new Object[0]), 0, 3);
            if (rc == 0) {
                try {
                    File f = new File(this.currentTextArea.getFileFullPath());
                    if (f.isFile()) {
                        int line = this.currentTextArea.getLineOfOffset(this.currentTextArea.getCaretPosition());
                        this.currentTextArea.reload();
                        int lineCount = this.currentTextArea.getLineCount();
                        line = Math.min(line, lineCount - 1);
                        int offs = this.currentTextArea.getLineStartOffset(line);
                        this.currentTextArea.setCaretPosition(offs);
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)this.owner), this.owner.getString("ErrorReloadFNF", new Object[0]), this.owner.getString("ErrorDialogTitle", new Object[0]), 0);
                    }
                }
                catch (Exception ioe) {
                    JOptionPane.showMessageDialog((Component)((Object)this.owner), this.owner.getString("ErrorReadingFile", new Object[0]) + ioe, this.owner.getString("ErrorDialogTitle", new Object[0]), 0);
                }
            }
            this.currentTextArea.syncLastSaveOrLoadTimeToActualFile();
        }
        this.checkForModification = true;
        this.setSelectedIndex(origTab);
    }

    public boolean highlightModifiedDocumentDisplayNames() {
        return this.highlightModifiedDocDisplayNames;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            if (url != null) {
                if (!UIUtil.browse((String)url.toString())) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this);
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    protected void initialize(RText owner, String[] filesToOpen, RTextPrefs prefs) {
        int i;
        this.owner = owner;
        this.searchManager = new SearchManager(owner);
        this.printFont = prefs.printFont;
        this.tabSize = prefs.tabSize;
        this.textMode = prefs.textMode;
        this.emulateTabsWithWhitespace = prefs.emulateTabsWithSpaces;
        this.setDocumentSelectionPlacement(prefs.tabPlacement);
        this.lineNumbersEnabled = prefs.lineNumbersVisible;
        this.setBackgroundImageAlpha(prefs.imageAlpha);
        Object prefsBackgroundObject = prefs.backgroundObject;
        if (prefsBackgroundObject instanceof String) {
            Image image = RTextUtilities.getImageFromFile((String)prefsBackgroundObject);
            if (image != null) {
                this.setBackgroundObject(image);
                this.setBackgroundImageFileName((String)prefsBackgroundObject);
            } else {
                this.setBackgroundObject(Color.WHITE);
                this.setBackgroundImageFileName(null);
            }
        } else {
            this.setBackgroundObject(prefsBackgroundObject);
            this.setBackgroundImageFileName(null);
        }
        this.setCaretColor(prefs.caretColor);
        this.setSelectionColor(prefs.selectionColor);
        this.setSelectedTextColor(prefs.selectedTextColor);
        this.setUseSelectedTextColor(prefs.useSelectedTextColor);
        this.setLineWrap(prefs.wordWrap);
        this.setCurrentLineHighlightEnabled(prefs.currentLineHighlightEnabled);
        this.setCurrentLineHighlightColor(prefs.currentLineHighlightColor);
        this.setBracketMatchingEnabled(prefs.bracketMatchingEnabled);
        this.setMatchBothBrackets(prefs.matchBothBrackets);
        this.setMatchedBracketBGColor(prefs.matchedBracketBGColor);
        this.setMatchedBracketBorderColor(prefs.matchedBracketBorderColor);
        this.setMarginLineEnabled(prefs.marginLineEnabled);
        this.setMarginLinePosition(prefs.marginLinePosition);
        this.setMarginLineColor(prefs.marginLineColor);
        this.setHighlightSecondaryLanguages(prefs.highlightSecondaryLanguages);
        this.secondaryLanguageColors = new Color[3];
        for (int i2 = 0; i2 < this.secondaryLanguageColors.length; ++i2) {
            this.setSecondaryLanguageColor(i2, prefs.secondaryLanguageColors[i2]);
        }
        this.setHyperlinksEnabled(prefs.hyperlinksEnabled);
        this.setHyperlinkColor(prefs.hyperlinkColor);
        this.setHyperlinkModifierKey(prefs.hyperlinkModifierKey);
        this.setWriteBOMInUtf8Files(prefs.bomInUtf8);
        this.syntaxFilters = new SyntaxFilters(prefs.syntaxFiltersString);
        this.searchContext = new FindInFilesSearchContext();
        this.setHighlightModifiedDocumentDisplayNames(prefs.highlightModifiedDocNames);
        this.setModifiedDocumentDisplayNamesColor(prefs.modifiedDocumentNamesColor);
        this.setWhitespaceVisible(prefs.visibleWhitespace);
        this.setShowEOLMarkers(prefs.showEOLMarkers);
        this.setShowTabLines(prefs.showTabLines);
        this.setTabLinesColor(prefs.tabLinesColor);
        this.setRememberWhitespaceLines(prefs.rememberWhitespaceLines);
        this.setAutoInsertClosingCurlys(prefs.autoInsertClosingCurlys);
        this.setAntiAliasEnabled(prefs.aaEnabled);
        this.setFractionalFontMetricsEnabled(prefs.fractionalMetricsEnabled);
        this.setMarkAllHighlightColor(prefs.markAllHighlightColor);
        this.setMarkOccurrences(prefs.markOccurrences);
        this.setMarkOccurrencesColor(prefs.markOccurrencesColor);
        this.setRoundedSelectionEdges(prefs.roundedSelectionEdges);
        this.carets = new CaretStyle[2];
        this.setCaretStyle(0, CaretStyle.values()[prefs.carets[0]]);
        this.setCaretStyle(1, CaretStyle.values()[prefs.carets[1]]);
        this.setCaretBlinkRate(prefs.caretBlinkRate);
        this.setLineTerminator(prefs.defaultLineTerminator);
        this.setDefaultEncoding(prefs.defaultEncoding);
        this.setGuessFileContentType(prefs.guessFileContentType);
        this.setDoFileSizeCheck(prefs.doFileSizeCheck);
        this.setMaxFileSize(prefs.maxFileSize);
        this.setIgnoreBackupExtensions(prefs.ignoreBackupExtensions);
        this.setTextAreaFont(prefs.textAreaFont, prefs.textAreaUnderline);
        this.setTextAreaForeground(prefs.textAreaForeground);
        this.setTextAreaOrientation(prefs.textAreaOrientation);
        this.setBookmarksEnabled(prefs.bookmarksEnabled);
        this.setLineNumberFont(prefs.lineNumberFont);
        this.setLineNumberColor(prefs.lineNumberColor);
        this.setGutterBorderColor(prefs.gutterBorderColor);
        this.spellingSupport = new SpellingSupport(owner);
        this.spellingSupport.configure(prefs);
        this.toggleTextModeAction = new ToggleTextModeAction(owner);
        this.capsLockAction = new CapsLockAction(owner);
        this.codeFoldingEnabledStates = new HashMap<String, Boolean>();
        if (prefs.codeFoldingEnabledFor != null) {
            String[] languages = prefs.codeFoldingEnabledFor.split(",");
            for (i = 0; i < languages.length; ++i) {
                this.codeFoldingEnabledStates.put(languages[i], Boolean.TRUE);
            }
        }
        SearchManager.SearchingMode searchingMode = prefs.useSearchDialogs ? SearchManager.SearchingMode.DIALOGS : SearchManager.SearchingMode.TOOLBARS;
        this.getSearchManager().setSearchingMode(searchingMode);
        if (filesToOpen == null) {
            this.addNewEmptyUntitledFile();
        } else {
            for (i = 0; i < filesToOpen.length; ++i) {
                this.openFile(filesToOpen[i], null);
            }
        }
        this.setSelectedIndex(0);
        owner.setMessages(this.currentTextArea.getFileFullPath(), null);
    }

    public boolean isAntiAliasEnabled() {
        return this.aaEnabled;
    }

    public boolean isBracketMatchingEnabled() {
        return this.bracketMatchingEnabled;
    }

    public boolean isCodeFoldingEnabledFor(String language) {
        return Boolean.TRUE.equals(this.codeFoldingEnabledStates.get(language));
    }

    public boolean isCurrentLineHighlightEnabled() {
        return this.highlightCurrentLine;
    }

    public boolean isFractionalFontMetricsEnabled() {
        return this.fractionalMetricsEnabled;
    }

    public boolean isMarginLineEnabled() {
        return this.marginLineEnabled;
    }

    public boolean isWhitespaceVisible() {
        return this.whitespaceVisible;
    }

    public void loadMacro(File file) {
        try {
            RTextEditorPane.loadMacro((Macro)new Macro(file));
        }
        catch (Exception e) {
            this.owner.displayException(e);
        }
    }

    public void moveToTopOfCurrentDocument() {
        this.currentTextArea.setCaretPosition(0);
    }

    public boolean openFile(FileLocation loc, String charSet, boolean reuse) {
        if (this.getNumDocuments() == 1 && this.currentTextArea.getFileName().equals(this.owner.getNewFileName()) && this.currentTextArea.getDocument().getLength() == 0 && !this.currentTextArea.isDirty()) {
            this.removeComponentAt(0);
        }
        if (reuse) {
            String fileNameAndPath = loc.getFileFullPath();
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                if (!textArea.getFileFullPath().equals(fileNameAndPath)) continue;
                this.setSelectedIndex(i);
                return true;
            }
        }
        String fileFullPath = loc.getFileFullPath();
        if (loc.isLocalAndExists() || loc.isRemote()) {
            if (loc.isLocal() && this.getFileIsTooLarge(fileFullPath)) {
                return false;
            }
            try {
                RTextEditorPane tempTextArea = this.createRTextEditorPane(loc, charSet);
                this.addTextArea(tempTextArea);
            }
            catch (IOException ioe) {
                this.handleAddTextFileIOException(loc, ioe, true);
                this.ensureFilesAreOpened();
                return false;
            }
            catch (OutOfMemoryError oome) {
                this.owner.displayException(oome);
                this.ensureFilesAreOpened();
                return false;
            }
            return true;
        }
        String temp = this.owner.getString("FileNECreateItMsg", new Object[]{fileFullPath});
        if (0 == JOptionPane.showConfirmDialog(this, temp, this.owner.getString("ConfDialogTitle", new Object[0]), 0)) {
            this.addNewEmptyFile(fileFullPath, charSet);
            return true;
        }
        this.ensureFilesAreOpened();
        return false;
    }

    public boolean openFile(String fileNameAndPath, String charSet) {
        return this.openFile(fileNameAndPath, charSet, false);
    }

    public boolean openFile(String fileNameAndPath, String charSet, boolean reuse) {
        return this.openFile(FileLocation.create((String)fileNameAndPath), charSet, reuse);
    }

    protected int promptToSaveBeforeClosingIfDirty() {
        int rc = 0;
        if (this.currentTextArea.isDirty()) {
            String temp = this.owner.getString("SaveChangesPrompt", new Object[]{this.currentTextArea.getFileName()});
            rc = JOptionPane.showConfirmDialog((Component)((Object)this.owner), temp, this.owner.getString("ConfDialogTitle", new Object[0]), 1);
            switch (rc) {
                case 0: {
                    if (this.saveCurrentFile()) break;
                    return 2;
                }
                case -1: 
                case 2: {
                    return 2;
                }
            }
        }
        return rc;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("TextEditorPane.fileFullPath")) {
            this.setDocumentDisplayNameAt(this.getSelectedIndex(), this.currentTextArea.getFileName());
            this.fireCurrentTextAreaEvent(2, e.getOldValue(), e.getNewValue());
        } else if (propertyName.equals("TextEditorPane.dirty")) {
            int selectedIndex = this.getSelectedIndex();
            String oldTitle = this.getDocumentDisplayNameAt(selectedIndex);
            if (((Boolean)e.getNewValue()).booleanValue()) {
                this.setDocumentDisplayNameAt(selectedIndex, oldTitle + "*");
            } else {
                this.setDocumentDisplayNameAt(selectedIndex, oldTitle.substring(0, oldTitle.length() - 1));
            }
            this.fireCurrentTextAreaEvent(1, e.getOldValue(), e.getNewValue());
        } else if (propertyName.equals("RSTA.syntaxStyle")) {
            this.fireCurrentTextAreaEvent(3, e.getOldValue(), e.getNewValue());
        }
    }

    private void refreshActiveLineRangeColors() {
        Color activeLineRangeColor = this.getAppropriateActiveLineRangeColor();
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            Gutter gutter = this.getRTextScrollPaneAt(i).getGutter();
            gutter.setActiveLineRangeColor(activeLineRangeColor);
        }
    }

    public abstract void refreshDisplayNames();

    public void renumberDisplayNames() {
        int numDocuments = this.getNumDocuments();
        if (numDocuments > 0) {
            boolean[] doneYet = new boolean[numDocuments];
            for (int i = 0; i < numDocuments; ++i) {
                String title;
                if (doneYet[i]) continue;
                RTextEditorPane pane_I = this.getRTextEditorPaneAt(i);
                String fileFullPath = pane_I.getFileFullPath();
                int count = 1;
                for (int j = i + 1; j < numDocuments; ++j) {
                    RTextEditorPane pane = this.getRTextEditorPaneAt(j);
                    if (doneYet[j] || !pane.getFileFullPath().equals(fileFullPath)) continue;
                    String title2 = pane.getFileName() + " (" + ++count + ")";
                    if (pane.isDirty()) {
                        title2 = title2 + "*";
                    }
                    this.setDocumentDisplayNameAt(j, title2);
                    doneYet[j] = true;
                }
                if (count > 1) {
                    title = pane_I.getFileName() + " (1)";
                    if (pane_I.isDirty()) {
                        title = title + "*";
                    }
                    this.setDocumentDisplayNameAt(i, title);
                } else {
                    title = pane_I.getFileName();
                    if (pane_I.isDirty()) {
                        title = title + "*";
                    }
                    this.setDocumentDisplayNameAt(i, title);
                }
                doneYet[i] = true;
            }
        }
    }

    public boolean requestFocusInWindow() {
        if (this.currentTextArea != null) {
            return this.currentTextArea.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    protected abstract void removeComponentAt(int var1);

    public void removeCurrentTextAreaListener(CurrentTextAreaListener l) {
        this.listenerList.remove(CurrentTextAreaListener.class, l);
    }

    public synchronized boolean saveAllFiles() {
        boolean allSaved = true;
        int currentTab = this.getSelectedIndex();
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            if (this.getRTextEditorPaneAt(i).isReadOnly()) continue;
            this.setSelectedIndex(i);
            allSaved |= this.saveCurrentFile();
        }
        this.setSelectedIndex(currentTab);
        return allSaved;
    }

    public synchronized boolean saveCurrentFile() {
        if (this.currentTextArea.getFileName().equals(this.owner.getNewFileName())) {
            return this.saveCurrentFileAs();
        }
        try {
            this.currentTextArea.save();
            return true;
        }
        catch (Exception e) {
            String temp = this.owner.getString("ErrorWritingFile", new Object[]{this.currentTextArea.getFileFullPath(), e.getMessage()});
            JOptionPane.showMessageDialog(this, temp, this.owner.getString("ErrorDialogTitle", new Object[0]), 0);
            this.owner.setMessages(null, "ERROR:  Could not save file!");
            return false;
        }
    }

    public synchronized boolean saveCurrentFileAs() {
        this.currentTextArea.requestFocusInWindow();
        RTextFileChooser chooser = this.owner.getFileChooser();
        chooser.setMultiSelectionEnabled(false);
        File initialSelection = new File(this.currentTextArea.getFileFullPath());
        chooser.setSelectedFile(initialSelection);
        chooser.setOpenedFiles(this.getOpenFiles());
        chooser.setEncoding(this.currentTextArea.getEncoding());
        int returnVal = chooser.showSaveDialog((Window)((Object)this.owner));
        if (returnVal == 0) {
            String temp;
            File chosenFile = chooser.getSelectedFile();
            String chosenFileName = chosenFile.getName();
            String chosenFilePath = chosenFile.getAbsolutePath();
            String encoding = chooser.getEncoding();
            String extension = chooser.getFileFilter().getDescription();
            int leftParen = extension.indexOf("(*");
            if (leftParen > -1) {
                int start = leftParen + 2;
                int end = extension.indexOf(41, start);
                int comma = extension.indexOf(44, start);
                if (comma > -1 && comma < end) {
                    end = comma;
                }
                if (end > start + 1) {
                    extension = extension.substring(start, end);
                    if (chosenFileName.indexOf(46) == -1) {
                        chosenFileName = chosenFileName + extension;
                        chosenFilePath = chosenFilePath + extension;
                        chosenFile = new File(chosenFilePath);
                    }
                }
            }
            if (chosenFile.exists() && 0 != JOptionPane.showConfirmDialog(this, temp = this.owner.getString("FileAlreadyExists", new Object[]{chosenFile.getName()}), this.owner.getString("ConfDialogTitle", new Object[0]), 0)) {
                return false;
            }
            String oldEncoding = this.currentTextArea.getEncoding();
            if (encoding != null && !encoding.equals(oldEncoding)) {
                this.currentTextArea.setEncoding(encoding);
            }
            return this.saveCurrentFileAs(FileLocation.create((String)chosenFilePath));
        }
        return false;
    }

    public synchronized boolean saveCurrentFileAs(FileLocation loc) {
        try {
            this.currentTextArea.saveAs(loc);
        }
        catch (IOException ioe) {
            this.handleAddTextFileIOException(loc, ioe, false);
            this.ensureFilesAreOpened();
            return false;
        }
        catch (OutOfMemoryError oome) {
            this.owner.displayException(oome);
            this.ensureFilesAreOpened();
            return false;
        }
        String newStyle = this.getSyntaxStyleForFile(loc.getFileName());
        this.setSyntaxStyle(this.currentTextArea, newStyle);
        this.currentTextArea.setCodeFoldingEnabled(this.isCodeFoldingEnabledFor(newStyle));
        this.renumberDisplayNames();
        return true;
    }

    public void searchEvent(SearchEvent e) {
        switch (e.getType()) {
            case MARK_ALL: {
                RTextEditorPane textArea = this.getCurrentTextArea();
                SearchEngine.markAll((RTextArea)textArea, (SearchContext)this.searchContext);
                break;
            }
            case FIND: {
                this.owner.getAction("findNextAction").actionPerformed(null);
                break;
            }
            case REPLACE: {
                this.owner.getAction("replaceNextAction").actionPerformed(null);
                break;
            }
            case REPLACE_ALL: {
                this.owner.getAction("replaceAllAction").actionPerformed(null);
            }
        }
    }

    public void setAntiAliasEnabled(boolean enabled) {
        if (enabled != this.aaEnabled) {
            this.aaEnabled = enabled;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setAntiAliasingEnabled(this.aaEnabled);
            }
            this.firePropertyChange(SMOOTH_TEXT_PROPERTY, !this.aaEnabled, this.aaEnabled);
        }
    }

    public void setAutoInsertClosingCurlys(boolean autoInsert) {
        if (autoInsert != this.autoInsertClosingCurlys) {
            this.autoInsertClosingCurlys = autoInsert;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.setCloseCurlyBraces(autoInsert);
            }
            this.firePropertyChange(AUTO_INSERT_CLOSING_CURLYS, !autoInsert, autoInsert);
        }
    }

    public void setBackgroundImageAlpha(float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        this.imageAlpha = alpha;
    }

    public void setBackgroundImageFileName(String path) {
        this.backgroundImageFileName = path;
    }

    public void setBackgroundObject(Object newBackground) {
        if (newBackground instanceof Color) {
            this.backgroundObject = newBackground;
        } else if (newBackground instanceof Image) {
            this.backgroundObject = RTextUtilities.getTranslucentImage(this.owner, (Image)newBackground, this.imageAlpha);
        } else {
            ResourceBundle msg = this.owner.getResourceBundle();
            JOptionPane.showMessageDialog(this, "Invalid background Object type:\n" + newBackground, msg.getString("ErrorDialogTitle"), 0);
            this.backgroundObject = Color.WHITE;
        }
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            this.getRTextEditorPaneAt(i).setBackgroundObject(this.backgroundObject);
        }
    }

    public void setBookmarksEnabled(boolean enabled) {
        if (enabled != this.bookmarksEnabled) {
            int docCount = this.getNumDocuments();
            for (int i = 0; i < docCount; ++i) {
                Gutter g = this.getRTextScrollPaneAt(i).getGutter();
                g.setBookmarkingEnabled(enabled);
            }
            this.bookmarksEnabled = enabled;
        }
    }

    public void setBracketMatchingEnabled(boolean enabled) {
        if (enabled != this.bracketMatchingEnabled) {
            this.bracketMatchingEnabled = enabled;
            int num = this.getNumDocuments();
            for (int i = 0; i < num; ++i) {
                this.getRTextEditorPaneAt(i).setBracketMatchingEnabled(this.bracketMatchingEnabled);
            }
        }
    }

    public void setCaretBlinkRate(int blinkRate) {
        if (blinkRate >= 0 && blinkRate != this.caretBlinkRate) {
            this.caretBlinkRate = blinkRate;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                Caret c = this.getRTextEditorPaneAt(i).getCaret();
                if (c == null) continue;
                c.setBlinkRate(this.caretBlinkRate);
            }
        }
    }

    public void setCaretColor(Color color) {
        if (color != null && color != this.caretColor) {
            this.caretColor = color;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setCaretColor(color);
            }
        }
    }

    public void setCaretStyle(int mode, CaretStyle style) {
        if (mode != 0 && mode != 1) {
            return;
        }
        if (this.carets[mode] != style) {
            this.carets[mode] = style;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setCaretStyle(mode, style);
            }
        }
    }

    public void setCodeFoldingEnabledFor(String language, boolean enabled) {
        boolean prev = this.isCodeFoldingEnabledFor(language);
        if (enabled != prev) {
            this.codeFoldingEnabledStates.put(language, enabled);
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                if (!language.equals(textArea.getSyntaxEditingStyle())) continue;
                RTextScrollPane sp = this.getRTextScrollPaneAt(i);
                sp.getGutter().setFoldIndicatorEnabled(enabled);
                textArea.setCodeFoldingEnabled(enabled);
            }
        }
    }

    public void setCurrentLineHighlightColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.currentLineColor = color;
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
            textArea.setCurrentLineHighlightColor(this.currentLineColor);
        }
    }

    public void setCurrentLineHighlightEnabled(boolean enabled) {
        this.highlightCurrentLine = enabled;
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
            textArea.setHighlightCurrentLine(this.highlightCurrentLine);
        }
    }

    protected void setCurrentTextArea(RTextEditorPane textArea) {
        this.currentTextArea = textArea;
    }

    public void setDefaultEncoding(String encoding) {
        if (this.defaultEncoding != null && !this.defaultEncoding.equals(encoding) || this.defaultEncoding == null && encoding != null) {
            String old = this.defaultEncoding;
            this.defaultEncoding = encoding;
            this.firePropertyChange(DEFAULT_ENCODING_PROPERTY, old, encoding);
        }
    }

    public abstract void setDocumentDisplayNameAt(int var1, String var2);

    public abstract void setDocumentSelectionPlacement(int var1);

    public void setDoFileSizeCheck(boolean doCheck) {
        if (doCheck != this.doFileSizeCheck) {
            this.doFileSizeCheck = doCheck;
            this.firePropertyChange(FILE_SIZE_CHECK_PROPERTY, !doCheck, doCheck);
        }
    }

    public void setFractionalFontMetricsEnabled(boolean enabled) {
        if (this.fractionalMetricsEnabled != enabled) {
            this.fractionalMetricsEnabled = enabled;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                this.getRTextEditorPaneAt(i).setFractionalFontMetricsEnabled(enabled);
            }
            this.firePropertyChange(FRACTIONAL_METRICS_PROPERTY, !enabled, enabled);
        }
    }

    public void setGuessFileContentType(boolean guess) {
        if (guess != this.guessFileContentType) {
            this.guessFileContentType = guess;
            int docCount = this.getNumDocuments();
            for (int i = 0; i < docCount; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                String style = this.getSyntaxStyleForFile(textArea.getFileName());
                this.setSyntaxStyle(textArea, style);
            }
        }
    }

    public void setGutterBorderColor(Color c) {
        if (c != null && !c.equals(this.gutterBorderColor)) {
            int docCount = this.getNumDocuments();
            for (int i = 0; i < docCount; ++i) {
                Gutter g = this.getRTextScrollPaneAt(i).getGutter();
                g.setBorderColor(c);
            }
            this.gutterBorderColor = c;
        }
    }

    public void setHighlightModifiedDocumentDisplayNames(boolean highlight) {
        if (highlight != this.highlightModifiedDocDisplayNames) {
            this.highlightModifiedDocDisplayNames = highlight;
            this.refreshDisplayNames();
        }
    }

    public void setHighlightSecondaryLanguages(boolean highlight) {
        if (highlight != this.highlightSecondaryLanguages) {
            this.highlightSecondaryLanguages = highlight;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setHighlightSecondaryLanguages(highlight);
            }
        }
    }

    public void setHyperlinkColor(Color c) {
        if (c != null && !c.equals(this.getHyperlinkColor())) {
            this.hyperlinkColor = c;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setHyperlinkForeground(c);
            }
        }
    }

    public void setHyperlinkModifierKey(int key) {
        switch (key) {
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                break;
            }
            default: {
                key = 128;
            }
        }
        if (key != this.hyperlinkModifierKey) {
            this.hyperlinkModifierKey = key;
            int docCount = this.getNumDocuments();
            for (int i = 0; i < docCount; ++i) {
                this.getRTextEditorPaneAt(i).setLinkScanningMask(key);
            }
        }
    }

    public void setHyperlinksEnabled(boolean enabled) {
        if (enabled != this.hyperlinksEnabled) {
            this.hyperlinksEnabled = enabled;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setHyperlinksEnabled(enabled);
            }
        }
    }

    public void setIgnoreBackupExtensions(boolean ignore) {
        if (ignore != this.ignoreBackupExtensions) {
            this.ignoreBackupExtensions = ignore;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                String newStyle;
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                String oldStyle = textArea.getSyntaxEditingStyle();
                if (oldStyle.equals(newStyle = this.getSyntaxStyleForFile(textArea.getFileName()))) continue;
                this.setSyntaxStyle(textArea, newStyle);
                if (textArea != this.currentTextArea) continue;
                textArea.repaint();
            }
        }
    }

    public void setLineNumberColor(Color c) {
        if (c != null && !c.equals(this.lineNumberColor)) {
            int docCount = this.getNumDocuments();
            for (int i = 0; i < docCount; ++i) {
                Gutter g = this.getRTextScrollPaneAt(i).getGutter();
                g.setLineNumberColor(c);
            }
            this.lineNumberColor = c;
        }
    }

    public void setLineNumberFont(Font f) {
        if (f != null && !f.equals(this.lineNumberFont)) {
            int docCount = this.getNumDocuments();
            for (int i = 0; i < docCount; ++i) {
                Gutter g = this.getRTextScrollPaneAt(i).getGutter();
                g.setLineNumberFont(f);
            }
            this.lineNumberFont = f;
        }
    }

    public void setLineNumbersEnabled(boolean enabled) {
        if (enabled != this.lineNumbersEnabled) {
            this.lineNumbersEnabled = enabled;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextScrollPaneAt(i).setLineNumbersEnabled(enabled);
            }
        }
    }

    public void setLineTerminator(String terminator) {
        if (terminator != null && terminator.equals(System.getProperty("line.separator"))) {
            terminator = null;
        }
        this.defaultLineTerminator = terminator;
    }

    public void setLineWrap(boolean enabled) {
        if (enabled != this.lineWrapEnabled) {
            this.lineWrapEnabled = enabled;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setLineWrap(enabled);
            }
        }
    }

    public void setMarginLineColor(Color color) {
        if (!color.equals(this.marginLineColor)) {
            this.marginLineColor = color;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setMarginLineColor(this.marginLineColor);
            }
        }
    }

    public void setMarginLineEnabled(boolean enabled) {
        if (this.marginLineEnabled != enabled) {
            this.marginLineEnabled = enabled;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setMarginLineEnabled(enabled);
            }
        }
    }

    public void setMarginLinePosition(int position) {
        if (this.marginLinePosition != position) {
            this.marginLinePosition = position;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setMarginLinePosition(this.marginLinePosition);
            }
        }
    }

    public void setMarkAllHighlightColor(Color color) {
        if (color != null && !color.equals(this.markAllHighlightColor)) {
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                this.getRTextEditorPaneAt(i).setMarkAllHighlightColor(color);
            }
            Color oldColor = this.markAllHighlightColor;
            this.markAllHighlightColor = color;
            this.firePropertyChange(MARK_ALL_COLOR_PROPERTY, oldColor, color);
        }
    }

    public void setMarkOccurrences(boolean markOccurrences) {
        if (markOccurrences != this.markOccurrences) {
            this.markOccurrences = markOccurrences;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                this.getRTextEditorPaneAt(i).setMarkOccurrences(markOccurrences);
            }
            this.firePropertyChange(MARK_OCCURRENCES_PROPERTY, !markOccurrences, markOccurrences);
        }
    }

    public void setMarkOccurrencesColor(Color color) {
        if (color != null && this.markOccurrencesColor != color) {
            Color old = this.markOccurrencesColor;
            this.markOccurrencesColor = color;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                this.getRTextEditorPaneAt(i).setMarkOccurrencesColor(color);
            }
            this.firePropertyChange(MARK_OCCURRENCES_COLOR_PROPERTY, old, color);
        }
    }

    public void setMatchBothBrackets(boolean matchBoth) {
        if (this.matchBothBrackets != matchBoth) {
            this.matchBothBrackets = matchBoth;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setPaintMatchedBracketPair(matchBoth);
            }
        }
    }

    public void setMatchedBracketBGColor(Color color) {
        if (color != this.matchedBracketBGColor) {
            this.matchedBracketBGColor = color;
            int num = this.getNumDocuments();
            for (int i = 0; i < num; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.setMatchedBracketBGColor(this.matchedBracketBGColor);
            }
        }
    }

    public void setMatchedBracketBorderColor(Color color) {
        if (color != this.matchedBracketBorderColor) {
            this.matchedBracketBorderColor = color;
            int num = this.getNumDocuments();
            for (int i = 0; i < num; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.setMatchedBracketBorderColor(this.matchedBracketBorderColor);
            }
        }
    }

    public void setMaxFileSize(float size) {
        if (this.maxFileSize != size) {
            float old = this.maxFileSize;
            this.maxFileSize = size;
            this.firePropertyChange(MAX_FILE_SIZE_PROPERTY, old, this.maxFileSize);
        }
    }

    public void setModifiedDocumentDisplayNamesColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.modifiedDocumentDisplayNameColor = color;
        this.refreshDisplayNames();
    }

    public void setPrintFont(Font newPrintFont) {
        this.printFont = newPrintFont;
    }

    void setRecordingMacro(boolean recording) {
        Cursor cursor = recording ? AbstractMainView.getMacroCursor() : Cursor.getPredefinedCursor(2);
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
            textArea.setCursor(cursor);
        }
    }

    public void setRememberWhitespaceLines(boolean remember) {
        if (remember != this.rememberWhitespaceLines) {
            this.rememberWhitespaceLines = remember;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.setClearWhitespaceLinesEnabled(!this.rememberWhitespaceLines);
            }
            this.firePropertyChange(REMEMBER_WS_LINES_PROPERTY, !remember, remember);
        }
    }

    public void setRoundedSelectionEdges(boolean rounded) {
        if (rounded != this.roundedSelectionEdges) {
            this.roundedSelectionEdges = rounded;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.setRoundedSelectionEdges(rounded);
            }
            this.firePropertyChange(ROUNDED_SELECTION_PROPERTY, !rounded, rounded);
        }
    }

    public void setSecondaryLanguageColor(int index, Color color) {
        if (color != null && !color.equals(this.secondaryLanguageColors[index])) {
            this.secondaryLanguageColors[index] = color;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setSecondaryLanguageBackground(index + 1, color);
            }
        }
    }

    public abstract void setSelectedIndex(int var1);

    public boolean setSelectedTextArea(RTextEditorPane textArea) {
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            RTextEditorPane ta2 = this.getRTextEditorPaneAt(i);
            if (ta2 == null || ta2 != textArea) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public void setSelectedTextColor(Color color) {
        if (color != null && color != this.selectedTextColor) {
            this.selectedTextColor = color;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setSelectedTextColor(color);
            }
        }
    }

    public void setSelectionColor(Color color) {
        if (color != null && color != this.selectionColor) {
            this.selectionColor = color;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setSelectionColor(color);
            }
        }
    }

    public void setShowEOLMarkers(boolean show) {
        if (show != this.showEOLMarkers) {
            this.showEOLMarkers = show;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setEOLMarkersVisible(this.showEOLMarkers);
            }
        }
    }

    public void setShowTabLines(boolean show) {
        if (show != this.showTabLines) {
            this.showTabLines = show;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setPaintTabLines(this.showTabLines);
            }
        }
    }

    public void setSyntaxFilters(SyntaxFilters syntaxFilters) {
        this.syntaxFilters.setPreservingPluginAdded(syntaxFilters);
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            String newStyle;
            RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
            String oldStyle = textArea.getSyntaxEditingStyle();
            if (oldStyle.equals(newStyle = this.getSyntaxStyleForFile(textArea.getFileName()))) continue;
            this.setSyntaxStyle(textArea, newStyle);
            if (textArea != this.currentTextArea) continue;
            textArea.repaint();
        }
    }

    public void setSyntaxScheme(SyntaxScheme colorScheme) {
        if (this.currentTextArea == null) {
            this.addNewEmptyUntitledFile();
        }
        int numDocuments = this.getNumDocuments();
        if (colorScheme != null) {
            for (int i = 0; i < numDocuments; ++i) {
                this.getRTextEditorPaneAt(i).setSyntaxScheme(colorScheme);
            }
        } else {
            for (int i = 0; i < numDocuments; ++i) {
                this.getRTextEditorPaneAt(i).restoreDefaultSyntaxScheme();
            }
        }
    }

    private void setSyntaxStyle(RTextEditorPane pane, String style) {
        String fileName = pane.getFileName().toLowerCase();
        if (this.getIgnoreBackupExtensions()) {
            fileName = RTextUtilities.stripBackupExtensions(fileName);
        }
        if (this.getGuessFileContentType() && fileName.indexOf(46) == -1 && "text/plain".equals(style)) {
            AbstractMainView.guessContentType(pane);
        } else {
            pane.setSyntaxEditingStyle(style);
        }
        this.spellingSupport.forceSpellCheck(pane);
    }

    public void setTabsEmulated(boolean areEmulated) {
        if (areEmulated != this.emulateTabsWithWhitespace) {
            this.emulateTabsWithWhitespace = areEmulated;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setTabsEmulated(areEmulated);
            }
        }
    }

    public void setTabLinesColor(Color color) {
        if (color != null && !color.equals(this.tabLinesColor)) {
            this.tabLinesColor = color;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setTabLineColor(this.tabLinesColor);
            }
        }
    }

    public void setTabSize(int newSize) {
        if (newSize < 0) {
            return;
        }
        if (newSize != this.tabSize) {
            this.tabSize = newSize;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setTabSize(newSize);
            }
        }
    }

    public void setTextAreaFont(Font font, boolean underline) {
        if (font == null) {
            font = RTextEditorPane.getDefaultFont();
        }
        if (!font.equals(this.textAreaFont) || underline != this.textAreaUnderline) {
            int docCount = this.getNumDocuments();
            for (int i = 0; i < docCount; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.setFont(font);
            }
        }
        this.textAreaFont = font;
        this.textAreaUnderline = underline;
    }

    public void setTextAreaForeground(Color fg) {
        if (fg != null && !fg.equals(this.textAreaForeground)) {
            this.textAreaForeground = fg;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.setForeground(this.textAreaForeground);
            }
        }
    }

    public void setTextAreaOrientation(ComponentOrientation o) {
        if (o == null) {
            o = ComponentOrientation.LEFT_TO_RIGHT;
        }
        if (this.textAreaOrientation == null || o.isLeftToRight() != this.textAreaOrientation.isLeftToRight()) {
            this.textAreaOrientation = o;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                RTextEditorPane textArea = this.getRTextEditorPaneAt(i);
                textArea.applyComponentOrientation(this.textAreaOrientation);
            }
        }
    }

    public void setTextMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        this.textMode = mode;
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            this.getRTextEditorPaneAt(i).setTextMode(mode);
        }
    }

    public void setUseSelectedTextColor(boolean use) {
        if (use != this.useSelectedTextColor) {
            this.useSelectedTextColor = use;
            for (int i = 0; i < this.getNumDocuments(); ++i) {
                this.getRTextEditorPaneAt(i).setUseSelectedTextColor(use);
            }
        }
    }

    public void setWhitespaceVisible(boolean visible) {
        if (this.whitespaceVisible != visible) {
            this.whitespaceVisible = visible;
            int count = this.getNumDocuments();
            for (int i = 0; i < count; ++i) {
                this.getRTextEditorPaneAt(i).setWhitespaceVisible(visible);
            }
        }
    }

    public void setWriteBOMInUtf8Files(boolean write) {
        UnicodeWriter.setWriteUtf8BOM((boolean)write);
    }

    public void updateLookAndFeel() {
        this.searchManager.updateUI();
        if (this.goToDialog != null) {
            SwingUtilities.updateComponentTreeUI((Component)this.goToDialog);
            this.goToDialog.pack();
        }
        if (this.findInFilesDialog != null) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)this.findInFilesDialog));
            this.findInFilesDialog.updateUI();
            this.findInFilesDialog.pack();
        }
        this.refreshActiveLineRangeColors();
        for (int i = 0; i < this.getNumDocuments(); ++i) {
            this.getRTextEditorPaneAt(i).setBackgroundObject(this.backgroundObject);
        }
        if (this.currentTextArea != null) {
            this.currentTextArea.repaint();
        }
    }

    protected void updateStatusBar() {
        StatusBar statusBar = (StatusBar)this.owner.getStatusBar();
        if (statusBar != null) {
            statusBar.setReadOnlyIndicatorEnabled(this.currentTextArea.isReadOnly());
            int lineNumber = this.currentTextArea.getCaretLineNumber();
            int lineStartOffset = this.currentTextArea.getLineStartOffsetOfCurrentLine();
            statusBar.setRowAndColumn(lineNumber + 1, this.currentTextArea.getCaretPosition() - lineStartOffset + 1);
        }
    }
}

