/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Element;
import org.fife.help.HelpDialog;
import org.fife.jgoodies.looks.common.ShadowPopupFactory;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rtext.AWTExceptionHandler;
import org.fife.rtext.AboutDialog;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.ChildWindowListener;
import org.fife.rtext.IconGroupLoader;
import org.fife.rtext.RTextActionInfo;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextMDIView;
import org.fife.rtext.RTextMenuBar;
import org.fife.rtext.RTextPrefs;
import org.fife.rtext.RTextSplitPaneView;
import org.fife.rtext.RTextTabbedPaneView;
import org.fife.rtext.RTextUtilities;
import org.fife.rtext.RTextWindowListener;
import org.fife.rtext.RecentFileManager;
import org.fife.rtext.RemoteFileChooser;
import org.fife.rtext.SearchToolBar;
import org.fife.rtext.SpellingErrorWindow;
import org.fife.rtext.StatusBar;
import org.fife.rtext.StoreKeeper;
import org.fife.rtext.ToolBar;
import org.fife.rtext.actions.ActionFactory;
import org.fife.rtext.optionsdialog.OptionsDialog;
import org.fife.ui.CustomizableToolBar;
import org.fife.ui.SplashScreen;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.UIUtil;
import org.fife.ui.WebLookAndFeelUtils;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.AbstractPluggableGUIApplication;
import org.fife.ui.app.ExceptionDialog;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.GUIApplicationPrefs;
import org.fife.ui.app.Plugin;
import org.fife.ui.app.StandardAction;
import org.fife.ui.app.ThirdPartyLookAndFeelManager;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowPanel;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.ui.rtextfilechooser.FileChooserOwner;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.util.TranslucencyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RText
extends AbstractPluggableGUIApplication<RTextPrefs>
implements ActionListener,
CaretListener,
PropertyChangeListener,
RTextActionInfo,
FileChooserOwner {
    public static final int TABBED_VIEW = 0;
    public static final int SPLIT_PANE_VIEW = 1;
    public static final int MDI_VIEW = 2;
    public static final String ICON_STYLE_PROPERTY = "RText.iconStyle";
    public static final String MAIN_VIEW_STYLE_PROPERTY = "RText.mainViewStyle";
    private Map<String, IconGroup> iconGroupMap;
    private RTextMenuBar menuBar;
    public org.fife.ui.OptionsDialog optionsDialog;
    private CollapsibleSectionPanel csp;
    private AbstractMainView mainView;
    private int mainViewStyle;
    private RTextFileChooser chooser;
    private RemoteFileChooser rfc;
    private HelpDialog helpDialog;
    private SpellingErrorWindow spellingWindow;
    private SyntaxScheme colorScheme;
    private IconGroup iconGroup;
    private String workingDirectory;
    private String newFileName;
    private SearchToolBar searchBar;
    private boolean showHostName;
    private boolean windowListenersInited;
    private ChildWindowListener searchWindowOpacityListener;
    private boolean searchWindowOpacityEnabled;
    private float searchWindowOpacity;
    private int searchWindowOpacityRule;
    private String hostName;
    private RecentFileManager recentFileManager;
    private int lastPluginCount;
    public static final String PROPERTY_PRINT_START_TIMES = "printStartTimes";
    public static final String VERSION_STRING = "2.5.6.20141220";

    public RText(String[] filesToOpen) {
        super("rtext", "RText.jar");
        this.init(filesToOpen);
    }

    public RText(String[] filesToOpen, RTextPrefs preferences) {
        super("rtext", "RText.jar", (GUIApplicationPrefs)preferences);
        this.init(filesToOpen);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("TileVertically")) {
            ((RTextMDIView)this.mainView).tileWindowsVertically();
        } else if (command.equals("TileHorizontally")) {
            ((RTextMDIView)this.mainView).tileWindowsHorizontally();
        } else if (command.equals("Cascade")) {
            ((RTextMDIView)this.mainView).cascadeWindows();
        }
    }

    public void addDockableWindow(DockableWindow wind) {
        ((DockableWindowPanel)this.mainContentPanel).addDockableWindow(wind);
    }

    public boolean areTabsEmulated() {
        return this.mainView.areTabsEmulated();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        RTextEditorPane textArea = this.mainView.getCurrentTextArea();
        int dot = textArea.getCaretPosition();
        Element map = textArea.getDocument().getDefaultRootElement();
        int line = map.getElementIndex(dot);
        int lineStartOffset = map.getElement(line).getStartOffset();
        ((StatusBar)this.getStatusBar()).setRowAndColumn(line + 1, dot - lineStartOffset + 1);
    }

    public void convertOpenFilesSpacesToTabs() {
        this.mainView.convertOpenFilesSpacesToTabs();
    }

    public void convertOpenFilesTabsToSpaces() {
        this.mainView.convertOpenFilesTabsToSpaces();
    }

    protected JDialog createAboutDialog() {
        return new AboutDialog(this);
    }

    protected void createActions(RTextPrefs prefs) {
        ActionFactory.addActions(this, prefs);
        this.loadActionShortcuts(RText.getShortcutsFile());
    }

    protected JMenuBar createMenuBar(RTextPrefs prefs) {
        this.menuBar = new RTextMenuBar(this, UIManager.getLookAndFeel().getName(), prefs);
        this.mainView.addPropertyChangeListener(this.menuBar);
        this.menuBar.setWindowMenuVisible(prefs.mainView == 2);
        return this.menuBar;
    }

    protected SplashScreen createSplashScreen() {
        String img = "org/fife/rtext/graphics/" + this.getString("Splash", new Object[0]);
        return new SplashScreen(img, this.getString("Initializing", new Object[0]));
    }

    protected org.fife.ui.StatusBar createStatusBar(RTextPrefs prefs) {
        StatusBar sb = new StatusBar(this, this.getString("Ready", new Object[0]), !prefs.wordWrap, 1, 1, prefs.textMode == 1);
        sb.setStyle(prefs.statusBarStyle);
        return sb;
    }

    protected CustomizableToolBar createToolBar(RTextPrefs prefs) {
        ToolBar toolBar = new ToolBar("rtext - Toolbar", this, (StatusBar)this.getStatusBar());
        toolBar.checkForLargeIcons();
        return toolBar;
    }

    public void displayException(Dialog owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo((Component)owner);
        ed.setTitle(this.getString("ErrorDialogTitle", new Object[0]));
        ed.setVisible(true);
    }

    public void displayException(Frame owner, Throwable t, String desc) {
        ExceptionDialog ed = new ExceptionDialog(owner, t);
        if (desc != null) {
            ed.setDescription(desc);
        }
        ed.setLocationRelativeTo((Component)owner);
        ed.setTitle(this.getString("ErrorDialogTitle", new Object[0]));
        ed.setVisible(true);
    }

    public void doExit() {
        boolean allDocumentsClosed = this.getMainView().closeAllDocuments();
        if (allDocumentsClosed) {
            if (StoreKeeper.getInstanceCount() == 1) {
                this.savePreferences();
                boolean saved = RTextEditorPane.saveTemplates();
                if (!saved) {
                    String title = this.getString("ErrorDialogTitle", new Object[0]);
                    String text = this.getString("TemplateSaveError", new Object[0]);
                    JOptionPane.showMessageDialog((Component)((Object)this), text, title, 0);
                }
                if (this.chooser != null) {
                    RTextUtilities.saveFileChooserFavorites(this);
                }
                AWTExceptionHandler.shutdown();
                System.exit(0);
            } else {
                this.setVisible(false);
                StoreKeeper.removeRTextInstance(this);
                this.dispose();
            }
        }
    }

    public void focusDockableWindowGroup(int group) {
        DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
        if (!dwp.focusDockableWindowGroup(group)) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)((Object)this));
        }
    }

    public String getNewFileName() {
        return this.newFileName;
    }

    public org.fife.ui.OptionsDialog getOptionsDialog() {
        int pluginCount = this.getPlugins().length;
        if (this.optionsDialog == null || pluginCount != this.lastPluginCount) {
            this.optionsDialog = new OptionsDialog(this);
            this.optionsDialog.setLocationRelativeTo((Component)((Object)this));
        }
        return this.optionsDialog;
    }

    public CollapsibleSectionPanel getCollapsibleSectionPanel() {
        return this.csp;
    }

    public RTextFileChooser getFileChooser() {
        if (this.chooser == null) {
            this.chooser = RTextUtilities.createFileChooser(this);
        }
        return this.chooser;
    }

    public int getFocusedDockableWindowGroup() {
        DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
        return dwp.getFocusedDockableWindowGroup();
    }

    public HelpDialog getHelpDialog() {
        if (this.helpDialog == null) {
            String contentsPath = this.getInstallLocation() + "/doc/";
            String helpPath = contentsPath + this.getLanguage() + "/";
            File test = new File(helpPath);
            if (!test.isDirectory()) {
                helpPath = contentsPath + "en/";
            }
            this.helpDialog = new HelpDialog((GUIApplication)this, contentsPath + "HelpDialogContents.xml", helpPath);
            this.helpDialog.setBackButtonIcon(this.iconGroup.getIcon("back"));
            this.helpDialog.setForwardButtonIcon(this.iconGroup.getIcon("forward"));
        }
        this.helpDialog.setLocationRelativeTo((Component)((Object)this));
        return this.helpDialog;
    }

    public synchronized String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                this.hostName = "Unknown";
            }
        }
        return this.hostName;
    }

    public IconGroup getIconGroup() {
        return this.iconGroup;
    }

    public Map<String, IconGroup> getIconGroupMap() {
        return this.iconGroupMap;
    }

    public AbstractMainView getMainView() {
        return this.mainView;
    }

    public int getMainViewStyle() {
        return this.mainViewStyle;
    }

    protected String getPreferencesClassName() {
        return "org.fife.rtext.RTextPrefs";
    }

    public List<FileLocation> getRecentFiles() {
        return this.recentFileManager.getRecentFiles();
    }

    public RemoteFileChooser getRemoteFileChooser() {
        if (this.rfc == null) {
            this.rfc = new RemoteFileChooser(this);
        }
        return this.rfc;
    }

    public String getResourceBundleClassName() {
        return "org.fife.rtext.RText";
    }

    public SearchToolBar getSearchToolBar() {
        if (this.searchBar == null) {
            this.searchBar = new SearchToolBar("Search", this, (StatusBar)this.getStatusBar());
            this.searchBar.setVisible(false);
            this.addToolBar(this.searchBar, "South");
        }
        return this.searchBar;
    }

    public float getSearchWindowOpacity() {
        return this.searchWindowOpacity;
    }

    public int getSearchWindowOpacityRule() {
        return this.searchWindowOpacityRule;
    }

    private static final File getShortcutsFile() {
        return new File(RTextUtilities.getPreferencesDirectory(), "shortcuts.properties");
    }

    public boolean getShowHostName() {
        return this.showHostName;
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.colorScheme;
    }

    public int getTabSize() {
        return this.mainView.getTabSize();
    }

    public String getTitle() {
        String title = super.getTitle();
        int hyphen = title.indexOf("- ");
        if (hyphen > -1) {
            title = title.substring(hyphen + 2);
        }
        return title;
    }

    public String getVersionString() {
        return VERSION_STRING;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected void handleInstallPlugin(Plugin plugin) {
        RTextEditorPane textArea = this.getMainView().getCurrentTextArea();
        if (textArea != null) {
            textArea.requestFocusInWindow();
        }
    }

    public boolean hasDockableWindowGroup(int group) {
        DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
        return dwp.hasDockableWindowGroup(group);
    }

    private void init(String[] filesToOpen) {
        this.lastPluginCount = -1;
        this.openFiles(filesToOpen);
    }

    public boolean isSearchToolBarVisible() {
        return this.searchBar == null ? false : this.searchBar.isVisible();
    }

    public boolean isSearchWindowOpacityEnabled() {
        return this.searchWindowOpacityEnabled;
    }

    public boolean isSpellingWindowVisible() {
        return this.spellingWindow != null && this.spellingWindow.isActive();
    }

    private void loadPossibleIconGroups() {
        this.iconGroupMap = IconGroupLoader.loadIconGroups(this, this.getInstallLocation() + "/icongroups/ExtraIcons.xml");
    }

    public void menuItemAcceleratorWorkaround() {
        this.menuBar.menuItemAcceleratorWorkaround();
    }

    public void openFiles(String[] filesToOpen) {
        int count = filesToOpen == null ? 0 : filesToOpen.length;
        for (int i = 0; i < count; ++i) {
            this.openFile(filesToOpen[i]);
        }
    }

    protected void preDisplayInit(RTextPrefs prefs, SplashScreen splashScreen) {
        CodeTemplateManager ctm;
        long start = System.currentTimeMillis();
        File prefsDir = RTextUtilities.getPreferencesDirectory();
        if (!prefsDir.isDirectory()) {
            prefsDir.mkdirs();
        }
        super.preDisplayInit((GUIApplicationPrefs)prefs, splashScreen);
        if (prefs.searchToolBarVisible) {
            this.addToolBar(this.getSearchToolBar(), "South");
            this.searchBar.setVisible(true);
        }
        splashScreen.updateStatus(this.getString("AddingFinalTouches", new Object[0]), 90);
        this.addWindowListener(new RTextWindowListener(this));
        this.setDefaultCloseOperation(0);
        this.mainView.setLineNumbersEnabled(prefs.lineNumbersVisible);
        if (RTextUtilities.enableTemplates(this, true) && (ctm = RTextEditorPane.getCodeTemplateManager()).getTemplateCount() == 0) {
            RTextUtilities.addDefaultCodeTemplates();
        }
        this.setSearchWindowOpacityEnabled(prefs.searchWindowOpacityEnabled);
        this.setSearchWindowOpacity(prefs.searchWindowOpacity);
        this.setSearchWindowOpacityRule(prefs.searchWindowOpacityRule);
        this.recentFileManager = new RecentFileManager(this);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preDisplayInit: " + (System.currentTimeMillis() - start));
        }
        RTextUtilities.setDropShadowsEnabledInEditor(prefs.dropShadowsInEditor);
    }

    protected void preMenuBarInit(RTextPrefs prefs, SplashScreen splashScreen) {
        long start = System.currentTimeMillis();
        this.setSplitPaneDividerLocation(0, prefs.dividerLocations[0]);
        this.setSplitPaneDividerLocation(1, prefs.dividerLocations[1]);
        this.setSplitPaneDividerLocation(2, prefs.dividerLocations[2]);
        this.setSplitPaneDividerLocation(3, prefs.dividerLocations[3]);
        this.setSpellingWindowVisible(prefs.viewSpellingList);
        this.setShowHostName(prefs.showHostName);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preMenuBarInit: " + (System.currentTimeMillis() - start));
        }
    }

    protected void preStatusBarInit(RTextPrefs prefs, SplashScreen splashScreen) {
        long start = System.currentTimeMillis();
        String[] filesToOpen = null;
        this.newFileName = this.getString("NewFileName", new Object[0]);
        splashScreen.updateStatus(this.getString("SettingSHColors", new Object[0]), 10);
        this.setSyntaxScheme(prefs.colorScheme);
        this.setWorkingDirectory(prefs.workingDirectory);
        splashScreen.updateStatus(this.getString("CreatingView", new Object[0]), 20);
        switch (prefs.mainView) {
            case 0: {
                this.mainViewStyle = 0;
                this.mainView = new RTextTabbedPaneView(this, filesToOpen, prefs);
                break;
            }
            case 1: {
                this.mainViewStyle = 1;
                this.mainView = new RTextSplitPaneView(this, filesToOpen, prefs);
                break;
            }
            default: {
                this.mainViewStyle = 2;
                this.mainView = new RTextMDIView(this, filesToOpen, prefs);
            }
        }
        this.csp = new CollapsibleSectionPanel(false);
        this.csp.add((Component)this.mainView);
        this.getContentPane().add((Component)this.csp);
        splashScreen.updateStatus(this.getString("CreatingStatusBar", new Object[0]), 25);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preStatusBarInit: " + (System.currentTimeMillis() - start));
        }
    }

    protected void preToolBarInit(RTextPrefs prefs, SplashScreen splashScreen) {
        long start = System.currentTimeMillis();
        StatusBar statusBar = (StatusBar)this.getStatusBar();
        this.mainView.addPropertyChangeListener(statusBar);
        this.loadPossibleIconGroups();
        try {
            this.setIconGroupByName(prefs.iconGroupName);
        }
        catch (InternalError ie) {
            this.displayException(ie);
            System.exit(0);
        }
        splashScreen.updateStatus(this.getString("CreatingToolBar", new Object[0]), 60);
        if (Boolean.getBoolean(PROPERTY_PRINT_START_TIMES)) {
            System.err.println("preToolbarInit: " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("TextEditorPane.fileFullPath")) {
            this.setTitle((String)e.getNewValue());
        } else if (propertyName.equals("TextEditorPane.dirty")) {
            String oldTitle = this.getTitle();
            boolean newValue = (Boolean)e.getNewValue();
            if (!newValue) {
                this.setTitle(oldTitle.substring(0, oldTitle.length() - 1));
            } else {
                this.setTitle(oldTitle + '*');
            }
        }
    }

    public void registerChildWindowListeners(Window w) {
        if (!this.windowListenersInited) {
            this.windowListenersInited = true;
            if (TranslucencyUtil.get().isTranslucencySupported(false)) {
                this.searchWindowOpacityListener = new ChildWindowListener(this);
                this.searchWindowOpacityListener.setTranslucencyRule(this.searchWindowOpacityRule);
            }
        }
        if (this.searchWindowOpacityListener != null) {
            w.addWindowFocusListener(this.searchWindowOpacityListener);
            w.addComponentListener(this.searchWindowOpacityListener);
        }
    }

    public void removeDockableWindow(DockableWindow wind) {
        ((DockableWindowPanel)this.mainContentPanel).removeDockableWindow(wind);
    }

    public void restoreDefaultAccelerators() {
        for (Action a : this.getActions()) {
            if (!(a instanceof StandardAction)) continue;
            ((StandardAction)a).restoreDefaultAccelerator();
        }
        this.menuItemAcceleratorWorkaround();
    }

    public void savePreferences() {
        new RTextPrefs().populate(this).save();
        this.saveActionShortcuts(RText.getShortcutsFile());
        Plugin[] plugins = this.getPlugins();
        int count = plugins.length;
        for (int i = 0; i < count; ++i) {
            plugins[i].savePreferences();
        }
        if (this.chooser != null) {
            this.chooser.savePreferences();
        }
    }

    public void setIconGroupByName(String name) {
        IconGroup newGroup = this.iconGroupMap.get(name);
        if (newGroup == null) {
            newGroup = this.iconGroupMap.get("Eclipse Icons");
        }
        if (newGroup == null) {
            throw new InternalError("No icon groups!");
        }
        if (this.iconGroup != null && this.iconGroup.equals((Object)newGroup)) {
            return;
        }
        Dimension size = this.getSize();
        IconGroup old = this.iconGroup;
        this.iconGroup = newGroup;
        Icon icon = this.iconGroup.getIcon("new");
        this.getAction("newAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("open");
        this.getAction("openAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("save");
        this.getAction("saveAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("saveall");
        this.getAction("saveAllAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("openinnewwindow");
        this.getAction("openNewWinAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("saveas");
        this.getAction("saveAsAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("options");
        this.getAction("optionsAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("help");
        this.getAction("helpAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("about");
        this.getAction("aboutAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("close");
        this.getAction("closeAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("find");
        this.getAction("findAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("findnext");
        this.getAction("findNextAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("replace");
        this.getAction("replaceAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("replacenext");
        this.getAction("replaceNextAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("print");
        this.getAction("printAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("printpreview");
        this.getAction("printPreviewAction").putValue("SmallIcon", icon);
        icon = this.iconGroup.getIcon("closeall");
        this.getAction("closeAllAction").putValue("SmallIcon", icon);
        RTextEditorPane.setIconGroup((IconGroup)this.iconGroup);
        ToolBar toolBar = (ToolBar)this.getToolBar();
        if (toolBar != null) {
            toolBar.checkForLargeIcons();
        }
        if (this.isDisplayable()) {
            this.pack();
            this.setSize(size);
        }
        if (this.helpDialog != null) {
            this.helpDialog.setBackButtonIcon(this.iconGroup.getIcon("back"));
            this.helpDialog.setForwardButtonIcon(this.iconGroup.getIcon("forward"));
        }
        this.firePropertyChange(ICON_STYLE_PROPERTY, old, this.iconGroup);
    }

    public void setMainViewStyle(int viewStyle) {
        if ((viewStyle == 0 || viewStyle == 1 || viewStyle == 2) && viewStyle != this.mainViewStyle) {
            int oldMainViewStyle = this.mainViewStyle;
            this.mainViewStyle = viewStyle;
            AbstractMainView fromView = this.mainView;
            RTextPrefs prefs = new RTextPrefs().populate(this);
            switch (viewStyle) {
                case 0: {
                    this.mainView = new RTextTabbedPaneView(this, null, prefs);
                    this.menuBar.setWindowMenuVisible(false);
                    break;
                }
                case 1: {
                    this.mainView = new RTextSplitPaneView(this, null, prefs);
                    this.menuBar.setWindowMenuVisible(false);
                    break;
                }
                case 2: {
                    this.mainView = new RTextMDIView(this, null, prefs);
                    this.menuBar.setWindowMenuVisible(true);
                }
            }
            PropertyChangeListener[] propertyChangeListeners = fromView.getPropertyChangeListeners();
            int length = propertyChangeListeners.length;
            for (int i = 0; i < length; ++i) {
                fromView.removePropertyChangeListener(propertyChangeListeners[i]);
                this.mainView.addPropertyChangeListener(propertyChangeListeners[i]);
            }
            this.mainView.getSearchManager().changeSearchListener(fromView);
            this.mainView.copyData(fromView);
            if (this.mainView instanceof RTextTabbedPaneView && this.mainView.getSelectedIndex() == this.mainView.getNumDocuments() - 1) {
                ((RTextTabbedPaneView)this.mainView).stateChanged(new ChangeEvent(this.mainView));
            }
            Dimension size = this.getSize();
            this.csp.remove((Component)fromView);
            this.csp.add((Component)this.mainView);
            fromView.dispose();
            fromView = null;
            this.pack();
            this.setSize(size);
            if (this.mainView instanceof RTextMDIView) {
                this.mainView.setSelectedIndex(this.mainView.getSelectedIndex());
            }
            this.firePropertyChange(MAIN_VIEW_STYLE_PROPERTY, oldMainViewStyle, this.mainViewStyle);
        }
    }

    public void setMessages(String fileFullPath, String statusMessage) {
        StatusBar statusBar;
        if (fileFullPath != null) {
            this.setTitle(fileFullPath);
        }
        if ((statusBar = (StatusBar)this.getStatusBar()) != null && statusMessage != null) {
            statusBar.setStatusMessage(statusMessage);
        }
    }

    public void setRowColumnIndicatorVisible(boolean isVisible) {
        ((StatusBar)this.getStatusBar()).setRowColumnIndicatorVisible(isVisible);
    }

    public void setShowHostName(boolean show) {
        if (this.showHostName != show) {
            this.showHostName = show;
            this.setTitle(this.getTitle());
        }
    }

    public void setStatusBarReadOnlyIndicatorEnabled(boolean enabled) {
        ((StatusBar)this.getStatusBar()).setReadOnlyIndicatorEnabled(enabled);
    }

    public void setSyntaxScheme(SyntaxScheme colorScheme) {
        if (colorScheme != null && !colorScheme.equals((Object)this.colorScheme)) {
            this.colorScheme = (SyntaxScheme)colorScheme.clone();
            if (this.mainView != null) {
                this.mainView.setSyntaxScheme(this.colorScheme);
            }
        }
    }

    public void setTabsEmulated(boolean areEmulated) {
        this.mainView.setTabsEmulated(areEmulated);
    }

    public void setTabSize(int newSize) {
        this.mainView.setTabSize(newSize);
    }

    public void setTitle(String title) {
        title = this.getShowHostName() ? "rtext (" + this.getHostName() + ") - " + title : "rtext - " + title;
        super.setTitle(title);
    }

    public void setSearchWindowOpacity(float opacity) {
        this.searchWindowOpacity = Math.max(0.0f, Math.min(opacity, 1.0f));
        if (this.windowListenersInited && this.isSearchWindowOpacityEnabled()) {
            this.searchWindowOpacityListener.refreshTranslucencies();
        }
    }

    public void setSearchWindowOpacityEnabled(boolean enabled) {
        if (enabled != this.searchWindowOpacityEnabled) {
            this.searchWindowOpacityEnabled = enabled;
            if (this.windowListenersInited && this.searchWindowOpacityListener != null) {
                this.searchWindowOpacityListener.refreshTranslucencies();
            }
        }
    }

    public void setSearchWindowOpacityRule(int rule) {
        if (rule != this.searchWindowOpacityRule) {
            this.searchWindowOpacityRule = rule;
            if (this.windowListenersInited) {
                this.searchWindowOpacityListener.setTranslucencyRule(rule);
            }
        }
    }

    public void setSpellingWindowVisible(boolean visible) {
        if (visible) {
            if (this.spellingWindow == null) {
                this.spellingWindow = new SpellingErrorWindow(this);
                DockableWindowPanel dwp = (DockableWindowPanel)this.mainContentPanel;
                dwp.addDockableWindow((DockableWindow)this.spellingWindow);
            } else {
                this.spellingWindow.setActive(true);
            }
        } else if (this.spellingWindow != null) {
            this.spellingWindow.setActive(false);
        }
    }

    public void setWorkingDirectory(String directory) {
        File test = new File(directory);
        this.workingDirectory = test.isDirectory() ? directory : System.getProperty("user.dir");
    }

    public void updateLookAndFeel(LookAndFeel lnf) {
        super.updateLookAndFeel(lnf);
        try {
            Dimension size = this.getSize();
            SwingUtilities.updateComponentTreeUI((Component)((Object)this));
            this.pack();
            this.setSize(size);
            this.mainView.updateLookAndFeel();
            if (this.optionsDialog != null) {
                SwingUtilities.updateComponentTreeUI((Component)this.optionsDialog);
                this.optionsDialog.pack();
            }
            if (this.helpDialog != null) {
                SwingUtilities.updateComponentTreeUI((Component)this.helpDialog);
                this.helpDialog.pack();
            }
            if (this.chooser != null) {
                SwingUtilities.updateComponentTreeUI((Component)this.chooser);
                this.chooser.updateUI();
            }
            if (this.rfc != null) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.rfc));
                this.rfc.updateUI();
            }
        }
        catch (Exception f) {
            this.displayException(f);
        }
    }

    public void preferences() {
        this.getAction("optionsAction").actionPerformed(new ActionEvent(this, 0, "unused"));
    }

    public void openFile(final String filename) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RText.this.mainView.openFile(filename, null, true);
            }
        });
    }

    public static void main(final String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        AWTExceptionHandler.register();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String lafName = RTextPrefs.getLookAndFeelToLoad();
                if (SubstanceUtils.isASubstanceLookAndFeel((String)lafName)) {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
                String rootDir = AbstractGUIApplication.getLocationOfJar((String)"RText.jar");
                ThirdPartyLookAndFeelManager lafManager = new ThirdPartyLookAndFeelManager(rootDir);
                try {
                    ClassLoader cl = lafManager.getLAFClassLoader();
                    if (WebLookAndFeelUtils.isWebLookAndFeel((String)lafName)) {
                        WebLookAndFeelUtils.installWebLookAndFeelProperties((ClassLoader)cl);
                    } else {
                        ShadowPopupFactory.install();
                    }
                    UIManager.getLookAndFeelDefaults().put("ClassLoader", cl);
                    Class<?> clazz = null;
                    try {
                        clazz = cl.loadClass(lafName);
                    }
                    catch (UnsupportedClassVersionError ucve) {
                        lafName = UIManager.getSystemLookAndFeelClassName();
                        clazz = cl.loadClass(lafName);
                    }
                    LookAndFeel laf = (LookAndFeel)clazz.newInstance();
                    UIManager.setLookAndFeel(laf);
                    UIManager.getLookAndFeelDefaults().put("ClassLoader", cl);
                    UIUtil.installOsSpecificLafTweaks();
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (SubstanceUtils.isSubstanceInstalled()) {
                    try {
                        SubstanceUtils.setAnimationSpeed((long)100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                RText rtext = new RText(args);
                rtext.setLookAndFeelManager(lafManager);
                if (rtext.getMainViewStyle() == 2) {
                    rtext.getMainView().setSelectedIndex(0);
                }
                StoreKeeper.addRTextInstance(rtext);
            }
        });
    }
}

