/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.Sides;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.ui.app.GUIApplication;
import org.fife.ui.app.StandardAction;

class PrintAction
extends StandardAction {
    public PrintAction(RText owner, ResourceBundle msg, Icon icon) {
        super((GUIApplication)owner, msg, "PrintAction");
        this.setIcon(icon);
    }

    public void actionPerformed(ActionEvent e) {
        RText owner = (RText)this.getApplication();
        RTextEditorPane textArea = owner.getMainView().getCurrentTextArea();
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
        attributeSet.add(new JobName(textArea.getFileFullPath(), null));
        attributeSet.add(new Copies(1));
        attributeSet.add(Sides.ONE_SIDED);
        attributeSet.add(OrientationRequested.PORTRAIT);
        PrintService[] services = PrintServiceLookup.lookupPrintServices(flavor, null);
        if (services == null || services.length == 0) {
            ResourceBundle msg = owner.getResourceBundle();
            JOptionPane.showMessageDialog((Component)((Object)owner), msg.getString("ErrorNoPrintServices"), msg.getString("ErrorDialogTitle"), 0);
            return;
        }
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService chosenService = ServiceUI.printDialog(null, 200, 200, services, defaultService, flavor, attributeSet);
        if (chosenService != null) {
            DocPrintJob job = chosenService.createPrintJob();
            SimpleDoc myDoc = new SimpleDoc((Object)textArea, flavor, null);
            try {
                job.print(myDoc, attributeSet);
            }
            catch (PrintException pe) {
                ResourceBundle msg = owner.getResourceBundle();
                JOptionPane.showMessageDialog((Component)((Object)owner), msg.getString("ErrorDialogPrintText") + pe + ".", msg.getString("ErrorDialogTitle"), 0);
            }
        }
    }
}

