/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import org.fife.ui.ColorCellRenderer;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;

class SubstanceTextColorCellRenderer
extends SubstanceDefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    SubstanceTextColorCellRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object color, boolean selected, boolean focused, int row, int col) {
        super.getTableCellRendererComponent(table, color, selected, focused, row, col);
        if (!selected && !SubstanceTextColorCellRenderer.substanceAndRollover(table, row, col)) {
            if (table.isEnabled()) {
                this.setForeground((Color)color);
            } else {
                this.setForeground(((Color)color).darker());
            }
        }
        String text = null;
        if (row == 0) {
            text = "filename.ext";
        } else {
            String ext = table.getModel().getValueAt(row, 0).toString();
            text = "filename." + ext;
        }
        this.setText(text);
        this.setComponentOrientation(table.getComponentOrientation());
        return this;
    }

    public String getToolTipText() {
        return ColorCellRenderer.getToolTipText(this.getForeground());
    }

    private static final boolean substanceAndRollover(JTable table, int row, int col) {
        SubstanceTableUI.TableCellId cellId;
        SubstanceTableUI ui = (SubstanceTableUI)table.getUI();
        ComponentState state = ui.getCellState(cellId = new SubstanceTableUI.TableCellId(row, col));
        return state == ComponentState.ROLLOVER_ARMED || state == ComponentState.ROLLOVER_SELECTED || state == ComponentState.ROLLOVER_UNSELECTED;
    }
}

