/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport;

import java.awt.Component;
import java.io.IOException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ColumnMappingTableModel;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.SpecialColumnMapping;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.UnsupportedFormatException;
import net.sourceforge.squirrel_sql.plugins.dataimport.util.DateUtils;

public class ImportDataIntoTableExecutor {
    private static final ILogger log = LoggerController.createLogger(ImportDataIntoTableExecutor.class);
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ImportDataIntoTableExecutor.class);
    private Thread execThread = null;
    private ISession session = null;
    private ITableInfo table = null;
    private TableColumnInfo[] columns = null;
    private ColumnMappingTableModel columnMapping = null;
    private IFileImporter importer = null;
    private List<String> importerColumns = null;
    private boolean skipHeader = false;
    private final boolean _singleTransaction;
    private final int _commitAfterEveryInserts;

    public ImportDataIntoTableExecutor(ISession session, ITableInfo table, TableColumnInfo[] columns, List<String> importerColumns, ColumnMappingTableModel mapping, IFileImporter importer, boolean singleTransaction, int commitAfterEveryInserts) {
        this.session = session;
        this.table = table;
        this.columns = columns;
        this.columnMapping = mapping;
        this.importer = importer;
        this.importerColumns = importerColumns;
        this._singleTransaction = singleTransaction;
        this._commitAfterEveryInserts = commitAfterEveryInserts;
    }

    public void setSkipHeader(boolean skip) {
        this.skipHeader = skip;
    }

    public void execute() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ImportDataIntoTableExecutor.this._execute(ImportDataIntoTableExecutor.this._singleTransaction, ImportDataIntoTableExecutor.this._commitAfterEveryInserts);
            }
        };
        this.execThread = new Thread(runnable);
        this.execThread.setName("Dataimport Executor Thread");
        this.execThread.setUncaughtExceptionHandler(this.createUncaughtExceptionHandler());
        this.execThread.start();
    }

    /*
     * Exception decompiling
     */
    private void _execute(boolean singleTransaction, int commitAfterEveryInserts) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Thread.UncaughtExceptionHandler createUncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, final Throwable e) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        throw new RuntimeException(e);
                    }
                });
            }
        };
    }

    private void finishTransaction(ISQLConnection conn, boolean success) {
        try {
            if (success) {
                conn.commit();
            } else {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                log.error((Object)"Finally failed to rollback connection");
            }
            throw new RuntimeException(e);
        }
    }

    private void setOriginalAutoCommit(ISQLConnection conn, boolean originalAutoCommit) {
        try {
            conn.setAutoCommit(originalAutoCommit);
        }
        catch (SQLException e) {
            this._showMessageDialogOnEDT(stringMgr.getString("ImportDataIntoTableExecutor.reestablish.autocommit.failed"), stringMgr.getString("ImportDataIntoTableExecutor.reestablish.autocommit.failed.title"), 0);
            throw new RuntimeException(e);
        }
    }

    private boolean getOriginalAutoCommit(ISQLConnection conn) {
        try {
            return conn.getAutoCommit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void _showMessageDialogOnEDT(String string, String title) {
        this._showMessageDialogOnEDT(string, title, 0);
    }

    private void showMessageDialogOnEDT(String message) {
        this._showMessageDialogOnEDT(message, null, -1);
    }

    private void _showMessageDialogOnEDT(final String message, final String title, final int messageType) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (null == title) {
                    JOptionPane.showMessageDialog((Component)ImportDataIntoTableExecutor.this.session.getApplication().getMainFrame(), message);
                } else {
                    JOptionPane.showMessageDialog((Component)ImportDataIntoTableExecutor.this.session.getApplication().getMainFrame(), message, title, messageType);
                }
            }
        }, (boolean)true);
    }

    private void bindAutoincrementColumn(PreparedStatement stmt, int index, TableColumnInfo column, int counter) throws SQLException, UnsupportedFormatException {
        long value = 0L;
        String fixedValue = this.getFixedValue(column);
        try {
            value = Long.parseLong(fixedValue);
            value += (long)counter;
        }
        catch (NumberFormatException nfe) {
            throw new UnsupportedFormatException("Could not interpret value for column " + column.getColumnName() + " as value of type long. The value is: " + fixedValue, nfe);
        }
        switch (column.getDataType()) {
            case -5: {
                stmt.setLong(index, value);
                break;
            }
            case 2: 
            case 4: {
                stmt.setInt(index, (int)value);
                break;
            }
            default: {
                throw new UnsupportedFormatException("Autoincrement column " + column.getColumnName() + "  is not numeric");
            }
        }
    }

    private void bindFixedColumn(PreparedStatement stmt, int index, TableColumnInfo column) throws SQLException, IOException, UnsupportedFormatException {
        String value = this.getFixedValue(column);
        Object d = null;
        switch (column.getDataType()) {
            case -5: {
                try {
                    stmt.setLong(index, Long.parseLong(value));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new UnsupportedFormatException(nfe);
                }
            }
            case 2: 
            case 4: {
                this.setIntOrUnsignedInt(stmt, index, column);
                break;
            }
            case 91: {
                this.setDateOrNull(stmt, index, value);
                break;
            }
            case 93: {
                this.setTimeStampOrNull(stmt, index, value);
                break;
            }
            case 92: {
                this.setTimeOrNull(stmt, index, value);
                break;
            }
            default: {
                stmt.setString(index, value);
            }
        }
    }

    private void setDateOrNull(PreparedStatement stmt, int index, String value) throws UnsupportedFormatException, SQLException {
        if (null != value) {
            java.util.Date d = DateUtils.parseSQLFormats(value);
            if (d == null) {
                throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + value);
            }
            stmt.setDate(index, new Date(d.getTime()));
        } else {
            stmt.setNull(index, 91);
        }
    }

    private void setTimeStampOrNull(PreparedStatement stmt, int index, String value) throws UnsupportedFormatException, SQLException {
        if (null != value) {
            java.util.Date d = DateUtils.parseSQLFormats(value);
            if (d == null) {
                throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + value);
            }
            stmt.setTimestamp(index, new Timestamp(d.getTime()));
        } else {
            stmt.setNull(index, 93);
        }
    }

    private void setTimeOrNull(PreparedStatement stmt, int index, String value) throws UnsupportedFormatException, SQLException {
        if (null != value) {
            java.util.Date d = DateUtils.parseSQLFormats(value);
            if (d == null) {
                throw new UnsupportedFormatException("Could not interpret value as date type. Value is: " + value);
            }
            stmt.setTime(index, new Time(d.getTime()));
        } else {
            stmt.setNull(index, 92);
        }
    }

    private void bindColumn(PreparedStatement stmt, int index, TableColumnInfo column) throws SQLException, UnsupportedFormatException, IOException {
        int mappedColumn = this.getMappedColumn(column);
        switch (column.getDataType()) {
            case -5: {
                this.setLongOrNull(stmt, index, mappedColumn);
                break;
            }
            case 2: 
            case 4: {
                this.setIntOrUnsignedInt(stmt, index, column);
                break;
            }
            case 91: {
                this.setDateOrNull(stmt, index, mappedColumn);
                break;
            }
            case 93: {
                this.setTimestampOrNull(stmt, index, mappedColumn);
                break;
            }
            case 92: {
                this.setTimeOrNull(stmt, index, mappedColumn);
                break;
            }
            default: {
                this.setStringOrNull(stmt, index, mappedColumn);
            }
        }
    }

    private void setStringOrNull(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException {
        String string = this.importer.getString(mappedColumn);
        if (null != string) {
            stmt.setString(index, string);
        } else {
            stmt.setNull(index, 12);
        }
    }

    private void setTimeOrNull(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException, UnsupportedFormatException {
        java.util.Date date = this.importer.getDate(mappedColumn);
        if (null != date) {
            stmt.setTime(index, new Time(date.getTime()));
        } else {
            stmt.setNull(index, 92);
        }
    }

    private void setTimestampOrNull(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException, UnsupportedFormatException {
        java.util.Date date = this.importer.getDate(mappedColumn);
        if (null != date) {
            stmt.setTimestamp(index, new Timestamp(date.getTime()));
        } else {
            stmt.setNull(index, 93);
        }
    }

    private void setDateOrNull(PreparedStatement stmt, int index, int mappedColumn) throws SQLException, IOException, UnsupportedFormatException {
        java.util.Date date = this.importer.getDate(mappedColumn);
        if (null != date) {
            stmt.setDate(index, new Date(date.getTime()));
        } else {
            stmt.setNull(index, 91);
        }
    }

    private void setIntOrUnsignedInt(PreparedStatement stmt, int index, TableColumnInfo column) throws SQLException, UnsupportedFormatException, IOException {
        int mappedColumn = this.getMappedColumn(column);
        String columnTypeName = column.getTypeName();
        if (columnTypeName != null && (columnTypeName.endsWith("UNSIGNED") || columnTypeName.endsWith("unsigned"))) {
            this.setLongOrNull(stmt, index, mappedColumn);
        }
        try {
            this.setIntOrNull(stmt, index, mappedColumn);
        }
        catch (UnsupportedFormatException e) {
            this.setLongOrNull(stmt, index, mappedColumn);
        }
    }

    private void setLongOrNull(PreparedStatement stmt, int index, int mappedColumn) throws IOException, UnsupportedFormatException, SQLException {
        Long long1 = this.importer.getLong(mappedColumn);
        if (null == long1) {
            stmt.setNull(index, 4);
        } else {
            stmt.setLong(index, long1);
        }
    }

    private void setIntOrNull(PreparedStatement stmt, int index, int mappedColumn) throws IOException, UnsupportedFormatException, SQLException {
        Integer int1 = this.importer.getInt(mappedColumn);
        if (null == int1) {
            stmt.setNull(index, 4);
        } else {
            stmt.setInt(index, int1);
        }
    }

    private int getMappedColumn(TableColumnInfo column) {
        return this.importerColumns.indexOf(this.getMapping(column));
    }

    private String getMapping(TableColumnInfo column) {
        int pos = this.columnMapping.findTableColumn(column.getColumnName());
        return this.columnMapping.getValueAt(pos, 1).toString();
    }

    private String getFixedValue(TableColumnInfo column) {
        int pos = this.columnMapping.findTableColumn(column.getColumnName());
        return this.columnMapping.getValueAt(pos, 2).toString();
    }

    private String createColumnList() {
        StringBuffer columnsList = new StringBuffer();
        for (TableColumnInfo column : this.columns) {
            String mapping = this.getMapping(column);
            if (SpecialColumnMapping.SKIP.getVisibleString().equals(mapping)) continue;
            if (columnsList.length() != 0) {
                columnsList.append(", ");
            }
            columnsList.append(column.getColumnName());
        }
        return columnsList.toString();
    }

    private int getColumnCount() {
        int count = 0;
        for (TableColumnInfo column : this.columns) {
            int pos = this.columnMapping.findTableColumn(column.getColumnName());
            String mapping = this.columnMapping.getValueAt(pos, 1).toString();
            if (SpecialColumnMapping.SKIP.getVisibleString().equals(mapping)) continue;
            ++count;
        }
        return count;
    }

    private String getQuestionMarks(int count) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            result.append("?");
            if (i >= count - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

