/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.plugins.dataimport.action.ImportTableDataCommand;

public class ImportTableDataAction
extends SquirrelAction
implements ISessionAction {
    private static final long serialVersionUID = -8807675482631144975L;
    private ISession session;

    public ImportTableDataAction(IApplication app, IResources resources) {
        super(app, resources);
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.session != null) {
            IObjectTreeAPI treeAPI = this.session.getSessionInternalFrame().getObjectTreeAPI();
            IDatabaseObjectInfo[] tables = treeAPI.getSelectedDatabaseObjects();
            if (tables.length == 1 && tables[0] instanceof ITableInfo) {
                try {
                    new ImportTableDataCommand(this.session, (ITableInfo)tables[0]).execute();
                }
                catch (Throwable th) {
                    this.session.showErrorMessage(th);
                }
            } else {
                this.session.showErrorMessage("Importing data into a table works with one table only!");
            }
        }
    }
}

