/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dataimport.prefs.DataImportPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dataimport.prefs.PreferencesManager;

public class PreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 7648092437088098470L;
    DataImportPreferenceBean prefs = null;
    JCheckBox truncateCheckBox = null;
    private static final ILogger log = LoggerController.createLogger(PreferencesPanel.class);
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(PreferencesPanel.class);

    public PreferencesPanel(DataImportPreferenceBean prefs) {
        this.prefs = prefs;
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        FormLayout layout = new FormLayout("left:pref:grow", "12dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        this.truncateCheckBox = new JCheckBox(stringMgr.getString("PreferencesPanel.truncateTable"));
        int y = 1;
        builder.add((Component)this.truncateCheckBox, cc.xy(1, y));
        this.add(builder.getPanel());
    }

    private void loadData() {
        this.truncateCheckBox.setSelected(this.prefs.isUseTruncate());
    }

    private void save() {
        this.prefs.setUseTruncate(this.truncateCheckBox.isSelected());
        PreferencesManager.savePrefs();
    }

    public void applyChanges() {
        this.save();
    }

    public Component getPanelComponent() {
        return this;
    }
}

