/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel.ExcelSettingsBean;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelSettingsPanel
extends JPanel {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ExcelSettingsPanel.class);
    private ExcelSettingsBean settings = null;
    private Workbook wb = null;
    private JComboBox sheetName = null;

    public ExcelSettingsPanel(ExcelSettingsBean settings, File f) {
        this.settings = settings;
        try {
            this.wb = WorkbookFactory.create((File)f);
        }
        catch (Exception e) {
            this.wb = null;
        }
        this.init();
        this.loadSettings();
    }

    private void init() {
        ActionListener stateChangedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExcelSettingsPanel.this.stateChanged();
            }
        };
        this.sheetName = new JComboBox();
        if (this.wb != null) {
            int nSheets = this.wb.getNumberOfSheets();
            for (int i = 0; i < nSheets; ++i) {
                this.sheetName.addItem(this.wb.getSheetAt(i).getSheetName());
            }
        }
        this.sheetName.addActionListener(stateChangedListener);
        FormLayout layout = new FormLayout("pref, 6dlu, pref:grow", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        int y = 1;
        builder.addSeparator(stringMgr.getString("ExcelSettingsPanel.xlsSettings"), cc.xywh(1, y, 3, 1));
        builder.add((Component)new JLabel(stringMgr.getString("ExcelSettingsPanel.sheetName")), cc.xy(1, y += 2));
        builder.add((Component)this.sheetName, cc.xy(3, y));
        this.add(builder.getPanel());
    }

    private void applySettings() {
        if (this.sheetName.getSelectedItem() != null) {
            this.settings.setSheetName(this.sheetName.getSelectedItem().toString());
        }
    }

    private void loadSettings() {
        if (this.settings.getSheetName() == null) {
            this.sheetName.setSelectedIndex(0);
        } else {
            this.sheetName.setSelectedItem(this.settings.getSheetName());
        }
    }

    private void stateChanged() {
        this.applySettings();
    }
}

