/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.h2;

import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.h2.exp.H2SequenceInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.h2.exp.H2TableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.h2.exp.H2TableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.h2.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.IndexSourceTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.h2.tab.ViewSourceTab;

public class H2Plugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(H2Plugin.class);
    private static final ILogger s_log = LoggerController.createLogger(H2Plugin.class);
    private IObjectTreeAPI _treeAPI;

    public String getInternalName() {
        return "h2";
    }

    public String getDescriptiveName() {
        return "H2 Plugin";
    }

    public String getVersion() {
        return "0.02";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                H2Plugin.this.updateTreeApi(session);
            }
        });
        return new PluginSessionCallbackAdaptor((IPlugin)this);
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isH2((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(ISession session) {
        IQueryTokenizer qt = session.getQueryTokenizer();
        String stmtSep = qt.getSQLStatementSeparator();
        this._treeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
        this._treeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new H2SequenceInodeExpanderFactory(), DatabaseObjectType.SEQUENCE));
        TableWithChildNodesExpander tableExp = new TableWithChildNodesExpander();
        tableExp.setTableIndexExtractor((ITableIndexExtractor)new H2TableIndexExtractorImpl());
        tableExp.setTableTriggerExtractor((ITableTriggerExtractor)new H2TableTriggerExtractorImpl());
        this._treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExp);
        this._treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep));
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexSourceTab(i18n.SHOW_INDEX_SOURCE, stmtSep));
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailsTab());
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOW_INDEX_SOURCE = H2Plugin.access$000().getString("PostgresPlugin.showIndexSource");
        public static final String SHOW_VIEW_SOURCE = H2Plugin.access$000().getString("PostgresPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = H2Plugin.access$000().getString("PostgresPlugin.showProcedureSource");
    }
}

