/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HQLEntryPanelManager;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.IHibernateTabController;

public class HQLPanelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HQLPanelController.class);
    private IHibernateTabController _hibernateTabController;
    private ISession _sess;
    private HibernatePluginResources _resource;
    private HibernateConnection _con;
    private AbstractAction _runHQL;
    private HQLEntryPanelManager _hqlEntryPanelManager;

    public HQLPanelController(IHibernateTabController hibernateTabController, ISession sess, HibernatePluginResources resource) {
        this._hibernateTabController = hibernateTabController;
        this._sess = sess;
        this._resource = resource;
        this._hqlEntryPanelManager = new HQLEntryPanelManager(this._sess, resource, hibernateTabController.getHibernateConnectionProvider());
    }

    void initActions() {
        this._runHQL = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HQLPanelController.this.onRunHQL();
            }
        };
        this._runHQL.putValue("SmallIcon", this._resource.getIcon("run"));
        this._runHQL.putValue("Name", s_stringMgr.getString("hibernate.hqlToSqlLong"));
        this._runHQL.putValue("ShortDescription", s_stringMgr.getString("hibernate.hqlToSqlShort"));
        this._runHQL.setEnabled(false);
        this._hibernateTabController.addToToolbar(this._runHQL);
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, 2);
        this._hqlEntryPanelManager.registerKeyboardAction(this._runHQL, ctrlEnter);
    }

    private void onRunHQL() {
        if (!this._runHQL.isEnabled()) {
            return;
        }
        String hql = this._hqlEntryPanelManager.getEntryPanel().getSQLToBeExecuted();
        if (null == hql || 0 == hql.trim().length()) {
            return;
        }
        IQueryTokenizer queryTokenizer = this._sess.getQueryTokenizer();
        String statementSeparator = queryTokenizer.getSQLStatementSeparator();
        String startOfLineComment = queryTokenizer.getLineCommentBegin();
        QueryTokenizer qt = new QueryTokenizer(statementSeparator, startOfLineComment, true);
        qt.setScriptToTokenize(hql);
        while (qt.hasQuery()) {
            String hqlQuery = qt.nextQuery();
            this._hibernateTabController.displayObjects(this._con, hqlQuery);
        }
    }

    public void setConnection(HibernateConnection con) {
        this._con = con;
        if (null == this._con) {
            this._runHQL.setEnabled(false);
        } else {
            this._runHQL.setEnabled(true);
        }
    }

    public JComponent getComponent() {
        return this._hqlEntryPanelManager.getComponent();
    }

    public void requestFocus() {
        this._hqlEntryPanelManager.requestFocus();
    }
}

