/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.server;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ClassPathUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateConfiguration;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernateServerConnectionImpl;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ReflectionCaller;

public class IntraVmConnectionFactory {
    public HibernateServerConnection createHibernateConnection(HibernateConfiguration cfg, boolean isServer) {
        try {
            URLClassLoader cl = IntraVmConnectionFactory.getClassLoader(cfg);
            Thread.currentThread().setContextClassLoader(cl);
            Object sessionFactoryImpl = null;
            if (cfg.isUserDefinedProvider()) {
                String provider = cfg.getProvider();
                Class<?> providerClass = cl.loadClass(provider);
                Object sessionFactoryProviderImpl = providerClass.newInstance();
                sessionFactoryImpl = new ReflectionCaller(sessionFactoryProviderImpl).callMethod("getSessionFactoryImpl").getCallee();
            } else if (cfg.isJPA()) {
                String persistenceUnitName = cfg.getPersistenceUnitName();
                Class<?> persistenceClass = cl.loadClass("javax.persistence.Persistence");
                Method createMeth = persistenceClass.getMethod("createEntityManagerFactory", String.class);
                Object hibernateEntityManagerFactory = createMeth.invoke(persistenceClass, persistenceUnitName);
                ReflectionCaller rc = new ReflectionCaller(hibernateEntityManagerFactory);
                sessionFactoryImpl = rc.callMethod("getSessionFactory").getCallee();
            } else {
                Class<?> confiugrationClass = cl.loadClass("org.hibernate.cfg.Configuration");
                ReflectionCaller rc = new ReflectionCaller(confiugrationClass.newInstance());
                sessionFactoryImpl = rc.callMethod("configure").callMethod("buildSessionFactory").getCallee();
            }
            Thread.currentThread().setContextClassLoader(null);
            return new HibernateServerConnectionImpl(sessionFactoryImpl, cl, isServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static URLClassLoader getClassLoader(HibernateConfiguration cfg) throws Exception {
        String[] classpath = ClassPathUtil.classPathAsStringArray(cfg.getClassPathItems());
        URL[] classpathUrls = new URL[classpath.length];
        for (int i = 0; i < classpathUrls.length; ++i) {
            classpathUrls[i] = new File(classpath[i]).toURI().toURL();
        }
        return new URLClassLoader(classpathUrls, null);
    }
}

