/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mysql.action.RenameTableCommand;

public class RenameTableAction
extends SquirrelAction
implements ISessionAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RenameTableAction.class);
    private static final ILogger s_log = LoggerController.createLogger(RenameTableAction.class);
    private ISession _session;
    private final MysqlPlugin _plugin;

    public RenameTableAction(IApplication app, IResources resources, MysqlPlugin plugin) {
        super(app, resources);
        this._plugin = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            IObjectTreeAPI treeAPI = this._session.getSessionInternalFrame().getObjectTreeAPI();
            IDatabaseObjectInfo[] tables = treeAPI.getSelectedDatabaseObjects();
            if (tables.length == 1) {
                String title;
                ITableInfo ti = (ITableInfo)tables[0];
                String msg = s_stringMgr.getString("RenameTableAction.newnameprompt", new Object[]{ti.getQualifiedName()});
                String newTableName = JOptionPane.showInputDialog(null, msg, title = s_stringMgr.getString("RenameTableAction.rename"), 3);
                if (newTableName != null && newTableName.length() > 0) {
                    try {
                        new RenameTableCommand(this._session, (IPlugin)this._plugin, ti, newTableName).execute();
                    }
                    catch (Throwable th) {
                        this._session.showErrorMessage(th);
                        s_log.error((Object)"Error occurred renaming table", th);
                    }
                }
            } else {
                this._session.getApplication().showErrorDialog(s_stringMgr.getString("mysql.selectSingleTable"));
            }
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }
}

