/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.gui.OutputLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;

class SessionSettingsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionSettingsPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(SessionSettingsPanel.class);
    private final WebServicePreferences _prefs;
    private final WebServiceSessionProperties _sessionProps;
    private JCheckBox _anonDBMSChk = new JCheckBox(s_stringMgr.getString("sqlval.settingsAnon"));
    private OutputLabel _dbmsNameLbl = new OutputLabel(" ");
    private OutputLabel _dbmsVersionLbl = new OutputLabel(" ");
    private OutputLabel _techNameLbl = new OutputLabel(" ");
    private OutputLabel _techVersionLbl = new OutputLabel(" ");

    SessionSettingsPanel(WebServicePreferences prefs, WebServiceSessionProperties sessionProps) {
        super(new GridBagLayout());
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        if (sessionProps == null) {
            throw new IllegalArgumentException("WebServiceSessionProperties == null");
        }
        this._prefs = prefs;
        this._sessionProps = sessionProps;
        this.createGUI();
        this.loadData();
    }

    void loadData() {
        this._anonDBMSChk.setSelected(this._sessionProps.getUseAnonymousDBMS());
        this._dbmsNameLbl.setText(this._sessionProps.getTargetDBMSName());
        this._dbmsVersionLbl.setText(this._sessionProps.getTargetDBMSVersion());
        this._techNameLbl.setText(this._sessionProps.getConnectionTechnology());
        this._techVersionLbl.setText(this._sessionProps.getConnectionTechnologyVersion());
    }

    void save() {
        this._sessionProps.setUseAnonymousDBMS(this._anonDBMSChk.isSelected());
    }

    private void createGUI() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(1, 4, 1, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.createDBMSPanel(), gbc);
    }

    private JPanel createDBMSPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("sqlval.dbms")));
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(2, 4, 2, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 18;
        pnl.add((Component)this._anonDBMSChk, gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.dbmsName"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.dbmsVersion"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.technology"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("sqlval.technologyVersion"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        pnl.add((Component)this._dbmsNameLbl, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._dbmsVersionLbl, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._techNameLbl, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._techVersionLbl, gbc);
        return pnl;
    }
}

