/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.swingviolations;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class EDTViolationRepaintManager
extends RepaintManager {
    private RepaintManager delegate;
    private boolean completeCheck = true;
    private WeakReference<JComponent> lastComponent;
    private static ILogger log = LoggerController.createLogger(EDTViolationRepaintManager.class);
    private IApplication app;

    public EDTViolationRepaintManager(boolean completeCheck, IApplication app) {
        this.completeCheck = completeCheck;
        this.delegate = RepaintManager.currentManager(null);
        this.app = app;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public synchronized void addInvalidComponent(JComponent invalidComponent) {
        this.checkThreadViolations(invalidComponent);
        this.delegate.addInvalidComponent(invalidComponent);
    }

    @Override
    public void removeInvalidComponent(JComponent component) {
        this.delegate.removeInvalidComponent(component);
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        this.checkThreadViolations(c);
        this.delegate.addDirtyRegion(c, x, y, w, h);
    }

    @Override
    public void addDirtyRegion(Window window, int x, int y, int w, int h) {
        this.delegate.addDirtyRegion(window, x, y, w, h);
    }

    @Override
    public void addDirtyRegion(Applet applet, int x, int y, int w, int h) {
        this.delegate.addDirtyRegion(applet, x, y, w, h);
    }

    @Override
    public Rectangle getDirtyRegion(JComponent aComponent) {
        return this.delegate.getDirtyRegion(aComponent);
    }

    @Override
    public void markCompletelyDirty(JComponent aComponent) {
        this.delegate.markCompletelyDirty(aComponent);
    }

    @Override
    public void markCompletelyClean(JComponent aComponent) {
        this.delegate.markCompletelyClean(aComponent);
    }

    @Override
    public boolean isCompletelyDirty(JComponent aComponent) {
        return this.delegate.isCompletelyDirty(aComponent);
    }

    @Override
    public void validateInvalidComponents() {
        this.delegate.validateInvalidComponents();
    }

    @Override
    public void paintDirtyRegions() {
        this.delegate.paintDirtyRegions();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Image getOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        return this.delegate.getOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        return this.delegate.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
    }

    @Override
    public void setDoubleBufferMaximumSize(Dimension d) {
        this.delegate.setDoubleBufferMaximumSize(d);
    }

    @Override
    public Dimension getDoubleBufferMaximumSize() {
        return this.delegate.getDoubleBufferMaximumSize();
    }

    @Override
    public void setDoubleBufferingEnabled(boolean aFlag) {
        this.delegate.setDoubleBufferingEnabled(aFlag);
    }

    @Override
    public boolean isDoubleBufferingEnabled() {
        return this.delegate.isDoubleBufferingEnabled();
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean imageUpdate = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.") && !st.getClassName().startsWith("javax.swing.SwingWorker")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            this.violationFound(c, stackTrace);
        }
    }

    protected void violationFound(JComponent c, StackTraceElement[] stackTrace) {
        String message = "EDT violation detected in " + c;
        log.error((Object)message, (Throwable)new RuntimeException(message));
        this.app.getMessageHandler().showErrorMessage("EDT violation detected!");
    }
}

