/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;

public class TabKeyHandler {
    private JTextArea _textComponent;
    private final int _tabLength;

    public TabKeyHandler(JTextArea textComponent, SyntaxPlugin syntaxPlugin) {
        this._textComponent = textComponent;
        this._tabLength = syntaxPlugin.getSyntaxPreferences().getTabLength();
        this._textComponent.setTabSize(this._tabLength);
        if (!syntaxPlugin.getSyntaxPreferences().isReplaceTabsBySpaces()) {
            return;
        }
        this._textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TabKeyHandler.this.onCorrectTab(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
    }

    private void onCorrectTab(final DocumentEvent e) {
        try {
            if (1 != e.getLength()) {
                return;
            }
            String insertChar = e.getDocument().getText(e.getOffset(), 1);
            if ('\t' == insertChar.charAt(0)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TabKeyHandler.this.correctTab(e);
                    }
                });
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void correctTab(DocumentEvent e) {
        int offset = e.getOffset();
        this._textComponent.replaceRange(TabKeyHandler.createStringOfBlanks(this._tabLength), offset, offset + 1);
    }

    public static String createStringOfBlanks(int n) {
        return String.format("%1$-" + n + "s", " ");
    }
}

