/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.LogFile;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.DirectoryListComboBox;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ViewLogsSheet
extends DialogWidget {
    public static final String PREF_KEY_LOGS_SHEET_WIDTH = "Squirrel.logsSheetWidth";
    public static final String PREF_KEY_LOGS_SHEET_HEIGHT = "Squirrel.logsSheetHeight";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ViewLogsSheet.class);
    private static final ILogger s_log = LoggerController.createLogger(ViewLogsSheet.class);
    private static ViewLogsSheet s_instance;
    private final IApplication _app;
    private final SquirrelPreferences _prefs;
    private final LogsComboBox _logDirCmb = new LogsComboBox();
    private final JTextArea _logContentsTxt = new JTextArea(20, 50);
    private final JButton _refreshBtn = new JButton(s_stringMgr.getString("ViewLogsSheet.refresh"));
    private final JCheckBox _errorChkbox = new JCheckBox("Errors");
    private final JCheckBox _debugChkbox = new JCheckBox("Debug");
    private final JCheckBox _infoChkbox = new JCheckBox("Info");
    private final File _logDir;
    private boolean _closing = false;
    private boolean _refreshing = false;

    private ViewLogsSheet(IApplication app) {
        super(s_stringMgr.getString("ViewLogsSheet.title"), true, true, true, true, app);
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this._prefs = this._app.getSquirrelPreferences();
        this._logDir = new ApplicationFiles().getExecutionLogFile().getParentFile();
        this.createUserInterface();
        this.setSize(this.getDimension());
    }

    private Dimension getDimension() {
        return new Dimension(Preferences.userRoot().getInt(PREF_KEY_LOGS_SHEET_WIDTH, 500), Preferences.userRoot().getInt(PREF_KEY_LOGS_SHEET_HEIGHT, 400));
    }

    public static synchronized void showSheet(IApplication app) {
        boolean wasVisible;
        if (s_instance == null) {
            s_instance = new ViewLogsSheet(app);
            app.getMainFrame().addWidget(s_instance);
            ViewLogsSheet.centerWithinDesktop(s_instance);
        }
        if (!(wasVisible = s_instance.isVisible())) {
            s_instance.setVisible(true);
        }
        s_instance.moveToFront();
        if (!wasVisible && !ViewLogsSheet.s_instance._refreshing) {
            s_instance.startRefreshingLog();
        }
    }

    public static synchronized void disposeInstance() {
        s_instance = null;
    }

    @Override
    public void dispose() {
        this._closing = true;
        ViewLogsSheet.disposeInstance();
        Dimension size = this.getSize();
        Preferences.userRoot().putInt(PREF_KEY_LOGS_SHEET_WIDTH, size.width);
        Preferences.userRoot().putInt(PREF_KEY_LOGS_SHEET_HEIGHT, size.height);
        super.dispose();
    }

    private void performClose() {
        this.dispose();
    }

    private synchronized void startRefreshingLog() {
        if (!this._refreshing) {
            this._app.getThreadPool().addTask(new Refresher());
        }
    }

    private void enableComponents(final boolean enabled) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ViewLogsSheet.this._refreshBtn.setEnabled(enabled);
                ViewLogsSheet.this._logDirCmb.setEnabled(enabled);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshLog() {
        block23: {
            block22: {
                block25: {
                    this.enableComponents(false);
                    cursorChg = new CursorChanger(this.getAwtContainer());
                    cursorChg.show();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ViewLogsSheet.this._logContentsTxt.setText("");
                            }
                        });
                    }
                    catch (Exception ex) {
                        ViewLogsSheet.s_log.error(ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.error.clearlogcontents"), ex);
                    }
                    logFile = (File)this._logDirCmb.getSelectedItem();
                    if (logFile == null) break block22;
                    try {
                        block24: {
                            if (!logFile.exists() || !logFile.canRead()) break block23;
                            rdr = new BufferedReader(new FileReader(logFile));
                            line = null;
                            chunk = new StringBuilder(16384);
lbl18:
                            // 4 sources

                            while ((line = rdr.readLine()) != null) {
                                if (this._closing) {
                                    break block24;
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl47
                        }
                        rdr.close();
                        this.enableComponents(true);
                        this._refreshing = false;
                        cursorChg.restore();
                        return;
                    }
                    catch (Exception ex) {
                        msg = ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.error.processinglogfile");
                        ViewLogsSheet.s_log.error(msg, ex);
                    }
lbl-1000:
                    // 1 sources

                    {
                        block26: {
                            if (chunk.length() <= 16000) break block26;
                            finalLine = chunk.toString();
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    if (!ViewLogsSheet.this._closing) {
                                        ViewLogsSheet.this._logContentsTxt.append(finalLine);
                                    }
                                }
                            });
                            chunk = new StringBuilder(16384);
                            ** GOTO lbl18
                        }
                        if (!this.shouldAppendLineToChunk(line)) ** GOTO lbl18
                        chunk.append(line).append('\n');
                        ** GOTO lbl18
lbl47:
                        // 1 sources

                        if (!this._closing) break block25;
                    }
                    rdr.close();
                    this.enableComponents(true);
                    this._refreshing = false;
                    cursorChg.restore();
                    return;
                }
                ** try [egrp 8[TRYBLOCK] [3 : 246->266)] { 
lbl55:
                // 1 sources

                finalLine = chunk.toString();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!ViewLogsSheet.this._closing) {
                            ViewLogsSheet.this._logContentsTxt.append(finalLine);
                        }
                    }
                });
                break block23;
lbl58:
                // 1 sources

                finally {
                    rdr.close();
                }
            }
            if (ViewLogsSheet.s_log.isDebugEnabled()) {
                ViewLogsSheet.s_log.debug(ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.info.nulllogfile"));
            }
        }
        if (this._closing) {
            return;
        }
        try {
            pos = Math.max(0, this._logContentsTxt.getText().length() - 1);
            line = this._logContentsTxt.getLineOfOffset(pos);
            finalpos = this._logContentsTxt.getLineStartOffset(line);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ViewLogsSheet.this._logContentsTxt.setCaretPosition(finalpos);
                }
            });
            return;
        }
        catch (Exception ex) {
            ViewLogsSheet.s_log.error(ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.error.setcaret"), ex);
            return;
        }
    }

    private boolean shouldAppendLineToChunk(String line) {
        boolean result = false;
        if (line == null || line.length() == 0) {
            return false;
        }
        if (this._errorChkbox.isSelected() && this._debugChkbox.isSelected() && this._infoChkbox.isSelected()) {
            return true;
        }
        int threadNameEndIdx = line.indexOf("]");
        if (threadNameEndIdx > -1) {
            int levelChar = 32;
            if (line.length() >= threadNameEndIdx + 2) {
                levelChar = line.charAt(threadNameEndIdx + 2);
            }
            if (this._errorChkbox.isSelected() && levelChar == 69) {
                result = true;
            }
            if (this._debugChkbox.isSelected() && levelChar == 68) {
                result = true;
            }
            if (this._infoChkbox.isSelected() && levelChar == 73) {
                result = true;
            }
            if (levelChar != 69 && levelChar != 68 && levelChar != 73) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private void createUserInterface() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createToolBar(), "North");
        contentPane.add((Component)this.createMainPanel(), "Center");
        contentPane.add((Component)this.createButtonsPanel(), "South");
        this.pack();
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewLogsSheet.this.performClose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private ToolBar createToolBar() {
        ToolBar tb = new ToolBar();
        tb.setUseRolloverButtons(true);
        tb.setFloatable(false);
        Object[] args = new Object[]{this.getTitle(), this._logDir.getAbsolutePath()};
        String lblTitle = s_stringMgr.getString("ViewLogsSheet.storedin", args);
        JLabel lbl = new JLabel(lblTitle);
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        tb.add(lbl);
        return tb;
    }

    private JPanel createMainPanel() {
        final TextPopupMenu pop = new TextPopupMenu();
        pop.setTextComponent(this._logContentsTxt);
        this._logContentsTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        File appLogFile = new ApplicationFiles().getExecutionLogFile();
        this._logDirCmb.load(appLogFile.getParentFile());
        if (this._logDirCmb.getModel().getSize() > 0) {
            LogFile logFile = new LogFile(appLogFile);
            this._logDirCmb.setSelectedItem(logFile);
        }
        this._logDirCmb.addActionListener(new ChangeLogListener());
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this._logDirCmb, "North");
        this._logContentsTxt.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        pnl.add((Component)new JScrollPane(this._logContentsTxt), "Center");
        return pnl;
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        pnl.add(this._refreshBtn);
        this._refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLogsSheet.this.startRefreshingLog();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("ViewLogsSheet.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLogsSheet.this.performClose();
            }
        });
        pnl.add(closeBtn);
        this._errorChkbox.setSelected(this._prefs.getShowErrorLogMessages());
        this._errorChkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogsSheet.this._prefs.setShowErrorLogMessages(ViewLogsSheet.this._errorChkbox.isSelected());
            }
        });
        this._infoChkbox.setSelected(this._prefs.getShowInfoLogMessages());
        this._infoChkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogsSheet.this._prefs.setShowInfoLogMessages(ViewLogsSheet.this._infoChkbox.isSelected());
            }
        });
        this._debugChkbox.setSelected(this._prefs.getShowDebugLogMessage());
        this._debugChkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewLogsSheet.this._prefs.setShowDebugLogMessages(ViewLogsSheet.this._debugChkbox.isSelected());
            }
        });
        pnl.add(this._errorChkbox);
        pnl.add(this._infoChkbox);
        pnl.add(this._debugChkbox);
        GUIUtils.setJButtonSizesTheSame(new JButton[]{closeBtn, this._refreshBtn});
        this.getRootPane().setDefaultButton(closeBtn);
        return pnl;
    }

    private static final class LogsComboBox
    extends DirectoryListComboBox {
        private static final long serialVersionUID = 1L;
        private File _dir;

        private LogsComboBox() {
        }

        @Override
        public void load(File dir, FilenameFilter filter) {
            this._dir = dir;
            super.load(dir, filter);
        }

        public void addItem(Object anObject) {
            super.addItem(new LogFile(this._dir, anObject.toString()));
        }
    }

    private final class Refresher
    implements Runnable {
        private Refresher() {
        }

        @Override
        public void run() {
            ViewLogsSheet.this.refreshLog();
        }
    }

    private final class ChangeLogListener
    implements ActionListener {
        private ChangeLogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ViewLogsSheet.this.startRefreshingLog();
        }
    }
}

