/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListModel;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasTreeInterface;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.IToogleableAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.JListAliasesListImpl;
import net.sourceforge.squirrel_sql.client.gui.db.JTreeAliasesListImpl;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;

public class AliasesList
implements IToogleableAliasesList {
    private JPanel _pnlContainer = new JPanel(new GridLayout(1, 1));
    private JListAliasesListImpl _jListImpl;
    private JTreeAliasesListImpl _jTreeImpl;
    private boolean _viewAsTree;

    public AliasesList(IApplication app) {
        AliasesListModel listModel = new AliasesListModel(app);
        this._jListImpl = new JListAliasesListImpl(app, listModel);
        this._jTreeImpl = new JTreeAliasesListImpl(app, listModel);
    }

    private IAliasesList getCurrentImpl() {
        if (this._viewAsTree) {
            return this._jTreeImpl;
        }
        return this._jListImpl;
    }

    @Override
    public void setViewAsTree(boolean b) {
        this._viewAsTree = b;
        if (this._viewAsTree) {
            this._pnlContainer.remove(this._jListImpl.getComponent());
            this._pnlContainer.add(this._jTreeImpl.getComponent());
        } else {
            this._pnlContainer.remove(this._jTreeImpl.getComponent());
            this._pnlContainer.add(this._jListImpl.getComponent());
        }
        this._pnlContainer.validate();
        this._pnlContainer.repaint();
    }

    @Override
    public IAliasTreeInterface getAliasTreeInterface() {
        return this._jTreeImpl;
    }

    @Override
    public void deleteSelected() {
        this.getCurrentImpl().deleteSelected();
    }

    @Override
    public void modifySelected() {
        this.getCurrentImpl().modifySelected();
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentImpl().isEmpty();
    }

    @Override
    public void goToAlias(ISQLAlias aliasToGoTo) {
        this.getCurrentImpl().goToAlias(aliasToGoTo);
    }

    @Override
    public SQLAlias getSelectedAlias(MouseEvent evt) {
        return this.getCurrentImpl().getSelectedAlias(evt);
    }

    @Override
    public void sortAliases() {
        this.getCurrentImpl().sortAliases();
    }

    @Override
    public void requestFocus() {
        this.getCurrentImpl().requestFocus();
    }

    @Override
    public JComponent getComponent() {
        return this._pnlContainer;
    }

    @Override
    public void selectListEntryAtPoint(Point point) {
        this.getCurrentImpl().selectListEntryAtPoint(point);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this._jListImpl.addMouseListener(mouseListener);
        this._jTreeImpl.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this._jListImpl.removeMouseListener(mouseListener);
        this._jTreeImpl.removeMouseListener(mouseListener);
    }
}

